/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLOverlayNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseOverlay
extends AbstractNode
implements VRMLOverlayNodeType {
    protected static final int FIELD_VISIBLE = 1;
    protected static final int FIELD_WINDOW_SIZE_CHANGED = 2;
    protected static final int FIELD_LAYOUT = 3;
    protected static final int LAST_OVERLAY_INDEX = 3;
    protected static final int NUM_FIELDS = 4;
    private static final String NEG_WINDOW_SIZE_MSG = "One of the window dimensions is less than zero";
    protected static final String BAD_PROTO_MSG = "Proto does not describe a SurfaceChildNode object";
    protected static final String BAD_NODE_MSG = "Node does not describe a SurfaceChildNode object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfVisible;
    protected float[] vfWindowSize;
    protected VRMLSurfaceLayoutNodeType vfLayout;
    protected VRMLProtoInstance pLayout;

    protected BaseOverlay() {
        super("Overlay");
        this.hasChanged = new boolean[4];
        this.vfWindowSize = new float[2];
        this.vfVisible = true;
    }

    protected BaseOverlay(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("visible");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVisible = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean isVisible() {
        return this.vfVisible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.vfVisible) {
            this.vfVisible = bl;
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
            if (this.vfLayout != null) {
                this.vfLayout.setParentVisible(bl);
            }
        }
    }

    public void surfaceSizeChanged(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(NEG_WINDOW_SIZE_MSG);
        }
        this.vfWindowSize[0] = n;
        this.vfWindowSize[1] = n2;
        if (this.vfLayout != null) {
            this.vfLayout.windowChanged(0, 0, n, n2);
        }
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public void setLayout(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType == null) {
            this.vfLayout = null;
        } else if (!(vRMLNodeType instanceof VRMLSurfaceLayoutNodeType)) {
            if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
                throw new InvalidFieldValueException(BAD_NODE_MSG);
            }
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLSurfaceLayoutNodeType)) {
                throw new InvalidFieldValueException(BAD_PROTO_MSG);
            }
            this.pLayout = vRMLProtoInstance;
            this.vfLayout = (VRMLSurfaceLayoutNodeType)vRMLNodeType2;
        } else {
            this.vfLayout = (VRMLSurfaceLayoutNodeType)vRMLNodeType;
            this.pLayout = null;
        }
        if (!this.inSetup) {
            if (this.vfLayout != null) {
                this.vfLayout.windowChanged(0, 0, (int)this.vfWindowSize[0], (int)this.vfWindowSize[1]);
            }
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public VRMLNodeType getLayout() {
        if (this.pLayout == null) {
            return this.vfLayout;
        }
        return this.pLayout;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 63;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pLayout != null) {
            this.pLayout.setupFinished();
        } else if (this.vfLayout != null) {
            this.vfLayout.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfVisible;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pLayout == null ? this.vfLayout : this.pLayout;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfWindowSize;
                vRMLFieldData.numElements = 1;
                vRMLFieldData.dataType = (short)11;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfVisible);
                    break;
                }
                case 3: {
                    if (this.pLayout != null) {
                        vRMLNodeType.setValue(n2, this.pLayout);
                        break;
                    }
                    vRMLNodeType.setValue(n2, this.vfLayout);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfWindowSize, 2);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setVisible(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.setLayout(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
        this.hasChanged[3] = true;
        this.fireFieldChanged(3);
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseOverlay.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseOverlay.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseOverlay.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFVec2f", "windowSizeChanged");
        BaseOverlay.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "layout");
        fieldMap.put("windowSizeChanged", new Integer(2));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(3);
        fieldMap.put("layout", n);
        fieldMap.put("set_layout", n);
        fieldMap.put("layout_changed", n);
    }
}

