/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.group;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseWorldInfo
extends AbstractNode
implements VRMLChildNodeType {
    private static final int FIELD_TITLE = 1;
    private static final int FIELD_INFO = 2;
    private static final int LAST_WORLDINFO_INDEX = 2;
    private static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private String[] vfInfo;
    private String vfTitle;
    private int infoLen;

    public BaseWorldInfo() {
        super("WorldInfo");
        this.hasChanged = new boolean[3];
        this.vfTitle = "";
        this.vfInfo = null;
    }

    public BaseWorldInfo(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("info");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfInfo = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfInfo, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("title");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTitle = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 67;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfInfo;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfInfo == null ? 0 : this.vfInfo.length;
                break;
            }
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfTitle;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void setValue(int n, String string) throws InvalidFieldFormatException, InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot write to initializeOnly field: title");
                }
                this.vfTitle = string;
                break;
            }
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot write to initializeOnly field: info");
                }
                this.vfInfo = new String[]{string};
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        if (n != 2) {
            super.setValue(n, stringArray, n2);
            return;
        }
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Cannot write to initializeOnly field");
        }
        this.vfInfo = stringArray;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(3);
        BaseWorldInfo.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseWorldInfo.fieldDecl[2] = new VRMLFieldDeclaration(2, "MFString", "info");
        BaseWorldInfo.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFString", "title");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("info", new Integer(2));
        fieldMap.put("title", new Integer(1));
    }
}

