/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.TreeSet;
import org.j3d.terrain.roam.DiamondComparator;
import org.j3d.terrain.roam.QueueItem;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TriangleComparator;

class TreeQueueManager
implements QueueManager {
    private TreeSet triQueue = new TreeSet(new TriangleComparator());
    private TreeSet diamondQueue = new TreeSet(new DiamondComparator());

    public void addTriangle(QueueItem queueItem) {
        if (!(queueItem instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.triQueue.add(queueItem);
    }

    public void removeTriangle(QueueItem queueItem) {
        if (!(queueItem instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.triQueue.remove(queueItem);
    }

    public void addDiamond(QueueItem queueItem) {
        if (!(queueItem instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.diamondQueue.add(queueItem);
    }

    public void removeDiamond(QueueItem queueItem) {
        if (!(queueItem instanceof TreeNode)) {
            throw new RuntimeException("Not a TreeNode");
        }
        this.diamondQueue.remove(queueItem);
    }

    public void clear() {
        this.triQueue.clear();
        this.diamondQueue.clear();
    }

    public TreeNode getSplitCandidate() {
        TreeNode treeNode = null;
        if (!this.triQueue.isEmpty()) {
            treeNode = (TreeNode)this.triQueue.last();
        }
        return treeNode;
    }

    public TreeNode getMergeCandidate() {
        TreeNode treeNode = null;
        if (!this.diamondQueue.isEmpty()) {
            treeNode = (TreeNode)this.diamondQueue.first();
        }
        return treeNode;
    }
}

