#ifndef vtk_netcdf_mangle_h
#define vtk_netcdf_mangle_h

/*

This header file mangles all symbols exported from the netcdf library.
It is included in all files while building the netcdf library.  Due to
namespace pollution, no netcdf headers should be included in .h files in
VTK.

The following command was used to obtain the symbol list:

nm libvtkNetCDF.a |grep " [TRD] "

This is the way to recreate the whole list:

nm bin/libvtkNetCDF.so |grep " [TRD] " | awk '{ print "#define "$3" vtk_netcdf_"$3 }' | \
        grep -v vtk_netcdf__fini | grep -v vtk_netcdf__init | sort

Note that _fini and _init should be excluded because they are not functions
implemented by the library but are rather created by the linker and
used when the shared library is loaded/unloaded from an executable.

*/

#define NC3__enddef vtk_netcdf_NC3__enddef
#define NC3_abort vtk_netcdf_NC3_abort
#define NC3_close vtk_netcdf_NC3_close
#define NC3_create vtk_netcdf_NC3_create
#define NC3_def_dim vtk_netcdf_NC3_def_dim
#define NC3_def_var vtk_netcdf_NC3_def_var
#define NC3_del_att vtk_netcdf_NC3_del_att
#define NC3_dispatch_table vtk_netcdf_NC3_dispatch_table
#define NC3_dispatcher vtk_netcdf_NC3_dispatcher
#define NC3_get_att vtk_netcdf_NC3_get_att
#define NC3_get_vara vtk_netcdf_NC3_get_vara
#define NC3_initialize vtk_netcdf_NC3_initialize
#define NC3_inq vtk_netcdf_NC3_inq
#define NC3_inq_att vtk_netcdf_NC3_inq_att
#define NC3_inq_attid vtk_netcdf_NC3_inq_attid
#define NC3_inq_attname vtk_netcdf_NC3_inq_attname
#define NC3_inq_base_pe vtk_netcdf_NC3_inq_base_pe
#define NC3_inq_dim vtk_netcdf_NC3_inq_dim
#define NC3_inq_dimid vtk_netcdf_NC3_inq_dimid
#define NC3_inq_format vtk_netcdf_NC3_inq_format
#define NC3_inq_type vtk_netcdf_NC3_inq_type
#define NC3_inq_unlimdim vtk_netcdf_NC3_inq_unlimdim
#define NC3_inq_var vtk_netcdf_NC3_inq_var
#define NC3_inq_varid vtk_netcdf_NC3_inq_varid
#define NC3_new_nc vtk_netcdf_NC3_new_nc
#define NC3_open vtk_netcdf_NC3_open
#define NC3_put_att vtk_netcdf_NC3_put_att
#define NC3_put_vara vtk_netcdf_NC3_put_vara
#define NC3_redef vtk_netcdf_NC3_redef
#define NC3_rename_att vtk_netcdf_NC3_rename_att
#define NC3_rename_dim vtk_netcdf_NC3_rename_dim
#define NC3_rename_var vtk_netcdf_NC3_rename_var
#define NC3_set_base_pe vtk_netcdf_NC3_set_base_pe
#define NC3_set_fill vtk_netcdf_NC3_set_fill
#define NC3_sync vtk_netcdf_NC3_sync
#define NC4__enddef vtk_netcdf_NC4__enddef
#define NC4_abort vtk_netcdf_NC4_abort
#define NC4_close vtk_netcdf_NC4_close
#define NC4_create vtk_netcdf_NC4_create
#define NC4_def_compound vtk_netcdf_NC4_def_compound
#define NC4_def_dim vtk_netcdf_NC4_def_dim
#define NC4_def_enum vtk_netcdf_NC4_def_enum
#define NC4_def_grp vtk_netcdf_NC4_def_grp
#define NC4_def_opaque vtk_netcdf_NC4_def_opaque
#define NC4_def_var vtk_netcdf_NC4_def_var
#define NC4_def_var_chunking vtk_netcdf_NC4_def_var_chunking
#define NC4_def_var_deflate vtk_netcdf_NC4_def_var_deflate
#define NC4_def_var_endian vtk_netcdf_NC4_def_var_endian
#define NC4_def_var_fill vtk_netcdf_NC4_def_var_fill
#define NC4_def_var_fletcher32 vtk_netcdf_NC4_def_var_fletcher32
#define NC4_def_vlen vtk_netcdf_NC4_def_vlen
#define NC4_del_att vtk_netcdf_NC4_del_att
#define NC4_dispatch_table vtk_netcdf_NC4_dispatch_table
#define NC4_dispatcher vtk_netcdf_NC4_dispatcher
#define NC4_get_att vtk_netcdf_NC4_get_att
#define NC4_get_var_chunk_cache vtk_netcdf_NC4_get_var_chunk_cache
#define NC4_get_vara vtk_netcdf_NC4_get_vara
#define NC4_get_vlen_element vtk_netcdf_NC4_get_vlen_element
#define NC4_initialize vtk_netcdf_NC4_initialize
#define NC4_inq vtk_netcdf_NC4_inq
#define NC4_inq_att vtk_netcdf_NC4_inq_att
#define NC4_inq_attid vtk_netcdf_NC4_inq_attid
#define NC4_inq_attname vtk_netcdf_NC4_inq_attname
#define NC4_inq_base_pe vtk_netcdf_NC4_inq_base_pe
#define NC4_inq_compound_field vtk_netcdf_NC4_inq_compound_field
#define NC4_inq_compound_fieldindex vtk_netcdf_NC4_inq_compound_fieldindex
#define NC4_inq_dim vtk_netcdf_NC4_inq_dim
#define NC4_inq_dimid vtk_netcdf_NC4_inq_dimid
#define NC4_inq_dimids vtk_netcdf_NC4_inq_dimids
#define NC4_inq_enum_ident vtk_netcdf_NC4_inq_enum_ident
#define NC4_inq_enum_member vtk_netcdf_NC4_inq_enum_member
#define NC4_inq_format vtk_netcdf_NC4_inq_format
#define NC4_inq_grp_full_ncid vtk_netcdf_NC4_inq_grp_full_ncid
#define NC4_inq_grp_parent vtk_netcdf_NC4_inq_grp_parent
#define NC4_inq_grpname vtk_netcdf_NC4_inq_grpname
#define NC4_inq_grpname_full vtk_netcdf_NC4_inq_grpname_full
#define NC4_inq_grps vtk_netcdf_NC4_inq_grps
#define NC4_inq_ncid vtk_netcdf_NC4_inq_ncid
#define NC4_inq_type vtk_netcdf_NC4_inq_type
#define NC4_inq_type_equal vtk_netcdf_NC4_inq_type_equal
#define NC4_inq_typeid vtk_netcdf_NC4_inq_typeid
#define NC4_inq_typeids vtk_netcdf_NC4_inq_typeids
#define NC4_inq_unlimdim vtk_netcdf_NC4_inq_unlimdim
#define NC4_inq_unlimdims vtk_netcdf_NC4_inq_unlimdims
#define NC4_inq_user_type vtk_netcdf_NC4_inq_user_type
#define NC4_inq_var_all vtk_netcdf_NC4_inq_var_all
#define NC4_inq_varid vtk_netcdf_NC4_inq_varid
#define NC4_inq_varids vtk_netcdf_NC4_inq_varids
#define NC4_insert_array_compound vtk_netcdf_NC4_insert_array_compound
#define NC4_insert_compound vtk_netcdf_NC4_insert_compound
#define NC4_insert_enum vtk_netcdf_NC4_insert_enum
#define NC4_new_nc vtk_netcdf_NC4_new_nc
#define NC4_open vtk_netcdf_NC4_open
#define NC4_put_att vtk_netcdf_NC4_put_att
#define NC4_put_vara vtk_netcdf_NC4_put_vara
#define NC4_put_vlen_element vtk_netcdf_NC4_put_vlen_element
#define NC4_redef vtk_netcdf_NC4_redef
#define NC4_rename_att vtk_netcdf_NC4_rename_att
#define NC4_rename_dim vtk_netcdf_NC4_rename_dim
#define NC4_rename_var vtk_netcdf_NC4_rename_var
#define NC4_set_base_pe vtk_netcdf_NC4_set_base_pe
#define NC4_set_fill vtk_netcdf_NC4_set_fill
#define NC4_set_var_chunk_cache vtk_netcdf_NC4_set_var_chunk_cache
#define NC4_show_metadata vtk_netcdf_NC4_show_metadata
#define NC4_sync vtk_netcdf_NC4_sync
#define NC4_var_par_access vtk_netcdf_NC4_var_par_access
#define NCDEFAULT_get_varm vtk_netcdf_NCDEFAULT_get_varm
#define NCDEFAULT_get_vars vtk_netcdf_NCDEFAULT_get_vars
#define NCDEFAULT_put_varm vtk_netcdf_NCDEFAULT_put_varm
#define NCDEFAULT_put_vars vtk_netcdf_NCDEFAULT_put_vars
#define NC_atomictypelen vtk_netcdf_NC_atomictypelen
#define NC_atomictypename vtk_netcdf_NC_atomictypename
#define NC_calcsize vtk_netcdf_NC_calcsize
#define NC_check_id vtk_netcdf_NC_check_id
#define NC_check_name vtk_netcdf_NC_check_name
#define NC_check_vlen vtk_netcdf_NC_check_vlen
#define NC_create vtk_netcdf_NC_create
#define NC_dispatch_overlay vtk_netcdf_NC_dispatch_overlay
#define NC_findattr vtk_netcdf_NC_findattr
#define NC_findvar vtk_netcdf_NC_findvar
#define NC_get_dispatch_override vtk_netcdf_NC_get_dispatch_override
#define NC_get_vara vtk_netcdf_NC_get_vara
#define NC_initialize vtk_netcdf_NC_initialize
#define NC_lookupvar vtk_netcdf_NC_lookupvar
#define NC_open vtk_netcdf_NC_open
#define NC_set_dispatch_override vtk_netcdf_NC_set_dispatch_override
#define NC_sync vtk_netcdf_NC_sync
#define NC_testurl vtk_netcdf_NC_testurl
#define NC_urlmodel vtk_netcdf_NC_urlmodel
#define NC_var_shape vtk_netcdf_NC_var_shape
#define add_to_NCList vtk_netcdf_add_to_NCList
#define atomic_name vtk_netcdf_atomic_name
#define count_NCList vtk_netcdf_count_NCList
#define default_create_format vtk_netcdf_default_create_format
#define del_from_NCList vtk_netcdf_del_from_NCList
#define dup_NC_attrarrayV vtk_netcdf_dup_NC_attrarrayV
#define dup_NC_dimarrayV vtk_netcdf_dup_NC_dimarrayV
#define dup_NC_vararrayV vtk_netcdf_dup_NC_vararrayV
#define elem_NC_attrarray vtk_netcdf_elem_NC_attrarray
#define elem_NC_dimarray vtk_netcdf_elem_NC_dimarray
#define fill_NC_var vtk_netcdf_fill_NC_var
#define find_NC_Udim vtk_netcdf_find_NC_Udim
#define find_in_NCList vtk_netcdf_find_in_NCList
#define free_NCList vtk_netcdf_free_NCList
#define free_NC_attr vtk_netcdf_free_NC_attr
#define free_NC_attrarrayV vtk_netcdf_free_NC_attrarrayV
#define free_NC_attrarrayV0 vtk_netcdf_free_NC_attrarrayV0
#define free_NC_dim vtk_netcdf_free_NC_dim
#define free_NC_dimarrayV vtk_netcdf_free_NC_dimarrayV
#define free_NC_dimarrayV0 vtk_netcdf_free_NC_dimarrayV0
#define free_NC_string vtk_netcdf_free_NC_string
#define free_NC_var vtk_netcdf_free_NC_var
#define free_NC_vararrayV vtk_netcdf_free_NC_vararrayV
#define free_NC_vararrayV0 vtk_netcdf_free_NC_vararrayV0
#define hash_fast vtk_netcdf_hash_fast
#define int_cmp vtk_netcdf_int_cmp
#define nc4_adjust_var_cache vtk_netcdf_nc4_adjust_var_cache
#define nc4_att_list_add vtk_netcdf_nc4_att_list_add
#define nc4_att_list_del vtk_netcdf_nc4_att_list_del
#define nc4_check_dup_name vtk_netcdf_nc4_check_dup_name
#define nc4_check_name vtk_netcdf_nc4_check_name
#define nc4_chunk_cache_nelems vtk_netcdf_nc4_chunk_cache_nelems
#define nc4_chunk_cache_preemption vtk_netcdf_nc4_chunk_cache_preemption
#define nc4_chunk_cache_size vtk_netcdf_nc4_chunk_cache_size
#define nc4_convert_type vtk_netcdf_nc4_convert_type
#define nc4_dim_list_add vtk_netcdf_nc4_dim_list_add
#define nc4_dim_list_add2 vtk_netcdf_nc4_dim_list_add2
#define nc4_dim_list_del vtk_netcdf_nc4_dim_list_del
#define nc4_enddef_netcdf4_file vtk_netcdf_nc4_enddef_netcdf4_file
#define nc4_enum_member_add vtk_netcdf_nc4_enum_member_add
#define nc4_field_list_add vtk_netcdf_nc4_field_list_add
#define nc4_file_list_add vtk_netcdf_nc4_file_list_add
#define nc4_file_list_del vtk_netcdf_nc4_file_list_del
#define nc4_file_list_free vtk_netcdf_nc4_file_list_free
#define nc4_find_dim vtk_netcdf_nc4_find_dim
#define nc4_find_dim_len vtk_netcdf_nc4_find_dim_len
#define nc4_find_g_var_nc vtk_netcdf_nc4_find_g_var_nc
#define nc4_find_grp_att vtk_netcdf_nc4_find_grp_att
#define nc4_find_grp_h5 vtk_netcdf_nc4_find_grp_h5
#define nc4_find_nc4_grp vtk_netcdf_nc4_find_nc4_grp
#define nc4_find_nc_att vtk_netcdf_nc4_find_nc_att
#define nc4_find_nc_file vtk_netcdf_nc4_find_nc_file
#define nc4_find_nc_grp_h5 vtk_netcdf_nc4_find_nc_grp_h5
#define nc4_find_type vtk_netcdf_nc4_find_type
#define nc4_get_att vtk_netcdf_nc4_get_att
#define nc4_get_att_tc vtk_netcdf_nc4_get_att_tc
#define nc4_get_default_fill_value vtk_netcdf_nc4_get_default_fill_value
#define nc4_get_hdf4_vara vtk_netcdf_nc4_get_hdf4_vara
#define nc4_get_hdf_typeid vtk_netcdf_nc4_get_hdf_typeid
#define nc4_get_typelen_mem vtk_netcdf_nc4_get_typelen_mem
#define nc4_get_vara vtk_netcdf_nc4_get_vara
#define nc4_grp_list_add vtk_netcdf_nc4_grp_list_add
#define nc4_nc4f_list_add vtk_netcdf_nc4_nc4f_list_add
#define nc4_normalize_name vtk_netcdf_nc4_normalize_name
#define nc4_open_var_grp2 vtk_netcdf_nc4_open_var_grp2
#define nc4_pg_var1 vtk_netcdf_nc4_pg_var1
#define nc4_pg_varm vtk_netcdf_nc4_pg_varm
#define nc4_put_att vtk_netcdf_nc4_put_att
#define nc4_put_att_tc vtk_netcdf_nc4_put_att_tc
#define nc4_put_vara vtk_netcdf_nc4_put_vara
#define nc4_rec_find_grp vtk_netcdf_nc4_rec_find_grp
#define nc4_rec_find_hdf_type vtk_netcdf_nc4_rec_find_hdf_type
#define nc4_rec_find_named_type vtk_netcdf_nc4_rec_find_named_type
#define nc4_rec_find_nc_type vtk_netcdf_nc4_rec_find_nc_type
#define nc4_rec_grp_del vtk_netcdf_nc4_rec_grp_del
#define nc4_rec_match_dimscales vtk_netcdf_nc4_rec_match_dimscales
#define nc4_rec_read_types vtk_netcdf_nc4_rec_read_types
#define nc4_rec_read_vars vtk_netcdf_nc4_rec_read_vars
#define nc4_rec_write_metadata vtk_netcdf_nc4_rec_write_metadata
#define nc4_rec_write_types vtk_netcdf_nc4_rec_write_types
#define nc4_reopen_dataset vtk_netcdf_nc4_reopen_dataset
#define nc4_type_list_add vtk_netcdf_nc4_type_list_add
#define nc4_var_list_add vtk_netcdf_nc4_var_list_add
#define nc4typelen vtk_netcdf_nc4typelen
#define nc__create vtk_netcdf_nc__create
#define nc__create_mp vtk_netcdf_nc__create_mp
#define nc__enddef vtk_netcdf_nc__enddef
#define nc__open vtk_netcdf_nc__open
#define nc__open_mp vtk_netcdf_nc__open_mp
#define nc_abort vtk_netcdf_nc_abort
#define nc_cktype vtk_netcdf_nc_cktype
#define nc_close vtk_netcdf_nc_close
#define nc_copy_att vtk_netcdf_nc_copy_att
#define nc_copy_var vtk_netcdf_nc_copy_var
#define nc_create vtk_netcdf_nc_create
#define nc_create_par vtk_netcdf_nc_create_par
#define nc_create_par_fortran vtk_netcdf_nc_create_par_fortran
#define nc_def_compound vtk_netcdf_nc_def_compound
#define nc_def_dim vtk_netcdf_nc_def_dim
#define nc_def_enum vtk_netcdf_nc_def_enum
#define nc_def_grp vtk_netcdf_nc_def_grp
#define nc_def_opaque vtk_netcdf_nc_def_opaque
#define nc_def_var vtk_netcdf_nc_def_var
#define nc_def_var_chunking vtk_netcdf_nc_def_var_chunking
#define nc_def_var_chunking_ints vtk_netcdf_nc_def_var_chunking_ints
#define nc_def_var_deflate vtk_netcdf_nc_def_var_deflate
#define nc_def_var_endian vtk_netcdf_nc_def_var_endian
#define nc_def_var_fill vtk_netcdf_nc_def_var_fill
#define nc_def_var_fletcher32 vtk_netcdf_nc_def_var_fletcher32
#define nc_def_vlen vtk_netcdf_nc_def_vlen
#define nc_del_att vtk_netcdf_nc_del_att
#define nc_delete vtk_netcdf_nc_delete
#define nc_delete_mp vtk_netcdf_nc_delete_mp
#define nc_enddef vtk_netcdf_nc_enddef
#define nc_free_string vtk_netcdf_nc_free_string
#define nc_free_vlen vtk_netcdf_nc_free_vlen
#define nc_free_vlens vtk_netcdf_nc_free_vlens
#define nc_get_NC vtk_netcdf_nc_get_NC
#define nc_get_att vtk_netcdf_nc_get_att
#define nc_get_att_double vtk_netcdf_nc_get_att_double
#define nc_get_att_float vtk_netcdf_nc_get_att_float
#define nc_get_att_int vtk_netcdf_nc_get_att_int
#define nc_get_att_long vtk_netcdf_nc_get_att_long
#define nc_get_att_longlong vtk_netcdf_nc_get_att_longlong
#define nc_get_att_schar vtk_netcdf_nc_get_att_schar
#define nc_get_att_short vtk_netcdf_nc_get_att_short
#define nc_get_att_string vtk_netcdf_nc_get_att_string
#define nc_get_att_text vtk_netcdf_nc_get_att_text
#define nc_get_att_ubyte vtk_netcdf_nc_get_att_ubyte
#define nc_get_att_uchar vtk_netcdf_nc_get_att_uchar
#define nc_get_att_uint vtk_netcdf_nc_get_att_uint
#define nc_get_att_ulonglong vtk_netcdf_nc_get_att_ulonglong
#define nc_get_att_ushort vtk_netcdf_nc_get_att_ushort
#define nc_get_chunk_cache vtk_netcdf_nc_get_chunk_cache
#define nc_get_chunk_cache_ints vtk_netcdf_nc_get_chunk_cache_ints
#define nc_get_var vtk_netcdf_nc_get_var
#define nc_get_var1 vtk_netcdf_nc_get_var1
#define nc_get_var1_double vtk_netcdf_nc_get_var1_double
#define nc_get_var1_float vtk_netcdf_nc_get_var1_float
#define nc_get_var1_int vtk_netcdf_nc_get_var1_int
#define nc_get_var1_long vtk_netcdf_nc_get_var1_long
#define nc_get_var1_longlong vtk_netcdf_nc_get_var1_longlong
#define nc_get_var1_schar vtk_netcdf_nc_get_var1_schar
#define nc_get_var1_short vtk_netcdf_nc_get_var1_short
#define nc_get_var1_string vtk_netcdf_nc_get_var1_string
#define nc_get_var1_text vtk_netcdf_nc_get_var1_text
#define nc_get_var1_ubyte vtk_netcdf_nc_get_var1_ubyte
#define nc_get_var1_uchar vtk_netcdf_nc_get_var1_uchar
#define nc_get_var1_uint vtk_netcdf_nc_get_var1_uint
#define nc_get_var1_ulonglong vtk_netcdf_nc_get_var1_ulonglong
#define nc_get_var1_ushort vtk_netcdf_nc_get_var1_ushort
#define nc_get_var_chunk_cache vtk_netcdf_nc_get_var_chunk_cache
#define nc_get_var_chunk_cache_ints vtk_netcdf_nc_get_var_chunk_cache_ints
#define nc_get_var_double vtk_netcdf_nc_get_var_double
#define nc_get_var_float vtk_netcdf_nc_get_var_float
#define nc_get_var_int vtk_netcdf_nc_get_var_int
#define nc_get_var_long vtk_netcdf_nc_get_var_long
#define nc_get_var_longlong vtk_netcdf_nc_get_var_longlong
#define nc_get_var_schar vtk_netcdf_nc_get_var_schar
#define nc_get_var_short vtk_netcdf_nc_get_var_short
#define nc_get_var_string vtk_netcdf_nc_get_var_string
#define nc_get_var_text vtk_netcdf_nc_get_var_text
#define nc_get_var_ubyte vtk_netcdf_nc_get_var_ubyte
#define nc_get_var_uchar vtk_netcdf_nc_get_var_uchar
#define nc_get_var_uint vtk_netcdf_nc_get_var_uint
#define nc_get_var_ulonglong vtk_netcdf_nc_get_var_ulonglong
#define nc_get_var_ushort vtk_netcdf_nc_get_var_ushort
#define nc_get_vara vtk_netcdf_nc_get_vara
#define nc_get_vara_double vtk_netcdf_nc_get_vara_double
#define nc_get_vara_float vtk_netcdf_nc_get_vara_float
#define nc_get_vara_int vtk_netcdf_nc_get_vara_int
#define nc_get_vara_long vtk_netcdf_nc_get_vara_long
#define nc_get_vara_longlong vtk_netcdf_nc_get_vara_longlong
#define nc_get_vara_schar vtk_netcdf_nc_get_vara_schar
#define nc_get_vara_short vtk_netcdf_nc_get_vara_short
#define nc_get_vara_string vtk_netcdf_nc_get_vara_string
#define nc_get_vara_text vtk_netcdf_nc_get_vara_text
#define nc_get_vara_ubyte vtk_netcdf_nc_get_vara_ubyte
#define nc_get_vara_uchar vtk_netcdf_nc_get_vara_uchar
#define nc_get_vara_uint vtk_netcdf_nc_get_vara_uint
#define nc_get_vara_ulonglong vtk_netcdf_nc_get_vara_ulonglong
#define nc_get_vara_ushort vtk_netcdf_nc_get_vara_ushort
#define nc_get_varm vtk_netcdf_nc_get_varm
#define nc_get_varm_double vtk_netcdf_nc_get_varm_double
#define nc_get_varm_float vtk_netcdf_nc_get_varm_float
#define nc_get_varm_int vtk_netcdf_nc_get_varm_int
#define nc_get_varm_long vtk_netcdf_nc_get_varm_long
#define nc_get_varm_longlong vtk_netcdf_nc_get_varm_longlong
#define nc_get_varm_schar vtk_netcdf_nc_get_varm_schar
#define nc_get_varm_short vtk_netcdf_nc_get_varm_short
#define nc_get_varm_string vtk_netcdf_nc_get_varm_string
#define nc_get_varm_text vtk_netcdf_nc_get_varm_text
#define nc_get_varm_ubyte vtk_netcdf_nc_get_varm_ubyte
#define nc_get_varm_uchar vtk_netcdf_nc_get_varm_uchar
#define nc_get_varm_uint vtk_netcdf_nc_get_varm_uint
#define nc_get_varm_ulonglong vtk_netcdf_nc_get_varm_ulonglong
#define nc_get_varm_ushort vtk_netcdf_nc_get_varm_ushort
#define nc_get_vars vtk_netcdf_nc_get_vars
#define nc_get_vars_double vtk_netcdf_nc_get_vars_double
#define nc_get_vars_float vtk_netcdf_nc_get_vars_float
#define nc_get_vars_int vtk_netcdf_nc_get_vars_int
#define nc_get_vars_long vtk_netcdf_nc_get_vars_long
#define nc_get_vars_longlong vtk_netcdf_nc_get_vars_longlong
#define nc_get_vars_schar vtk_netcdf_nc_get_vars_schar
#define nc_get_vars_short vtk_netcdf_nc_get_vars_short
#define nc_get_vars_string vtk_netcdf_nc_get_vars_string
#define nc_get_vars_text vtk_netcdf_nc_get_vars_text
#define nc_get_vars_ubyte vtk_netcdf_nc_get_vars_ubyte
#define nc_get_vars_uchar vtk_netcdf_nc_get_vars_uchar
#define nc_get_vars_uint vtk_netcdf_nc_get_vars_uint
#define nc_get_vars_ulonglong vtk_netcdf_nc_get_vars_ulonglong
#define nc_get_vars_ushort vtk_netcdf_nc_get_vars_ushort
#define nc_get_vlen_element vtk_netcdf_nc_get_vlen_element
#define nc_inq vtk_netcdf_nc_inq
#define nc_inq_att vtk_netcdf_nc_inq_att
#define nc_inq_attid vtk_netcdf_nc_inq_attid
#define nc_inq_attlen vtk_netcdf_nc_inq_attlen
#define nc_inq_attname vtk_netcdf_nc_inq_attname
#define nc_inq_atttype vtk_netcdf_nc_inq_atttype
#define nc_inq_base_pe vtk_netcdf_nc_inq_base_pe
#define nc_inq_compound vtk_netcdf_nc_inq_compound
#define nc_inq_compound_field vtk_netcdf_nc_inq_compound_field
#define nc_inq_compound_fielddim_sizes vtk_netcdf_nc_inq_compound_fielddim_sizes
#define nc_inq_compound_fieldindex vtk_netcdf_nc_inq_compound_fieldindex
#define nc_inq_compound_fieldname vtk_netcdf_nc_inq_compound_fieldname
#define nc_inq_compound_fieldndims vtk_netcdf_nc_inq_compound_fieldndims
#define nc_inq_compound_fieldoffset vtk_netcdf_nc_inq_compound_fieldoffset
#define nc_inq_compound_fieldtype vtk_netcdf_nc_inq_compound_fieldtype
#define nc_inq_compound_name vtk_netcdf_nc_inq_compound_name
#define nc_inq_compound_nfields vtk_netcdf_nc_inq_compound_nfields
#define nc_inq_compound_size vtk_netcdf_nc_inq_compound_size
#define nc_inq_dim vtk_netcdf_nc_inq_dim
#define nc_inq_dimid vtk_netcdf_nc_inq_dimid
#define nc_inq_dimids vtk_netcdf_nc_inq_dimids
#define nc_inq_dimlen vtk_netcdf_nc_inq_dimlen
#define nc_inq_dimname vtk_netcdf_nc_inq_dimname
#define nc_inq_enum vtk_netcdf_nc_inq_enum
#define nc_inq_enum_ident vtk_netcdf_nc_inq_enum_ident
#define nc_inq_enum_member vtk_netcdf_nc_inq_enum_member
#define nc_inq_format vtk_netcdf_nc_inq_format
#define nc_inq_grp_full_ncid vtk_netcdf_nc_inq_grp_full_ncid
#define nc_inq_grp_ncid vtk_netcdf_nc_inq_grp_ncid
#define nc_inq_grp_parent vtk_netcdf_nc_inq_grp_parent
#define nc_inq_grpname vtk_netcdf_nc_inq_grpname
#define nc_inq_grpname_full vtk_netcdf_nc_inq_grpname_full
#define nc_inq_grpname_len vtk_netcdf_nc_inq_grpname_len
#define nc_inq_grps vtk_netcdf_nc_inq_grps
#define nc_inq_libvers vtk_netcdf_nc_inq_libvers
#define nc_inq_natts vtk_netcdf_nc_inq_natts
#define nc_inq_ncid vtk_netcdf_nc_inq_ncid
#define nc_inq_ndims vtk_netcdf_nc_inq_ndims
#define nc_inq_nvars vtk_netcdf_nc_inq_nvars
#define nc_inq_opaque vtk_netcdf_nc_inq_opaque
#define nc_inq_path vtk_netcdf_nc_inq_path
#define nc_inq_type vtk_netcdf_nc_inq_type
#define nc_inq_type_equal vtk_netcdf_nc_inq_type_equal
#define nc_inq_typeid vtk_netcdf_nc_inq_typeid
#define nc_inq_typeids vtk_netcdf_nc_inq_typeids
#define nc_inq_unlimdim vtk_netcdf_nc_inq_unlimdim
#define nc_inq_unlimdims vtk_netcdf_nc_inq_unlimdims
#define nc_inq_user_type vtk_netcdf_nc_inq_user_type
#define nc_inq_var vtk_netcdf_nc_inq_var
#define nc_inq_var_chunking vtk_netcdf_nc_inq_var_chunking
#define nc_inq_var_chunking_ints vtk_netcdf_nc_inq_var_chunking_ints
#define nc_inq_var_deflate vtk_netcdf_nc_inq_var_deflate
#define nc_inq_var_endian vtk_netcdf_nc_inq_var_endian
#define nc_inq_var_fill vtk_netcdf_nc_inq_var_fill
#define nc_inq_var_fletcher32 vtk_netcdf_nc_inq_var_fletcher32
#define nc_inq_var_szip vtk_netcdf_nc_inq_var_szip
#define nc_inq_vardimid vtk_netcdf_nc_inq_vardimid
#define nc_inq_varid vtk_netcdf_nc_inq_varid
#define nc_inq_varids vtk_netcdf_nc_inq_varids
#define nc_inq_varname vtk_netcdf_nc_inq_varname
#define nc_inq_varnatts vtk_netcdf_nc_inq_varnatts
#define nc_inq_varndims vtk_netcdf_nc_inq_varndims
#define nc_inq_vartype vtk_netcdf_nc_inq_vartype
#define nc_inq_vlen vtk_netcdf_nc_inq_vlen
#define nc_insert_array_compound vtk_netcdf_nc_insert_array_compound
#define nc_insert_compound vtk_netcdf_nc_insert_compound
#define nc_insert_enum vtk_netcdf_nc_insert_enum
#define nc_open vtk_netcdf_nc_open
#define nc_open_par vtk_netcdf_nc_open_par
#define nc_open_par_fortran vtk_netcdf_nc_open_par_fortran
#define nc_put_att vtk_netcdf_nc_put_att
#define nc_put_att_double vtk_netcdf_nc_put_att_double
#define nc_put_att_float vtk_netcdf_nc_put_att_float
#define nc_put_att_int vtk_netcdf_nc_put_att_int
#define nc_put_att_long vtk_netcdf_nc_put_att_long
#define nc_put_att_longlong vtk_netcdf_nc_put_att_longlong
#define nc_put_att_schar vtk_netcdf_nc_put_att_schar
#define nc_put_att_short vtk_netcdf_nc_put_att_short
#define nc_put_att_string vtk_netcdf_nc_put_att_string
#define nc_put_att_text vtk_netcdf_nc_put_att_text
#define nc_put_att_ubyte vtk_netcdf_nc_put_att_ubyte
#define nc_put_att_uchar vtk_netcdf_nc_put_att_uchar
#define nc_put_att_uint vtk_netcdf_nc_put_att_uint
#define nc_put_att_ulonglong vtk_netcdf_nc_put_att_ulonglong
#define nc_put_att_ushort vtk_netcdf_nc_put_att_ushort
#define nc_put_var vtk_netcdf_nc_put_var
#define nc_put_var1 vtk_netcdf_nc_put_var1
#define nc_put_var1_double vtk_netcdf_nc_put_var1_double
#define nc_put_var1_float vtk_netcdf_nc_put_var1_float
#define nc_put_var1_int vtk_netcdf_nc_put_var1_int
#define nc_put_var1_long vtk_netcdf_nc_put_var1_long
#define nc_put_var1_longlong vtk_netcdf_nc_put_var1_longlong
#define nc_put_var1_schar vtk_netcdf_nc_put_var1_schar
#define nc_put_var1_short vtk_netcdf_nc_put_var1_short
#define nc_put_var1_string vtk_netcdf_nc_put_var1_string
#define nc_put_var1_text vtk_netcdf_nc_put_var1_text
#define nc_put_var1_ubyte vtk_netcdf_nc_put_var1_ubyte
#define nc_put_var1_uchar vtk_netcdf_nc_put_var1_uchar
#define nc_put_var1_uint vtk_netcdf_nc_put_var1_uint
#define nc_put_var1_ulonglong vtk_netcdf_nc_put_var1_ulonglong
#define nc_put_var1_ushort vtk_netcdf_nc_put_var1_ushort
#define nc_put_var_double vtk_netcdf_nc_put_var_double
#define nc_put_var_float vtk_netcdf_nc_put_var_float
#define nc_put_var_int vtk_netcdf_nc_put_var_int
#define nc_put_var_long vtk_netcdf_nc_put_var_long
#define nc_put_var_longlong vtk_netcdf_nc_put_var_longlong
#define nc_put_var_schar vtk_netcdf_nc_put_var_schar
#define nc_put_var_short vtk_netcdf_nc_put_var_short
#define nc_put_var_string vtk_netcdf_nc_put_var_string
#define nc_put_var_text vtk_netcdf_nc_put_var_text
#define nc_put_var_ubyte vtk_netcdf_nc_put_var_ubyte
#define nc_put_var_uchar vtk_netcdf_nc_put_var_uchar
#define nc_put_var_uint vtk_netcdf_nc_put_var_uint
#define nc_put_var_ulonglong vtk_netcdf_nc_put_var_ulonglong
#define nc_put_var_ushort vtk_netcdf_nc_put_var_ushort
#define nc_put_vara vtk_netcdf_nc_put_vara
#define nc_put_vara_double vtk_netcdf_nc_put_vara_double
#define nc_put_vara_float vtk_netcdf_nc_put_vara_float
#define nc_put_vara_int vtk_netcdf_nc_put_vara_int
#define nc_put_vara_long vtk_netcdf_nc_put_vara_long
#define nc_put_vara_longlong vtk_netcdf_nc_put_vara_longlong
#define nc_put_vara_schar vtk_netcdf_nc_put_vara_schar
#define nc_put_vara_short vtk_netcdf_nc_put_vara_short
#define nc_put_vara_string vtk_netcdf_nc_put_vara_string
#define nc_put_vara_text vtk_netcdf_nc_put_vara_text
#define nc_put_vara_ubyte vtk_netcdf_nc_put_vara_ubyte
#define nc_put_vara_uchar vtk_netcdf_nc_put_vara_uchar
#define nc_put_vara_uint vtk_netcdf_nc_put_vara_uint
#define nc_put_vara_ulonglong vtk_netcdf_nc_put_vara_ulonglong
#define nc_put_vara_ushort vtk_netcdf_nc_put_vara_ushort
#define nc_put_varm vtk_netcdf_nc_put_varm
#define nc_put_varm_double vtk_netcdf_nc_put_varm_double
#define nc_put_varm_float vtk_netcdf_nc_put_varm_float
#define nc_put_varm_int vtk_netcdf_nc_put_varm_int
#define nc_put_varm_long vtk_netcdf_nc_put_varm_long
#define nc_put_varm_longlong vtk_netcdf_nc_put_varm_longlong
#define nc_put_varm_schar vtk_netcdf_nc_put_varm_schar
#define nc_put_varm_short vtk_netcdf_nc_put_varm_short
#define nc_put_varm_string vtk_netcdf_nc_put_varm_string
#define nc_put_varm_text vtk_netcdf_nc_put_varm_text
#define nc_put_varm_ubyte vtk_netcdf_nc_put_varm_ubyte
#define nc_put_varm_uchar vtk_netcdf_nc_put_varm_uchar
#define nc_put_varm_uint vtk_netcdf_nc_put_varm_uint
#define nc_put_varm_ulonglong vtk_netcdf_nc_put_varm_ulonglong
#define nc_put_varm_ushort vtk_netcdf_nc_put_varm_ushort
#define nc_put_vars vtk_netcdf_nc_put_vars
#define nc_put_vars_double vtk_netcdf_nc_put_vars_double
#define nc_put_vars_float vtk_netcdf_nc_put_vars_float
#define nc_put_vars_int vtk_netcdf_nc_put_vars_int
#define nc_put_vars_long vtk_netcdf_nc_put_vars_long
#define nc_put_vars_longlong vtk_netcdf_nc_put_vars_longlong
#define nc_put_vars_schar vtk_netcdf_nc_put_vars_schar
#define nc_put_vars_short vtk_netcdf_nc_put_vars_short
#define nc_put_vars_string vtk_netcdf_nc_put_vars_string
#define nc_put_vars_text vtk_netcdf_nc_put_vars_text
#define nc_put_vars_ubyte vtk_netcdf_nc_put_vars_ubyte
#define nc_put_vars_uchar vtk_netcdf_nc_put_vars_uchar
#define nc_put_vars_uint vtk_netcdf_nc_put_vars_uint
#define nc_put_vars_ulonglong vtk_netcdf_nc_put_vars_ulonglong
#define nc_put_vars_ushort vtk_netcdf_nc_put_vars_ushort
#define nc_put_vlen_element vtk_netcdf_nc_put_vlen_element
#define nc_redef vtk_netcdf_nc_redef
#define nc_rename_att vtk_netcdf_nc_rename_att
#define nc_rename_dim vtk_netcdf_nc_rename_dim
#define nc_rename_var vtk_netcdf_nc_rename_var
#define nc_set_base_pe vtk_netcdf_nc_set_base_pe
#define nc_set_chunk_cache vtk_netcdf_nc_set_chunk_cache
#define nc_set_chunk_cache_ints vtk_netcdf_nc_set_chunk_cache_ints
#define nc_set_default_format vtk_netcdf_nc_set_default_format
#define nc_set_fill vtk_netcdf_nc_set_fill
#define nc_set_var_chunk_cache vtk_netcdf_nc_set_var_chunk_cache
#define nc_set_var_chunk_cache_ints vtk_netcdf_nc_set_var_chunk_cache_ints
#define nc_show_metadata vtk_netcdf_nc_show_metadata
#define nc_strerror vtk_netcdf_nc_strerror
#define nc_sync vtk_netcdf_nc_sync
#define nc_urldecodeparams vtk_netcdf_nc_urldecodeparams
#define nc_urlfree vtk_netcdf_nc_urlfree
#define nc_urllookup vtk_netcdf_nc_urllookup
#define nc_urllookupvalue vtk_netcdf_nc_urllookupvalue
#define nc_urlparse vtk_netcdf_nc_urlparse
#define nc_urlsetconstraints vtk_netcdf_nc_urlsetconstraints
#define nc_urlsetprotocol vtk_netcdf_nc_urlsetprotocol
#define nc_var_par_access vtk_netcdf_nc_var_par_access
#define ncbytesappend vtk_netcdf_ncbytesappend
#define ncbytesappendn vtk_netcdf_ncbytesappendn
#define ncbytescat vtk_netcdf_ncbytescat
#define ncbytesdup vtk_netcdf_ncbytesdup
#define ncbytesextract vtk_netcdf_ncbytesextract
#define ncbytesfill vtk_netcdf_ncbytesfill
#define ncbytesfree vtk_netcdf_ncbytesfree
#define ncbytesget vtk_netcdf_ncbytesget
#define ncbytesnew vtk_netcdf_ncbytesnew
#define ncbytesnull vtk_netcdf_ncbytesnull
#define ncbytesprepend vtk_netcdf_ncbytesprepend
#define ncbytesset vtk_netcdf_ncbytesset
#define ncbytessetalloc vtk_netcdf_ncbytessetalloc
#define ncbytessetcontents vtk_netcdf_ncbytessetcontents
#define ncbytessetlength vtk_netcdf_ncbytessetlength
#define ncio_close vtk_netcdf_ncio_close
#define ncio_create vtk_netcdf_ncio_create
#define ncio_filesize vtk_netcdf_ncio_filesize
#define ncio_open vtk_netcdf_ncio_open
#define ncio_pad_length vtk_netcdf_ncio_pad_length
#define nclistclone vtk_netcdf_nclistclone
#define nclistcontains vtk_netcdf_nclistcontains
#define nclistdup vtk_netcdf_nclistdup
#define nclistfree vtk_netcdf_nclistfree
#define nclistget vtk_netcdf_nclistget
#define nclistinsert vtk_netcdf_nclistinsert
#define nclistnew vtk_netcdf_nclistnew
#define nclistnull vtk_netcdf_nclistnull
#define nclistpop vtk_netcdf_nclistpop
#define nclistpush vtk_netcdf_nclistpush
#define nclistremove vtk_netcdf_nclistremove
#define nclistset vtk_netcdf_nclistset
#define nclistsetalloc vtk_netcdf_nclistsetalloc
#define nclistsetlength vtk_netcdf_nclistsetlength
#define nclisttop vtk_netcdf_nclisttop
#define nclistunique vtk_netcdf_nclistunique
#define nctypelen vtk_netcdf_nctypelen
#define ncx_get_double_double vtk_netcdf_ncx_get_double_double
#define ncx_get_double_float vtk_netcdf_ncx_get_double_float
#define ncx_get_double_int vtk_netcdf_ncx_get_double_int
#define ncx_get_double_longlong vtk_netcdf_ncx_get_double_longlong
#define ncx_get_double_schar vtk_netcdf_ncx_get_double_schar
#define ncx_get_double_short vtk_netcdf_ncx_get_double_short
#define ncx_get_double_uchar vtk_netcdf_ncx_get_double_uchar
#define ncx_get_double_uint vtk_netcdf_ncx_get_double_uint
#define ncx_get_double_ulonglong vtk_netcdf_ncx_get_double_ulonglong
#define ncx_get_float_double vtk_netcdf_ncx_get_float_double
#define ncx_get_float_float vtk_netcdf_ncx_get_float_float
#define ncx_get_float_int vtk_netcdf_ncx_get_float_int
#define ncx_get_float_longlong vtk_netcdf_ncx_get_float_longlong
#define ncx_get_float_schar vtk_netcdf_ncx_get_float_schar
#define ncx_get_float_short vtk_netcdf_ncx_get_float_short
#define ncx_get_float_uchar vtk_netcdf_ncx_get_float_uchar
#define ncx_get_float_uint vtk_netcdf_ncx_get_float_uint
#define ncx_get_float_ulonglong vtk_netcdf_ncx_get_float_ulonglong
#define ncx_get_int_double vtk_netcdf_ncx_get_int_double
#define ncx_get_int_float vtk_netcdf_ncx_get_int_float
#define ncx_get_int_int vtk_netcdf_ncx_get_int_int
#define ncx_get_int_longlong vtk_netcdf_ncx_get_int_longlong
#define ncx_get_int_schar vtk_netcdf_ncx_get_int_schar
#define ncx_get_int_short vtk_netcdf_ncx_get_int_short
#define ncx_get_int_uchar vtk_netcdf_ncx_get_int_uchar
#define ncx_get_int_uint vtk_netcdf_ncx_get_int_uint
#define ncx_get_int_ulonglong vtk_netcdf_ncx_get_int_ulonglong
#define ncx_get_off_t vtk_netcdf_ncx_get_off_t
#define ncx_get_short_double vtk_netcdf_ncx_get_short_double
#define ncx_get_short_float vtk_netcdf_ncx_get_short_float
#define ncx_get_short_int vtk_netcdf_ncx_get_short_int
#define ncx_get_short_longlong vtk_netcdf_ncx_get_short_longlong
#define ncx_get_short_schar vtk_netcdf_ncx_get_short_schar
#define ncx_get_short_short vtk_netcdf_ncx_get_short_short
#define ncx_get_short_uchar vtk_netcdf_ncx_get_short_uchar
#define ncx_get_short_uint vtk_netcdf_ncx_get_short_uint
#define ncx_get_short_ulonglong vtk_netcdf_ncx_get_short_ulonglong
#define ncx_get_size_t vtk_netcdf_ncx_get_size_t
#define ncx_getn_double_double vtk_netcdf_ncx_getn_double_double
#define ncx_getn_double_float vtk_netcdf_ncx_getn_double_float
#define ncx_getn_double_int vtk_netcdf_ncx_getn_double_int
#define ncx_getn_double_longlong vtk_netcdf_ncx_getn_double_longlong
#define ncx_getn_double_schar vtk_netcdf_ncx_getn_double_schar
#define ncx_getn_double_short vtk_netcdf_ncx_getn_double_short
#define ncx_getn_double_uchar vtk_netcdf_ncx_getn_double_uchar
#define ncx_getn_double_uint vtk_netcdf_ncx_getn_double_uint
#define ncx_getn_double_ulonglong vtk_netcdf_ncx_getn_double_ulonglong
#define ncx_getn_float_double vtk_netcdf_ncx_getn_float_double
#define ncx_getn_float_float vtk_netcdf_ncx_getn_float_float
#define ncx_getn_float_int vtk_netcdf_ncx_getn_float_int
#define ncx_getn_float_longlong vtk_netcdf_ncx_getn_float_longlong
#define ncx_getn_float_schar vtk_netcdf_ncx_getn_float_schar
#define ncx_getn_float_short vtk_netcdf_ncx_getn_float_short
#define ncx_getn_float_uchar vtk_netcdf_ncx_getn_float_uchar
#define ncx_getn_float_uint vtk_netcdf_ncx_getn_float_uint
#define ncx_getn_float_ulonglong vtk_netcdf_ncx_getn_float_ulonglong
#define ncx_getn_int_double vtk_netcdf_ncx_getn_int_double
#define ncx_getn_int_float vtk_netcdf_ncx_getn_int_float
#define ncx_getn_int_int vtk_netcdf_ncx_getn_int_int
#define ncx_getn_int_longlong vtk_netcdf_ncx_getn_int_longlong
#define ncx_getn_int_schar vtk_netcdf_ncx_getn_int_schar
#define ncx_getn_int_short vtk_netcdf_ncx_getn_int_short
#define ncx_getn_int_uchar vtk_netcdf_ncx_getn_int_uchar
#define ncx_getn_int_uint vtk_netcdf_ncx_getn_int_uint
#define ncx_getn_int_ulonglong vtk_netcdf_ncx_getn_int_ulonglong
#define ncx_getn_schar_double vtk_netcdf_ncx_getn_schar_double
#define ncx_getn_schar_float vtk_netcdf_ncx_getn_schar_float
#define ncx_getn_schar_int vtk_netcdf_ncx_getn_schar_int
#define ncx_getn_schar_longlong vtk_netcdf_ncx_getn_schar_longlong
#define ncx_getn_schar_schar vtk_netcdf_ncx_getn_schar_schar
#define ncx_getn_schar_short vtk_netcdf_ncx_getn_schar_short
#define ncx_getn_schar_uchar vtk_netcdf_ncx_getn_schar_uchar
#define ncx_getn_schar_uint vtk_netcdf_ncx_getn_schar_uint
#define ncx_getn_schar_ulonglong vtk_netcdf_ncx_getn_schar_ulonglong
#define ncx_getn_short_double vtk_netcdf_ncx_getn_short_double
#define ncx_getn_short_float vtk_netcdf_ncx_getn_short_float
#define ncx_getn_short_int vtk_netcdf_ncx_getn_short_int
#define ncx_getn_short_longlong vtk_netcdf_ncx_getn_short_longlong
#define ncx_getn_short_schar vtk_netcdf_ncx_getn_short_schar
#define ncx_getn_short_short vtk_netcdf_ncx_getn_short_short
#define ncx_getn_short_uchar vtk_netcdf_ncx_getn_short_uchar
#define ncx_getn_short_uint vtk_netcdf_ncx_getn_short_uint
#define ncx_getn_short_ulonglong vtk_netcdf_ncx_getn_short_ulonglong
#define ncx_getn_text vtk_netcdf_ncx_getn_text
#define ncx_getn_void vtk_netcdf_ncx_getn_void
#define ncx_howmany vtk_netcdf_ncx_howmany
#define ncx_len_NC vtk_netcdf_ncx_len_NC
#define ncx_pad_getn_schar_double vtk_netcdf_ncx_pad_getn_schar_double
#define ncx_pad_getn_schar_float vtk_netcdf_ncx_pad_getn_schar_float
#define ncx_pad_getn_schar_int vtk_netcdf_ncx_pad_getn_schar_int
#define ncx_pad_getn_schar_longlong vtk_netcdf_ncx_pad_getn_schar_longlong
#define ncx_pad_getn_schar_schar vtk_netcdf_ncx_pad_getn_schar_schar
#define ncx_pad_getn_schar_short vtk_netcdf_ncx_pad_getn_schar_short
#define ncx_pad_getn_schar_uchar vtk_netcdf_ncx_pad_getn_schar_uchar
#define ncx_pad_getn_schar_uint vtk_netcdf_ncx_pad_getn_schar_uint
#define ncx_pad_getn_schar_ulonglong vtk_netcdf_ncx_pad_getn_schar_ulonglong
#define ncx_pad_getn_short_double vtk_netcdf_ncx_pad_getn_short_double
#define ncx_pad_getn_short_float vtk_netcdf_ncx_pad_getn_short_float
#define ncx_pad_getn_short_int vtk_netcdf_ncx_pad_getn_short_int
#define ncx_pad_getn_short_longlong vtk_netcdf_ncx_pad_getn_short_longlong
#define ncx_pad_getn_short_schar vtk_netcdf_ncx_pad_getn_short_schar
#define ncx_pad_getn_short_short vtk_netcdf_ncx_pad_getn_short_short
#define ncx_pad_getn_short_uchar vtk_netcdf_ncx_pad_getn_short_uchar
#define ncx_pad_getn_short_uint vtk_netcdf_ncx_pad_getn_short_uint
#define ncx_pad_getn_short_ulonglong vtk_netcdf_ncx_pad_getn_short_ulonglong
#define ncx_pad_getn_text vtk_netcdf_ncx_pad_getn_text
#define ncx_pad_getn_void vtk_netcdf_ncx_pad_getn_void
#define ncx_pad_putn_schar_double vtk_netcdf_ncx_pad_putn_schar_double
#define ncx_pad_putn_schar_float vtk_netcdf_ncx_pad_putn_schar_float
#define ncx_pad_putn_schar_int vtk_netcdf_ncx_pad_putn_schar_int
#define ncx_pad_putn_schar_longlong vtk_netcdf_ncx_pad_putn_schar_longlong
#define ncx_pad_putn_schar_schar vtk_netcdf_ncx_pad_putn_schar_schar
#define ncx_pad_putn_schar_short vtk_netcdf_ncx_pad_putn_schar_short
#define ncx_pad_putn_schar_uchar vtk_netcdf_ncx_pad_putn_schar_uchar
#define ncx_pad_putn_schar_uint vtk_netcdf_ncx_pad_putn_schar_uint
#define ncx_pad_putn_schar_ulonglong vtk_netcdf_ncx_pad_putn_schar_ulonglong
#define ncx_pad_putn_short_double vtk_netcdf_ncx_pad_putn_short_double
#define ncx_pad_putn_short_float vtk_netcdf_ncx_pad_putn_short_float
#define ncx_pad_putn_short_int vtk_netcdf_ncx_pad_putn_short_int
#define ncx_pad_putn_short_longlong vtk_netcdf_ncx_pad_putn_short_longlong
#define ncx_pad_putn_short_schar vtk_netcdf_ncx_pad_putn_short_schar
#define ncx_pad_putn_short_short vtk_netcdf_ncx_pad_putn_short_short
#define ncx_pad_putn_short_uchar vtk_netcdf_ncx_pad_putn_short_uchar
#define ncx_pad_putn_short_uint vtk_netcdf_ncx_pad_putn_short_uint
#define ncx_pad_putn_short_ulonglong vtk_netcdf_ncx_pad_putn_short_ulonglong
#define ncx_pad_putn_text vtk_netcdf_ncx_pad_putn_text
#define ncx_pad_putn_void vtk_netcdf_ncx_pad_putn_void
#define ncx_put_NC vtk_netcdf_ncx_put_NC
#define ncx_put_double_double vtk_netcdf_ncx_put_double_double
#define ncx_put_double_float vtk_netcdf_ncx_put_double_float
#define ncx_put_double_int vtk_netcdf_ncx_put_double_int
#define ncx_put_double_longlong vtk_netcdf_ncx_put_double_longlong
#define ncx_put_double_schar vtk_netcdf_ncx_put_double_schar
#define ncx_put_double_short vtk_netcdf_ncx_put_double_short
#define ncx_put_double_uchar vtk_netcdf_ncx_put_double_uchar
#define ncx_put_double_uint vtk_netcdf_ncx_put_double_uint
#define ncx_put_double_ulonglong vtk_netcdf_ncx_put_double_ulonglong
#define ncx_put_float_double vtk_netcdf_ncx_put_float_double
#define ncx_put_float_float vtk_netcdf_ncx_put_float_float
#define ncx_put_float_int vtk_netcdf_ncx_put_float_int
#define ncx_put_float_longlong vtk_netcdf_ncx_put_float_longlong
#define ncx_put_float_schar vtk_netcdf_ncx_put_float_schar
#define ncx_put_float_short vtk_netcdf_ncx_put_float_short
#define ncx_put_float_uchar vtk_netcdf_ncx_put_float_uchar
#define ncx_put_float_uint vtk_netcdf_ncx_put_float_uint
#define ncx_put_float_ulonglong vtk_netcdf_ncx_put_float_ulonglong
#define ncx_put_int_double vtk_netcdf_ncx_put_int_double
#define ncx_put_int_float vtk_netcdf_ncx_put_int_float
#define ncx_put_int_int vtk_netcdf_ncx_put_int_int
#define ncx_put_int_longlong vtk_netcdf_ncx_put_int_longlong
#define ncx_put_int_schar vtk_netcdf_ncx_put_int_schar
#define ncx_put_int_short vtk_netcdf_ncx_put_int_short
#define ncx_put_int_uchar vtk_netcdf_ncx_put_int_uchar
#define ncx_put_int_uint vtk_netcdf_ncx_put_int_uint
#define ncx_put_int_ulonglong vtk_netcdf_ncx_put_int_ulonglong
#define ncx_put_off_t vtk_netcdf_ncx_put_off_t
#define ncx_put_short_double vtk_netcdf_ncx_put_short_double
#define ncx_put_short_float vtk_netcdf_ncx_put_short_float
#define ncx_put_short_int vtk_netcdf_ncx_put_short_int
#define ncx_put_short_longlong vtk_netcdf_ncx_put_short_longlong
#define ncx_put_short_schar vtk_netcdf_ncx_put_short_schar
#define ncx_put_short_short vtk_netcdf_ncx_put_short_short
#define ncx_put_short_uchar vtk_netcdf_ncx_put_short_uchar
#define ncx_put_short_uint vtk_netcdf_ncx_put_short_uint
#define ncx_put_short_ulonglong vtk_netcdf_ncx_put_short_ulonglong
#define ncx_put_size_t vtk_netcdf_ncx_put_size_t
#define ncx_putn_double_double vtk_netcdf_ncx_putn_double_double
#define ncx_putn_double_float vtk_netcdf_ncx_putn_double_float
#define ncx_putn_double_int vtk_netcdf_ncx_putn_double_int
#define ncx_putn_double_longlong vtk_netcdf_ncx_putn_double_longlong
#define ncx_putn_double_schar vtk_netcdf_ncx_putn_double_schar
#define ncx_putn_double_short vtk_netcdf_ncx_putn_double_short
#define ncx_putn_double_uchar vtk_netcdf_ncx_putn_double_uchar
#define ncx_putn_double_uint vtk_netcdf_ncx_putn_double_uint
#define ncx_putn_double_ulonglong vtk_netcdf_ncx_putn_double_ulonglong
#define ncx_putn_float_double vtk_netcdf_ncx_putn_float_double
#define ncx_putn_float_float vtk_netcdf_ncx_putn_float_float
#define ncx_putn_float_int vtk_netcdf_ncx_putn_float_int
#define ncx_putn_float_longlong vtk_netcdf_ncx_putn_float_longlong
#define ncx_putn_float_schar vtk_netcdf_ncx_putn_float_schar
#define ncx_putn_float_short vtk_netcdf_ncx_putn_float_short
#define ncx_putn_float_uchar vtk_netcdf_ncx_putn_float_uchar
#define ncx_putn_float_uint vtk_netcdf_ncx_putn_float_uint
#define ncx_putn_float_ulonglong vtk_netcdf_ncx_putn_float_ulonglong
#define ncx_putn_int_double vtk_netcdf_ncx_putn_int_double
#define ncx_putn_int_float vtk_netcdf_ncx_putn_int_float
#define ncx_putn_int_int vtk_netcdf_ncx_putn_int_int
#define ncx_putn_int_longlong vtk_netcdf_ncx_putn_int_longlong
#define ncx_putn_int_schar vtk_netcdf_ncx_putn_int_schar
#define ncx_putn_int_short vtk_netcdf_ncx_putn_int_short
#define ncx_putn_int_uchar vtk_netcdf_ncx_putn_int_uchar
#define ncx_putn_int_uint vtk_netcdf_ncx_putn_int_uint
#define ncx_putn_int_ulonglong vtk_netcdf_ncx_putn_int_ulonglong
#define ncx_putn_schar_double vtk_netcdf_ncx_putn_schar_double
#define ncx_putn_schar_float vtk_netcdf_ncx_putn_schar_float
#define ncx_putn_schar_int vtk_netcdf_ncx_putn_schar_int
#define ncx_putn_schar_longlong vtk_netcdf_ncx_putn_schar_longlong
#define ncx_putn_schar_schar vtk_netcdf_ncx_putn_schar_schar
#define ncx_putn_schar_short vtk_netcdf_ncx_putn_schar_short
#define ncx_putn_schar_uchar vtk_netcdf_ncx_putn_schar_uchar
#define ncx_putn_schar_uint vtk_netcdf_ncx_putn_schar_uint
#define ncx_putn_schar_ulonglong vtk_netcdf_ncx_putn_schar_ulonglong
#define ncx_putn_short_double vtk_netcdf_ncx_putn_short_double
#define ncx_putn_short_float vtk_netcdf_ncx_putn_short_float
#define ncx_putn_short_int vtk_netcdf_ncx_putn_short_int
#define ncx_putn_short_longlong vtk_netcdf_ncx_putn_short_longlong
#define ncx_putn_short_schar vtk_netcdf_ncx_putn_short_schar
#define ncx_putn_short_short vtk_netcdf_ncx_putn_short_short
#define ncx_putn_short_uchar vtk_netcdf_ncx_putn_short_uchar
#define ncx_putn_short_uint vtk_netcdf_ncx_putn_short_uint
#define ncx_putn_short_ulonglong vtk_netcdf_ncx_putn_short_ulonglong
#define ncx_putn_text vtk_netcdf_ncx_putn_text
#define ncx_putn_void vtk_netcdf_ncx_putn_void
#define ncx_szof vtk_netcdf_ncx_szof
#define new_NC_string vtk_netcdf_new_NC_string
#define new_x_NC_attr vtk_netcdf_new_x_NC_attr
#define new_x_NC_dim vtk_netcdf_new_x_NC_dim
#define new_x_NC_var vtk_netcdf_new_x_NC_var
#define nextUTF8 vtk_netcdf_nextUTF8
#define nulldup vtk_netcdf_nulldup
#define pg_var vtk_netcdf_pg_var
#define read_numrecs vtk_netcdf_read_numrecs
#define set_NC_string vtk_netcdf_set_NC_string
#define type_list_del vtk_netcdf_type_list_del
#define utf8proc_NFC vtk_netcdf_utf8proc_NFC
#define utf8proc_NFD vtk_netcdf_utf8proc_NFD
#define utf8proc_NFKC vtk_netcdf_utf8proc_NFKC
#define utf8proc_NFKD vtk_netcdf_utf8proc_NFKD
#define utf8proc_check vtk_netcdf_utf8proc_check
#define utf8proc_codepoint_valid vtk_netcdf_utf8proc_codepoint_valid
#define utf8proc_combinations vtk_netcdf_utf8proc_combinations
#define utf8proc_decompose vtk_netcdf_utf8proc_decompose
#define utf8proc_decompose_char vtk_netcdf_utf8proc_decompose_char
#define utf8proc_encode_char vtk_netcdf_utf8proc_encode_char
#define utf8proc_errmsg vtk_netcdf_utf8proc_errmsg
#define utf8proc_get_property vtk_netcdf_utf8proc_get_property
#define utf8proc_iterate vtk_netcdf_utf8proc_iterate
#define utf8proc_map vtk_netcdf_utf8proc_map
#define utf8proc_properties vtk_netcdf_utf8proc_properties
#define utf8proc_reencode vtk_netcdf_utf8proc_reencode
#define utf8proc_sequences vtk_netcdf_utf8proc_sequences
#define utf8proc_stage1table vtk_netcdf_utf8proc_stage1table
#define utf8proc_stage2table vtk_netcdf_utf8proc_stage2table
#define utf8proc_utf8class vtk_netcdf_utf8proc_utf8class
#define write_numrecs vtk_netcdf_write_numrecs

#endif /* vtk_netcdf_mangle_h */
