
if (NOT VersionRange_FIND_VERSION_COMPLETE STREQUAL VersionRange_SPECIFIED_VERSION_COMPLETE)
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_COMPLETE: ${VersionRange_FIND_VERSION_COMPLETE}")
endif()

if (NOT VersionRange_FIND_VERSION VERSION_EQUAL "1.2.3.4")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION: ${VersionRange_FIND_VERSION}")
endif()
if (NOT VersionRange_FIND_VERSION_MAJOR VERSION_EQUAL "1")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MAJOR: ${VersionRange_FIND_VERSION_MAJOR}")
endif()
if (NOT VersionRange_FIND_VERSION_MINOR VERSION_EQUAL "2")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MINOR: ${VersionRange_FIND_VERSION_MINOR}")
endif()
if (NOT VersionRange_FIND_VERSION_PATCH VERSION_EQUAL "3")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_PATCH: ${VersionRange_FIND_VERSION_PATCH}")
endif()
if (NOT VersionRange_FIND_VERSION_TWEAK VERSION_EQUAL "4")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_TWEAK: ${VersionRange_FIND_VERSION_TWEAK}")
endif()

if (NOT VersionRange_FIND_VERSION_RANGE STREQUAL VersionRange_SPECIFIED_VERSION_RANGE)
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_RANGE: ${VersionRange_FIND_VERSION_RANGE}")
endif()
if (NOT VersionRange_FIND_VERSION_RANGE_MIN STREQUAL "INCLUDE")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_RANGE_MIN: ${VersionRange_FIND_VERSION_RANGE_MIN}")
endif()
if (VersionRange_FIND_VERSION_RANGE MATCHES "<[0-9.]+$")
  if (NOT VersionRange_FIND_VERSION_RANGE_MAX STREQUAL "EXCLUDE")
    message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_RANGE_MAX: ${VersionRange_FIND_VERSION_RANGE_MAX}")
  endif()
else()
  if (NOT VersionRange_FIND_VERSION_RANGE_MAX STREQUAL "INCLUDE")
    message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_RANGE_MAX: ${VersionRange_FIND_VERSION_RANGE_MAX}")
  endif()
endif()

if (NOT VersionRange_FIND_VERSION_MIN VERSION_EQUAL "1.2.3.4")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MIN: ${VersionRange_FIND_VERSION}")
endif()
if (NOT VersionRange_FIND_VERSION_MIN_MAJOR VERSION_EQUAL "1")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MIN_MAJOR: ${VersionRange_FIND_VERSION_MIN_MAJOR}")
endif()
if (NOT VersionRange_FIND_VERSION_MIN_MINOR VERSION_EQUAL "2")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MIN_MINOR: ${VersionRange_FIND_VERSION_MIN_MINOR}")
endif()
if (NOT VersionRange_FIND_VERSION_MIN_PATCH VERSION_EQUAL "3")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MIN_PATCH: ${VersionRange_FIND_VERSION_MIN_PATCH}")
endif()
if (NOT VersionRange_FIND_VERSION_MIN_TWEAK VERSION_EQUAL "4")
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MIN_TWEAK: ${VersionRange_FIND_VERSION_MIN_TWEAK}")
endif()

if (NOT VersionRange_FIND_VERSION_MAX VERSION_EQUAL VersionRange_SPECIFIED_VERSION_MAX)
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MAX: ${VersionRange_FIND_VERSION_MAX}")
endif()
if (NOT VersionRange_FIND_VERSION_MAX_MAJOR VERSION_EQUAL VersionRange_SPECIFIED_VERSION_MAX_MAJOR)
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MAX_MAJOR: ${VersionRange_FIND_VERSION_MAX_MAJOR}")
endif()
if (NOT VersionRange_FIND_VERSION_MAX_MINOR VERSION_EQUAL VersionRange_SPECIFIED_VERSION_MAX_MINOR)
  message (SEND_ERROR "Wrong value for VersionRange_FIND_VERSION_MAX_MINOR: ${VersionRange_FIND_VERSION_MAX_MINOR}")
endif()
if (NOT VersionRange_FIND_VERSION_MAX_PATCH VERSION_EQUAL VersionRange_SPECIFIED_VERSION_MAX_PATCH)
  message (SEND_ERROR "Wrong value for VersionRange_VERSION_FIND_MAX_PATCH: ${VersionRange_FIND_VERSION_MAX_PATCH}")
endif()
if (NOT VersionRange_FIND_VERSION_MAX_TWEAK VERSION_EQUAL VersionRange_SPECIFIED_VERSION_MAX_TWEAK)
  message (SEND_ERROR "Wrong value for VersionRange_VERSION_FIND_MAX_TWEAK: ${VersionRange_FIND_VERSION_MAX_TWEAK}")
endif()

if ((VersionRange_FIND_VERSION_RANGE_MAX STREQUAL "INCLUDE"
      AND "2.3.4.5" VERSION_LESS_EQUAL VersionRange_FIND_VERSION_MAX)
    OR (VersionRange_FIND_VERSION_RANGE_MAX STREQUAL "EXCLUDE"
      AND "2.3.4.5" VERSION_LESS VersionRange_FIND_VERSION_MAX))
set (VersionRange_FOUND TRUE)
set (VersionRange_VERSION 2.3.4.5)
set (VersionRange_VERSION_MAJOR 2)
set (VersionRange_VERSION_MINOR 3)
set (VersionRange_VERSION_PATCH 4)
set (VersionRange_VERSION_TWEAK 5)
else()
  set (VersionRange_FOUND FALSE)
endif()
