/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile$
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


  Copyright (c) 2000 National Library of Medicine
  All rights reserved.

  See COPYRIGHT.txt for copyright details.

=========================================================================*/
#include "cmIncludeCommand.h"


// cmIncludeCommand
bool cmIncludeCommand::InitialPass(std::vector<std::string> const& argsIn)
{
  if (argsIn.size()< 1 || argsIn.size() > 2)
    {
      this->SetError("called with wrong number of arguments.  "
                     "Include only takes one file.");
    }
  std::vector<std::string> args = argsIn;
  m_Makefile->ExpandVariablesInString( args[0]);
  bool exists = cmSystemTools::FileExists(args[0].c_str());
  if(args.size() == 2 && args[1] == "OPTIONAL" && !exists)
    {
    return true;
    }
  if(!exists)
    {
    std::string error = "Include file not found: " + args[0] + "\n";
    this->SetError(error.c_str());
    return false;
    }
  m_Makefile->ReadListFile( m_Makefile->GetCurrentListFile(), 
                            args[0].c_str());
  return true;
}


