include(RunCMake)

set(RunCMake_GENERATOR_TOOLSET "")
run_cmake(NoToolset)

if("${RunCMake_GENERATOR}" MATCHES "Visual Studio 1[012456]")
  set(RunCMake_GENERATOR_TOOLSET "Test Toolset")
  run_cmake(TestToolset)
  set(RunCMake_GENERATOR_TOOLSET "Test Toolset,cuda=0.0")
  run_cmake(TestToolsetCudaBoth)
  set(RunCMake_GENERATOR_TOOLSET ",cuda=0.0")
  run_cmake(TestToolsetCudaVersionOnly)
  set(RunCMake_GENERATOR_TOOLSET "cuda=0.0")
  run_cmake(TestToolsetCudaVersionOnly)
  set(RunCMake_GENERATOR_TOOLSET "cuda=C:\\dummy\\cuda")
  run_cmake(TestToolsetCudaPathOnly)
  if("${RunCMake_GENERATOR}" MATCHES "Visual Studio 1[2456]")
    set(RunCMake_GENERATOR_TOOLSET "Test Toolset,host=x64")
    run_cmake(TestToolsetHostArchBoth)
    set(RunCMake_GENERATOR_TOOLSET ",host=x64")
    run_cmake(TestToolsetHostArchOnly_x64)
    set(RunCMake_GENERATOR_TOOLSET "host=x64")
    run_cmake(TestToolsetHostArchOnly_x64)
    set(RunCMake_GENERATOR_TOOLSET "host=x86")
    run_cmake(TestToolsetHostArchOnly_x86)
    set(RunCMake_GENERATOR_TOOLSET "Test Toolset")
    run_cmake(TestToolsetHostArchNone)
    set(RunCMake_GENERATOR_TOOLSET "Test Toolset,host=x65")
    run_cmake(BadToolsetHostArch)
    set(RunCMake_GENERATOR_TOOLSET "Test Toolset,host=x64,host=x86")
    run_cmake(BadToolsetHostArchTwice)
    if("${RunCMake_GENERATOR}" MATCHES "Visual Studio 1[56]")
      set(RunCMake_GENERATOR_TOOLSET "Test Toolset,version=Test Toolset Version")
      run_cmake(TestToolsetVersionBoth)
      set(RunCMake_GENERATOR_TOOLSET ",version=Test Toolset Version")
      run_cmake(TestToolsetVersionOnly)
      set(RunCMake_GENERATOR_TOOLSET "version=Test Toolset Version")
      run_cmake(TestToolsetVersionOnly)
      set(RunCMake_GENERATOR_TOOLSET "Test Toolset,version=Bad Toolset Version")
      run_cmake(BadToolsetVersion)
      set(RunCMake_GENERATOR_TOOLSET "Test Toolset,version=Test Toolset Version,version=Test Toolset Version")
      run_cmake(BadToolsetVersionTwice)
    endif()
  else()
    set(RunCMake_GENERATOR_TOOLSET "Test Toolset,host=x64")
    run_cmake(BadToolsetHostArch)
  endif()
  set(RunCMake_GENERATOR_TOOLSET "Test Toolset,not_a_key")
  run_cmake(BadToolsetFormat)
elseif("${RunCMake_GENERATOR}" STREQUAL "Xcode")
  set(RunCMake_GENERATOR_TOOLSET "Test Toolset")
  run_cmake(TestToolset)
  set(RunCMake_GENERATOR_TOOLSET "Test Toolset,host=x64")
  run_cmake(BadToolsetHostArchXcode)
else()
  set(RunCMake_GENERATOR_TOOLSET "Bad Toolset")
  run_cmake(BadToolset)
endif()

set(RunCMake_GENERATOR_TOOLSET "")

set(RunCMake_TEST_OPTIONS -T "Extra Toolset")
run_cmake(TwoToolsets)
unset(RunCMake_TEST_OPTIONS)

if("${RunCMake_GENERATOR}" MATCHES "Visual Studio 1[012456]|Xcode")
  set(RunCMake_TEST_OPTIONS -DCMAKE_TOOLCHAIN_FILE=${RunCMake_SOURCE_DIR}/TestToolset-toolchain.cmake)
  run_cmake(TestToolsetToolchain)
  unset(RunCMake_TEST_OPTIONS)
else()
  set(RunCMake_TEST_OPTIONS -DCMAKE_TOOLCHAIN_FILE=${RunCMake_SOURCE_DIR}/BadToolset-toolchain.cmake)
  run_cmake(BadToolsetToolchain)
  unset(RunCMake_TEST_OPTIONS)
endif()
