#
# Test SET
#
set (ZERO_VAR 0)
set (ZERO_VAR2 0)

if(ZERO_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED)
else(ZERO_VAR)
  add_definitions(-DSHOULD_BE_DEFINED)
endif(ZERO_VAR)

set(ONE_VAR 1)
set(ONE_VAR2 1)
set(STRING_VAR "CMake is great" CACHE STRING "test a cache variable")

#
# Test VARIABLE_REQUIRES
#
variable_requires(ONE_VAR
                  ONE_VAR_IS_DEFINED ONE_VAR)

#
# Test various IF/ELSE combinations
#
if(NOT ZERO_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_NOT)
else(NOT ZERO_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_NOT)
endif(NOT ZERO_VAR)

if(NOT ONE_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_NOT2)
else(NOT ONE_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_NOT2)
endif(NOT ONE_VAR)

if(ONE_VAR AND ONE_VAR2)
  add_definitions(-DSHOULD_BE_DEFINED_AND)
else(ONE_VAR AND ONE_VAR2)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_AND)
endif(ONE_VAR AND ONE_VAR2)

if(ONE_VAR AND ZERO_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_AND2)
else(ONE_VAR AND ZERO_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_AND2)
endif(ONE_VAR AND ZERO_VAR)

if(ZERO_VAR OR ONE_VAR2)
  add_definitions(-DSHOULD_BE_DEFINED_OR)
else(ZERO_VAR OR ONE_VAR2)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_OR)
endif(ZERO_VAR OR ONE_VAR2)

if(ZERO_VAR OR ZERO_VAR2)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_OR2)
else(ZERO_VAR OR ZERO_VAR2)
  add_definitions(-DSHOULD_BE_DEFINED_OR2)
endif(ZERO_VAR OR ZERO_VAR2)

if(STRING_VAR MATCHES "^CMake")
  add_definitions(-DSHOULD_BE_DEFINED_MATCHES)
else(STRING_VAR MATCHES "^CMake")
  add_definitions(-DSHOULD_NOT_BE_DEFINED_MATCHES)
endif(STRING_VAR MATCHES "^CMake")

if(STRING_VAR MATCHES "^foo")
  add_definitions(-DSHOULD_NOT_BE_DEFINED_MATCHES2)
else(STRING_VAR MATCHES "^foo")
  add_definitions(-DSHOULD_BE_DEFINED_MATCHES2)
endif(STRING_VAR MATCHES "^foo")

if(COMMAND "IF")
  add_definitions(-DSHOULD_BE_DEFINED_COMMAND)
else(COMMAND "IF")
  add_definitions(-DSHOULD_NOT_BE_DEFINED_COMMAND)
endif(COMMAND "IF")

if(COMMAND "ROQUEFORT")
  add_definitions(-DSHOULD_NOT_BE_DEFINED_COMMAND2)
else(COMMAND "ROQUEFORT")
  add_definitions(-DSHOULD_BE_DEFINED_COMMAND2)
endif(COMMAND "ROQUEFORT")

if (EXISTS ${Complex_SOURCE_DIR}/VarTests.cmake)
  add_definitions(-DSHOULD_BE_DEFINED_EXISTS)
else(EXISTS ${Complex_SOURCE_DIR}/VarTests.cmake)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_EXISTS)
endif (EXISTS ${Complex_SOURCE_DIR}/VarTests.cmake)

if (EXISTS ${Complex_SOURCE_DIR}/roquefort.txt)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_EXISTS2)
else(EXISTS ${Complex_SOURCE_DIR}/roquefort.txt)
  add_definitions(-DSHOULD_BE_DEFINED_EXISTS2)
endif (EXISTS ${Complex_SOURCE_DIR}/roquefort.txt)

if (IS_DIRECTORY ${Complex_SOURCE_DIR})
  add_definitions(-DSHOULD_BE_DEFINED_IS_DIRECTORY)
endif (IS_DIRECTORY ${Complex_SOURCE_DIR})

if (NOT IS_DIRECTORY ${Complex_SOURCE_DIR}/VarTests.cmake)
  add_definitions(-DSHOULD_BE_DEFINED_IS_DIRECTORY2)
endif (NOT IS_DIRECTORY ${Complex_SOURCE_DIR}/VarTests.cmake)

set (SNUM1_VAR "1")
set (SNUM2_VAR "2")
set (SNUM3_VAR "1")


if (SNUM1_VAR LESS SNUM2_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_LESS)
else (SNUM1_VAR LESS SNUM2_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_LESS)
endif (SNUM1_VAR LESS SNUM2_VAR)

if (SNUM2_VAR LESS SNUM1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_LESS2)
else (SNUM2_VAR LESS SNUM1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_LESS2)
endif (SNUM2_VAR LESS SNUM1_VAR)

if (SNUM2_VAR GREATER SNUM1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_GREATER)
else (SNUM2_VAR GREATER SNUM1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_GREATER)
endif (SNUM2_VAR GREATER SNUM1_VAR)

if (SNUM2_VAR EQUAL SNUM1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_EQUAL)
else (SNUM2_VAR EQUAL SNUM1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_EQUAL)
endif (SNUM2_VAR EQUAL SNUM1_VAR)

if (SNUM3_VAR EQUAL SNUM1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_EQUAL)
else (SNUM3_VAR EQUAL SNUM1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_EQUAL)
endif (SNUM3_VAR EQUAL SNUM1_VAR)

if (SNUM1_VAR GREATER SNUM2_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_GREATER2)
else (SNUM1_VAR GREATER SNUM2_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_GREATER2)
endif (SNUM1_VAR GREATER SNUM2_VAR)

set (SSTR1_VAR "abc")
set (SSTR2_VAR "bcd")

if (SSTR1_VAR STRLESS SSTR2_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_STRLESS)
else (SSTR1_VAR STRLESS SSTR2_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_STRLESS)
endif (SSTR1_VAR STRLESS SSTR2_VAR)

if (SSTR2_VAR STRLESS SSTR1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_STRLESS2)
else (SSTR2_VAR STRLESS SSTR1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_STRLESS2)
endif (SSTR2_VAR STRLESS SSTR1_VAR)

if (SSTR2_VAR STRGREATER SSTR1_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_STRGREATER)
else (SSTR2_VAR STRGREATER SSTR1_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_STRGREATER)
endif (SSTR2_VAR STRGREATER SSTR1_VAR)

if (SSTR1_VAR STRGREATER SSTR2_VAR)
  add_definitions(-DSHOULD_NOT_BE_DEFINED_STRGREATER2)
else (SSTR1_VAR STRGREATER SSTR2_VAR)
  add_definitions(-DSHOULD_BE_DEFINED_STRGREATER2)
endif (SSTR1_VAR STRGREATER SSTR2_VAR)

#
# Test FOREACH
#
foreach (INDEX 1 2)
  set(FOREACH_VAR${INDEX} "VALUE${INDEX}")
endforeach(INDEX)

set(FOREACH_CONCAT "")
foreach (INDEX a;b;c;d;e;f;g)
  set(FOREACH_CONCAT "${FOREACH_CONCAT}${INDEX}")
endforeach(INDEX)

#
# Test FIND_FILE, FIND_PATH and various GET_FILENAME_COMPONENT combinations
#
find_file(FILENAME_VAR "VarTests.cmake" ${Complex_SOURCE_DIR})

get_filename_component(FILENAME_VAR_PATH ${FILENAME_VAR} PATH)
get_filename_component(FILENAME_VAR_PATH_NAME ${FILENAME_VAR_PATH} NAME)
get_filename_component(FILENAME_VAR_NAME ${FILENAME_VAR} NAME)
get_filename_component(FILENAME_VAR_EXT ${FILENAME_VAR} EXT)
get_filename_component(FILENAME_VAR_NAME_WE ${FILENAME_VAR} NAME_WE CACHE)

find_path(PATH_VAR "cmTestConfigure.h.in" ${Complex_SOURCE_DIR})
get_filename_component(PATH_VAR_NAME ${PATH_VAR} NAME)
