set(cmpFile   ${RunCMake_TEST_BINARY_DIR}/cmpTimeStamp.txt)
set(scriptDir ${RunCMake_TEST_BINARY_DIR}/tmp)
set(stampDir  ${RunCMake_TEST_BINARY_DIR}/src/customcommands-stamp)

set(errorMessages)
if(NOT EXISTS "${cmpFile}")
  list(APPEND errorMessages "  ${cmpFile} is missing")
else()
  foreach(script IN ITEMS mkdirs download patch)
    set(scriptFile "${scriptDir}/customcommands-${script}.cmake")
    if(NOT EXISTS "${scriptFile}")
      list(APPEND errorMessages "  ${scriptFile} is missing")
    elseif(NOT "${cmpFile}" IS_NEWER_THAN "${scriptFile}")
      list(APPEND errorMessages "  ${scriptFile} was unexectedly updated")
    endif()
  endforeach()

  # special case, not a script, has different extension
  set(repoInfoFile "${scriptDir}/customcommands-download-repoinfo.txt")
  if(NOT EXISTS "${repoInfoFile}")
    list(APPEND errorMessages "  ${repoInfoFile} is missing")
  elseif(NOT "${cmpFile}" IS_NEWER_THAN "${repoInfoFile}")
    list(APPEND errorMessages "  ${repoInfoFile} was unexectedly updated")
  endif()

  foreach(step IN ITEMS download patch)
    set(stampFile "${stampDir}/customcommands-${step}")
    if(NOT EXISTS "${stampFile}")
      list(APPEND errorMessages "  ${stampFile} is missing")
    elseif(NOT "${cmpFile}" IS_NEWER_THAN "${stampFile}")
      list(APPEND errorMessages "  ${stampFile} was unexectedly updated")
    endif()
  endforeach()
endif()

if(errorMessages)
  list(JOIN errorMessages "\n" RunCMake_TEST_FAILED)
endif()
