/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile$
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

  Copyright (c) 2002 Insight Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#include "cmAddExecutableCommand.h"
#include "cmCacheManager.h"

// cmExecutableCommand
bool cmAddExecutableCommand::InitialPass(std::vector<std::string> const& args)
{
  if(args.size() < 2 )
    {
    this->SetError("called with incorrect number of arguments");
    return false;
    }

  std::vector<std::string>::const_iterator s = args.begin();

  std::string exename = *s;
  m_Makefile->ExpandVariablesInString(exename);

  ++s;
  if (*s == "WIN32")
    {
    ++s;
    std::vector<std::string> srclists(s, args.end());
    m_Makefile->AddExecutable(exename.c_str(),srclists, true); 
    }
  else
    {
    std::vector<std::string> srclists(s, args.end());
    m_Makefile->AddExecutable(exename.c_str(),srclists, false); 
    }
  
  return true;
}

