set(vcFiltersFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj.filters")
if(NOT EXISTS "${vcFiltersFile}")
  set(RunCMake_TEST_FAILED "Filters file ${vcFiltersFile} does not exist.")
  return()
endif()

set(foundFileFilter 0)
set(foundFilter 0)
file(STRINGS "${vcFiltersFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "<Filter>CMakeListsSourceGroup</Filter>")
    set(rule "${CMAKE_MATCH_1}")
    if(foundFileFilter)
      set(RunCMake_TEST_FAILED "Multiple files listed with filter for CMakeListsSourceGroup.")
      return()
    endif()
    set(foundFileFilter 1)
  endif()
  if(line MATCHES "<Filter.*Include=\"CMakeListsSourceGroup\"")
    set(rule "${CMAKE_MATCH_1}")
    if(foundFilter)
      set(RunCMake_TEST_FAILED "Multiple copies of CMakeListsSourceGroup filter listed.")
      return()
    endif()
    set(foundFilter 1)
  endif()
endforeach()
if(NOT foundFileFilter)
  set(RunCMake_TEST_FAILED "File filter for CMakeListsSourceGroup not found.")
endif()
if(NOT foundFilter)
  set(RunCMake_TEST_FAILED "Filter CMakeListsSourceGroup not found.")
endif()
