#### import the simple module from the paraview
from paraview.simple import *
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

try:
  DATAPATH
except NameError:
  print("Please set the DATAPATH variable with the full path to the directory that contains this script and the CSV files. Type: DATAPATH='/path/to/the_cvs_datasets/'")

RemoveViewsAndLayouts()

layout1 = CreateLayout()

# create a new 'CSV Reader'
campbell_1d_input_parameterscsv = CSVReader(FileName=[DATAPATH+'/campbell_1d_input_parameters.csv'])

# create a new 'CSV Reader'
campbell_1d_output_curvescsv = CSVReader(FileName=[DATAPATH+'/campbell_1d_output_curves.csv'])

# create a new 'Transpose Table'
transposeTable1 = TransposeTable(Input=campbell_1d_output_curvescsv)
transposeTable1.VariablesofInterest = ['', 'V1', 'V10', 'V100', 'V101', 'V102', 'V103', 'V104', 'V105', 'V106', 'V107', 'V108', 'V109', 'V11', 'V110', 'V111', 'V112', 'V113', 'V114', 'V115', 'V116', 'V117', 'V118', 'V119', 'V12', 'V120', 'V121', 'V122', 'V123', 'V124', 'V125', 'V126', 'V127', 'V128', 'V129', 'V13', 'V130', 'V131', 'V132', 'V133', 'V134', 'V135', 'V136', 'V137', 'V138', 'V139', 'V14', 'V140', 'V141', 'V142', 'V143', 'V144', 'V145', 'V146', 'V147', 'V148', 'V149', 'V15', 'V150', 'V151', 'V152', 'V153', 'V154', 'V155', 'V156', 'V157', 'V158', 'V159', 'V16', 'V160', 'V161', 'V162', 'V163', 'V164', 'V165', 'V166', 'V167', 'V168', 'V169', 'V17', 'V170', 'V171', 'V172', 'V173', 'V174', 'V175', 'V176', 'V177', 'V178', 'V179', 'V18', 'V180', 'V181', 'V19', 'V2', 'V20', 'V21', 'V22', 'V23', 'V24', 'V25', 'V26', 'V27', 'V28', 'V29', 'V3', 'V30', 'V31', 'V32', 'V33', 'V34', 'V35', 'V36', 'V37', 'V38', 'V39', 'V4', 'V40', 'V41', 'V42', 'V43', 'V44', 'V45', 'V46', 'V47', 'V48', 'V49', 'V5', 'V50', 'V51', 'V52', 'V53', 'V54', 'V55', 'V56', 'V57', 'V58', 'V59', 'V6', 'V60', 'V61', 'V62', 'V63', 'V64', 'V65', 'V66', 'V67', 'V68', 'V69', 'V7', 'V70', 'V71', 'V72', 'V73', 'V74', 'V75', 'V76', 'V77', 'V78', 'V79', 'V8', 'V80', 'V81', 'V82', 'V83', 'V84', 'V85', 'V86', 'V87', 'V88', 'V89', 'V9', 'V90', 'V91', 'V92', 'V93', 'V94', 'V95', 'V96', 'V97', 'V98', 'V99']

# Properties modified on transposeTable1
transposeTable1.VariablesofInterest = ['V1', 'V10', 'V100', 'V101', 'V102', 'V103', 'V104', 'V105', 'V106', 'V107', 'V108', 'V109', 'V11', 'V110', 'V111', 'V112', 'V113', 'V114', 'V115', 'V116', 'V117', 'V118', 'V119', 'V12', 'V120', 'V121', 'V122', 'V123', 'V124', 'V125', 'V126', 'V127', 'V128', 'V129', 'V13', 'V130', 'V131', 'V132', 'V133', 'V134', 'V135', 'V136', 'V137', 'V138', 'V139', 'V14', 'V140', 'V141', 'V142', 'V143', 'V144', 'V145', 'V146', 'V147', 'V148', 'V149', 'V15', 'V150', 'V151', 'V152', 'V153', 'V154', 'V155', 'V156', 'V157', 'V158', 'V159', 'V16', 'V160', 'V161', 'V162', 'V163', 'V164', 'V165', 'V166', 'V167', 'V168', 'V169', 'V17', 'V170', 'V171', 'V172', 'V173', 'V174', 'V175', 'V176', 'V177', 'V178', 'V179', 'V18', 'V180', 'V181', 'V19', 'V2', 'V20', 'V21', 'V22', 'V23', 'V24', 'V25', 'V26', 'V27', 'V28', 'V29', 'V3', 'V30', 'V31', 'V32', 'V33', 'V34', 'V35', 'V36', 'V37', 'V38', 'V39', 'V4', 'V40', 'V41', 'V42', 'V43', 'V44', 'V45', 'V46', 'V47', 'V48', 'V49', 'V5', 'V50', 'V51', 'V52', 'V53', 'V54', 'V55', 'V56', 'V57', 'V58', 'V59', 'V6', 'V60', 'V61', 'V62', 'V63', 'V64', 'V65', 'V66', 'V67', 'V68', 'V69', 'V7', 'V70', 'V71', 'V72', 'V73', 'V74', 'V75', 'V76', 'V77', 'V78', 'V79', 'V8', 'V80', 'V81', 'V82', 'V83', 'V84', 'V85', 'V86', 'V87', 'V88', 'V89', 'V9', 'V90', 'V91', 'V92', 'V93', 'V94', 'V95', 'V96', 'V97', 'V98', 'V99']
transposeTable1.Addacolumnwithoriginalcolumnsname = 0

# create a new 'Extract Bag Plots'
extractBagPlots1 = ExtractBagPlots(Input=transposeTable1)
extractBagPlots1.VariablesofInterest = ['000', '001', '002', '003', '004', '005', '006', '007', '008', '009', '010', '011', '012', '013', '014', '015', '016', '017', '018', '019', '020', '021', '022', '023', '024', '025', '026', '027', '028', '029', '030', '031', '032', '033', '034', '035', '036', '037', '038', '039', '040', '041', '042', '043', '044', '045', '046', '047', '048', '049', '050', '051', '052', '053', '054', '055', '056', '057', '058', '059', '060', '061', '062', '063', '064', '065', '066', '067', '068', '069', '070', '071', '072', '073', '074', '075', '076', '077', '078', '079', '080', '081', '082', '083', '084', '085', '086', '087', '088', '089', '090', '091', '092', '093', '094', '095', '096', '097', '098', '099', '100', '101', '102', '103', '104', '105', '106', '107', '108', '109', '110', '111', '112', '113', '114', '115', '116', '117', '118', '119', '120', '121', '122', '123', '124', '125', '126', '127', '128', '129', '130', '131', '132', '133', '134', '135', '136', '137', '138', '139', '140', '141', '142', '143', '144', '145', '146', '147', '148', '149', '150', '151', '152', '153', '154', '155', '156', '157', '158', '159', '160', '161', '162', '163', '164', '165', '166', '167', '168', '169', '170', '171', '172', '173', '174', '175', '176', '177', '178', '179', '180', '181', '182', '183', '184', '185', '186', '187', '188', '189', '190', '191', '192', '193', '194', '195', '196', '197', '198', '199', '200', '201', '202', '203', '204', '205', '206', '207', '208', '209', '210', '211', '212', '213', '214', '215', '216', '217', '218', '219', '220', '221', '222', '223', '224', '225', '226', '227', '228', '229', '230', '231', '232', '233', '234', '235', '236', '237', '238', '239', '240', '241', '242', '243', '244', '245', '246', '247', '248', '249', '250', '251', '252', '253', '254', '255', '256', '257', '258', '259', '260', '261', '262', '263', '264', '265', '266', '267', '268', '269', '270', '271', '272', '273', '274', '275', '276', '277', '278', '279', '280', '281', '282', '283', '284', '285', '286', '287', '288', '289', '290', '291', '292', '293', '294', '295', '296', '297', '298', '299', '300', '301', '302', '303', '304', '305', '306', '307', '308', '309', '310', '311', '312', '313', '314', '315', '316', '317', '318', '319', '320', '321', '322', '323', '324', '325', '326', '327', '328', '329', '330', '331', '332', '333', '334', '335', '336', '337', '338', '339', '340', '341', '342', '343', '344', '345', '346', '347', '348', '349', '350', '351', '352', '353', '354', '355', '356', '357', '358', '359', '360', '361', '362', '363', '364', '365', '366', '367', '368', '369', '370', '371', '372', '373', '374', '375', '376', '377', '378', '379', '380', '381', '382', '383', '384', '385', '386', '387', '388', '389', '390', '391', '392', '393', '394', '395', '396', '397', '398', '399']

# Create a new 'FunctionalBag Chart View'
functionalBagChartView1 = CreateView('XYFunctionalBagChartView')

# show data in view
extractBagPlots1Display = Show(extractBagPlots1, functionalBagChartView1)

# trace defaults for the display properties.
extractBagPlots1Display.AttributeType = 'Row Data'
extractBagPlots1Display.SeriesLabel = ['000', '000', '001', '001', '002', '002', '003', '003', '004', '004', '005', '005', '006', '006', '007', '007', '008', '008', '009', '009', '010', '010', '011', '011', '012', '012', '013', '013', '014', '014', '015', '015', '016', '016', '017', '017', '018', '018', '019', '019', '020', '020', '021', '021', '022', '022', '023', '023', '024', '024', '025', '025', '026', '026', '027', '027', '028', '028', '029_outlier', '029', '030', '030', '031', '031', '032', '032', '033', '033', '034', '034', '035', '035', '036', '036', '037', '037', '038', '038', '039', '039', '040', '040', '041', '041', '042', '042', '043', '043', '044', '044', '045', '045', '046', '046', '047', '047', '048', '048', '049', '049', '050', '050', '051', '051', '052', '052', '053', '053', '054', '054', '055', '055', '056', '056', '057', '057', '058', '058', '059', '059', '060', '060', '061', '061', '062', '062', '063', '063', '064', '064', '065', '065', '066', '066', '067', '067', '068', '068', '069', '069', '070', '070', '071', '071', '072', '072', '073', '073', '074', '074', '075', '075', '076', '076', '077', '077', '078', '078', '079', '079', '080', '080', '081', '081', '082', '082', '083', '083', '084', '084', '085', '085', '086', '086', '087', '087', '088', '088', '089', '089', '090', '090', '091', '091', '092', '092', '093', '093', '094', '094', '095', '095', '096', '096', '097', '097', '098', '098', '099', '099', '100', '100', '101', '101', '102', '102', '103', '103', '104', '104', '105', '105', '106', '106', '107', '107', '108', '108', '109', '109', '110', '110', '111', '111', '112', '112', '113', '113', '114', '114', '115', '115', '116', '116', '117', '117', '118', '118', '119', '119', '120', '120', '121', '121', '122', '122', '123', '123', '124', '124', '125', '125', '126', '126', '127', '127', '128', '128', '129', '129', '130', '130', '131', '131', '132', '132', '133', '133', '134', '134', '135', '135', '136', '136', '137', '137', '138', '138', '139', '139', '140', '140', '141', '141', '142', '142', '143', '143', '144', '144', '145', '145', '146', '146', '147', '147', '148', '148', '149', '149', '150', '150', '151', '151', '152', '152', '153', '153', '154', '154', '155', '155', '156', '156', '157', '157', '158', '158', '159', '159', '160', '160', '161', '161', '162', '162', '163', '163', '164', '164', '165', '165', '166', '166', '167', '167', '168', '168', '169', '169', '170', '170', '171', '171', '172', '172', '173', '173', '174', '174', '175', '175', '176', '176', '177', '177', '178', '178', '179', '179', '180', '180', '181', '181', '182', '182', '183', '183', '184', '184', '185', '185', '186', '186', '187', '187', '188', '188', '189', '189', '190', '190', '191', '191', '192', '192', '193', '193', '194', '194', '195', '195', '196', '196', '197', '197', '198', '198', '199', '199', '200', '200', '201', '201', '202', '202', '203', '203', '204', '204', '205', '205', '206', '206', '207', '207', '208', '208', '209', '209', '210', '210', '211', '211', '212', '212', '213', '213', '214', '214', '215', '215', '216', '216', '217', '217', '218', '218', '219', '219', '220', '220', '221', '221', '222', '222', '223', '223', '224', '224', '225', '225', '226', '226', '227', '227', '228', '228', '229', '229', '230', '230', '231', '231', '232', '232', '233', '233', '234', '234', '235', '235', '236', '236', '237', '237', '238', '238', '239', '239', '240', '240', '241', '241', '242', '242', '243', '243', '244', '244', '245', '245', '246', '246', '247', '247', '248', '248', '249', '249', '250', '250', '251', '251', '252', '252', '253', '253', '254', '254', '255', '255', '256', '256', '257', '257', '258', '258', '259', '259', '260', '260', '261', '261', '262', '262', '263', '263', '264', '264', '265', '265', '266', '266', '267', '267', '268', '268', '269', '269', '270', '270', '271', '271', '272', '272', '273', '273', '274', '274', '275', '275', '276', '276', '277', '277', '278', '278', '279', '279', '280', '280', '281', '281', '282', '282', '283', '283', '284', '284', '285', '285', '286', '286', '287', '287', '288', '288', '289', '289', '290', '290', '291', '291', '292', '292', '293', '293', '294', '294', '295', '295', '296', '296', '297', '297', '298', '298', '299', '299', '300', '300', '301', '301', '302', '302', '303', '303', '304', '304', '305', '305', '306', '306', '307', '307', '308', '308', '309', '309', '310', '310', '311', '311', '312', '312', '313', '313', '314', '314', '315', '315', '316', '316', '317', '317', '318', '318', '319', '319', '320', '320', '321', '321', '322', '322', '323', '323', '324', '324', '325', '325', '326', '326', '327', '327', '328', '328', '329', '329', '330', '330', '331', '331', '332', '332', '333', '333', '334', '334', '335', '335', '336', '336', '337', '337', '338', '338', '339', '339', '340', '340', '341', '341', '342', '342', '343', '343', '344', '344', '345', '345', '346', '346', '347', '347', '348', '348', '349', '349', '350', '350', '351', '351', '352', '352', '353', '353', '354', '354', '355', '355', '356', '356', '357', '357', '358', '358', '359', '359', '360', '360', '361', '361', '362', '362', '363', '363', '364', '364', '365', '365', '366', '366', '367', '367', '368', '368', '369', '369', '370', '370', '371', '371', '372', '372', '373', '373', '374', '374', '375', '375', '376', '376', '377', '377', '378', '378', '379_median', 'Median (379)', '380', '380', '381', '381', '382', '382', '383', '383', '384', '384', '385', '385', '386', '386', '387', '387', '388', '388', '389', '389', '390', '390', '391', '391', '392', '392', '393', '393', '394', '394', '395', '395', '396', '396', '397', '397', '398', '398', '399', '399', 'Q3Points95', '95%', 'QMedPoints', '50%']
extractBagPlots1Display.SeriesColor = ['000', '0', '0', '0', '001', '0.89', '0.1', '0.11', '002', '0.22', '0.49', '0.72', '003', '0.3', '0.69', '0.29', '004', '0.6', '0.31', '0.64', '005', '1', '0.5', '0', '006', '0.65', '0.34', '0.16', '007', '0', '0', '0', '008', '0.89', '0.1', '0.11', '009', '0.22', '0.49', '0.72', '010', '0.3', '0.69', '0.29', '011', '0.6', '0.31', '0.64', '012', '1', '0.5', '0', '013', '0.65', '0.34', '0.16', '014', '0', '0', '0', '015', '0.89', '0.1', '0.11', '016', '0.22', '0.49', '0.72', '017', '0.3', '0.69', '0.29', '018', '0.6', '0.31', '0.64', '019', '1', '0.5', '0', '020', '0.65', '0.34', '0.16', '021', '0', '0', '0', '022', '0.89', '0.1', '0.11', '023', '0.22', '0.49', '0.72', '024', '0.3', '0.69', '0.29', '025', '0.6', '0.31', '0.64', '026', '1', '0.5', '0', '027', '0.65', '0.34', '0.16', '028', '0', '0', '0', '029_outlier', '0.89', '0.1', '0.11', '030', '0.22', '0.49', '0.72', '031', '0.3', '0.69', '0.29', '032', '0.6', '0.31', '0.64', '033', '1', '0.5', '0', '034', '0.65', '0.34', '0.16', '035', '0', '0', '0', '036', '0.89', '0.1', '0.11', '037', '0.22', '0.49', '0.72', '038', '0.3', '0.69', '0.29', '039', '0.6', '0.31', '0.64', '040', '1', '0.5', '0', '041', '0.65', '0.34', '0.16', '042', '0', '0', '0', '043', '0.89', '0.1', '0.11', '044', '0.22', '0.49', '0.72', '045', '0.3', '0.69', '0.29', '046', '0.6', '0.31', '0.64', '047', '1', '0.5', '0', '048', '0.65', '0.34', '0.16', '049', '0', '0', '0', '050', '0.89', '0.1', '0.11', '051', '0.22', '0.49', '0.72', '052', '0.3', '0.69', '0.29', '053', '0.6', '0.31', '0.64', '054', '1', '0.5', '0', '055', '0.65', '0.34', '0.16', '056', '0', '0', '0', '057', '0.89', '0.1', '0.11', '058', '0.22', '0.49', '0.72', '059', '0.3', '0.69', '0.29', '060', '0.6', '0.31', '0.64', '061', '1', '0.5', '0', '062', '0.65', '0.34', '0.16', '063', '0', '0', '0', '064', '0.89', '0.1', '0.11', '065', '0.22', '0.49', '0.72', '066', '0.3', '0.69', '0.29', '067', '0.6', '0.31', '0.64', '068', '1', '0.5', '0', '069', '0.65', '0.34', '0.16', '070', '0', '0', '0', '071', '0.89', '0.1', '0.11', '072', '0.22', '0.49', '0.72', '073', '0.3', '0.69', '0.29', '074', '0.6', '0.31', '0.64', '075', '1', '0.5', '0', '076', '0.65', '0.34', '0.16', '077', '0', '0', '0', '078', '0.89', '0.1', '0.11', '079', '0.22', '0.49', '0.72', '080', '0.3', '0.69', '0.29', '081', '0.6', '0.31', '0.64', '082', '1', '0.5', '0', '083', '0.65', '0.34', '0.16', '084', '0', '0', '0', '085', '0.89', '0.1', '0.11', '086', '0.22', '0.49', '0.72', '087', '0.3', '0.69', '0.29', '088', '0.6', '0.31', '0.64', '089', '1', '0.5', '0', '090', '0.65', '0.34', '0.16', '091', '0', '0', '0', '092', '0.89', '0.1', '0.11', '093', '0.22', '0.49', '0.72', '094', '0.3', '0.69', '0.29', '095', '0.6', '0.31', '0.64', '096', '1', '0.5', '0', '097', '0.65', '0.34', '0.16', '098', '0', '0', '0', '099', '0.89', '0.1', '0.11', '100', '0.22', '0.49', '0.72', '101', '0.3', '0.69', '0.29', '102', '0.6', '0.31', '0.64', '103', '1', '0.5', '0', '104', '0.65', '0.34', '0.16', '105', '0', '0', '0', '106', '0.89', '0.1', '0.11', '107', '0.22', '0.49', '0.72', '108', '0.3', '0.69', '0.29', '109', '0.6', '0.31', '0.64', '110', '1', '0.5', '0', '111', '0.65', '0.34', '0.16', '112', '0', '0', '0', '113', '0.89', '0.1', '0.11', '114', '0.22', '0.49', '0.72', '115', '0.3', '0.69', '0.29', '116', '0.6', '0.31', '0.64', '117', '1', '0.5', '0', '118', '0.65', '0.34', '0.16', '119', '0', '0', '0', '120', '0.89', '0.1', '0.11', '121', '0.22', '0.49', '0.72', '122', '0.3', '0.69', '0.29', '123', '0.6', '0.31', '0.64', '124', '1', '0.5', '0', '125', '0.65', '0.34', '0.16', '126', '0', '0', '0', '127', '0.89', '0.1', '0.11', '128', '0.22', '0.49', '0.72', '129', '0.3', '0.69', '0.29', '130', '0.6', '0.31', '0.64', '131', '1', '0.5', '0', '132', '0.65', '0.34', '0.16', '133', '0', '0', '0', '134', '0.89', '0.1', '0.11', '135', '0.22', '0.49', '0.72', '136', '0.3', '0.69', '0.29', '137', '0.6', '0.31', '0.64', '138', '1', '0.5', '0', '139', '0.65', '0.34', '0.16', '140', '0', '0', '0', '141', '0.89', '0.1', '0.11', '142', '0.22', '0.49', '0.72', '143', '0.3', '0.69', '0.29', '144', '0.6', '0.31', '0.64', '145', '1', '0.5', '0', '146', '0.65', '0.34', '0.16', '147', '0', '0', '0', '148', '0.89', '0.1', '0.11', '149', '0.22', '0.49', '0.72', '150', '0.3', '0.69', '0.29', '151', '0.6', '0.31', '0.64', '152', '1', '0.5', '0', '153', '0.65', '0.34', '0.16', '154', '0', '0', '0', '155', '0.89', '0.1', '0.11', '156', '0.22', '0.49', '0.72', '157', '0.3', '0.69', '0.29', '158', '0.6', '0.31', '0.64', '159', '1', '0.5', '0', '160', '0.65', '0.34', '0.16', '161', '0', '0', '0', '162', '0.89', '0.1', '0.11', '163', '0.22', '0.49', '0.72', '164', '0.3', '0.69', '0.29', '165', '0.6', '0.31', '0.64', '166', '1', '0.5', '0', '167', '0.65', '0.34', '0.16', '168', '0', '0', '0', '169', '0.89', '0.1', '0.11', '170', '0.22', '0.49', '0.72', '171', '0.3', '0.69', '0.29', '172', '0.6', '0.31', '0.64', '173', '1', '0.5', '0', '174', '0.65', '0.34', '0.16', '175', '0', '0', '0', '176', '0.89', '0.1', '0.11', '177', '0.22', '0.49', '0.72', '178', '0.3', '0.69', '0.29', '179', '0.6', '0.31', '0.64', '180', '1', '0.5', '0', '181', '0.65', '0.34', '0.16', '182', '0', '0', '0', '183', '0.89', '0.1', '0.11', '184', '0.22', '0.49', '0.72', '185', '0.3', '0.69', '0.29', '186', '0.6', '0.31', '0.64', '187', '1', '0.5', '0', '188', '0.65', '0.34', '0.16', '189', '0', '0', '0', '190', '0.89', '0.1', '0.11', '191', '0.22', '0.49', '0.72', '192', '0.3', '0.69', '0.29', '193', '0.6', '0.31', '0.64', '194', '1', '0.5', '0', '195', '0.65', '0.34', '0.16', '196', '0', '0', '0', '197', '0.89', '0.1', '0.11', '198', '0.22', '0.49', '0.72', '199', '0.3', '0.69', '0.29', '200', '0.6', '0.31', '0.64', '201', '1', '0.5', '0', '202', '0.65', '0.34', '0.16', '203', '0', '0', '0', '204', '0.89', '0.1', '0.11', '205', '0.22', '0.49', '0.72', '206', '0.3', '0.69', '0.29', '207', '0.6', '0.31', '0.64', '208', '1', '0.5', '0', '209', '0.65', '0.34', '0.16', '210', '0', '0', '0', '211', '0.89', '0.1', '0.11', '212', '0.22', '0.49', '0.72', '213', '0.3', '0.69', '0.29', '214', '0.6', '0.31', '0.64', '215', '1', '0.5', '0', '216', '0.65', '0.34', '0.16', '217', '0', '0', '0', '218', '0.89', '0.1', '0.11', '219', '0.22', '0.49', '0.72', '220', '0.3', '0.69', '0.29', '221', '0.6', '0.31', '0.64', '222', '1', '0.5', '0', '223', '0.65', '0.34', '0.16', '224', '0', '0', '0', '225', '0.89', '0.1', '0.11', '226', '0.22', '0.49', '0.72', '227', '0.3', '0.69', '0.29', '228', '0.6', '0.31', '0.64', '229', '1', '0.5', '0', '230', '0.65', '0.34', '0.16', '231', '0', '0', '0', '232', '0.89', '0.1', '0.11', '233', '0.22', '0.49', '0.72', '234', '0.3', '0.69', '0.29', '235', '0.6', '0.31', '0.64', '236', '1', '0.5', '0', '237', '0.65', '0.34', '0.16', '238', '0', '0', '0', '239', '0.89', '0.1', '0.11', '240', '0.22', '0.49', '0.72', '241', '0.3', '0.69', '0.29', '242', '0.6', '0.31', '0.64', '243', '1', '0.5', '0', '244', '0.65', '0.34', '0.16', '245', '0', '0', '0', '246', '0.89', '0.1', '0.11', '247', '0.22', '0.49', '0.72', '248', '0.3', '0.69', '0.29', '249', '0.6', '0.31', '0.64', '250', '1', '0.5', '0', '251', '0.65', '0.34', '0.16', '252', '0', '0', '0', '253', '0.89', '0.1', '0.11', '254', '0.22', '0.49', '0.72', '255', '0.3', '0.69', '0.29', '256', '0.6', '0.31', '0.64', '257', '1', '0.5', '0', '258', '0.65', '0.34', '0.16', '259', '0', '0', '0', '260', '0.89', '0.1', '0.11', '261', '0.22', '0.49', '0.72', '262', '0.3', '0.69', '0.29', '263', '0.6', '0.31', '0.64', '264', '1', '0.5', '0', '265', '0.65', '0.34', '0.16', '266', '0', '0', '0', '267', '0.89', '0.1', '0.11', '268', '0.22', '0.49', '0.72', '269', '0.3', '0.69', '0.29', '270', '0.6', '0.31', '0.64', '271', '1', '0.5', '0', '272', '0.65', '0.34', '0.16', '273', '0', '0', '0', '274', '0.89', '0.1', '0.11', '275', '0.22', '0.49', '0.72', '276', '0.3', '0.69', '0.29', '277', '0.6', '0.31', '0.64', '278', '1', '0.5', '0', '279', '0.65', '0.34', '0.16', '280', '0', '0', '0', '281', '0.89', '0.1', '0.11', '282', '0.22', '0.49', '0.72', '283', '0.3', '0.69', '0.29', '284', '0.6', '0.31', '0.64', '285', '1', '0.5', '0', '286', '0.65', '0.34', '0.16', '287', '0', '0', '0', '288', '0.89', '0.1', '0.11', '289', '0.22', '0.49', '0.72', '290', '0.3', '0.69', '0.29', '291', '0.6', '0.31', '0.64', '292', '1', '0.5', '0', '293', '0.65', '0.34', '0.16', '294', '0', '0', '0', '295', '0.89', '0.1', '0.11', '296', '0.22', '0.49', '0.72', '297', '0.3', '0.69', '0.29', '298', '0.6', '0.31', '0.64', '299', '1', '0.5', '0', '300', '0.65', '0.34', '0.16', '301', '0', '0', '0', '302', '0.89', '0.1', '0.11', '303', '0.22', '0.49', '0.72', '304', '0.3', '0.69', '0.29', '305', '0.6', '0.31', '0.64', '306', '1', '0.5', '0', '307', '0.65', '0.34', '0.16', '308', '0', '0', '0', '309', '0.89', '0.1', '0.11', '310', '0.22', '0.49', '0.72', '311', '0.3', '0.69', '0.29', '312', '0.6', '0.31', '0.64', '313', '1', '0.5', '0', '314', '0.65', '0.34', '0.16', '315', '0', '0', '0', '316', '0.89', '0.1', '0.11', '317', '0.22', '0.49', '0.72', '318', '0.3', '0.69', '0.29', '319', '0.6', '0.31', '0.64', '320', '1', '0.5', '0', '321', '0.65', '0.34', '0.16', '322', '0', '0', '0', '323', '0.89', '0.1', '0.11', '324', '0.22', '0.49', '0.72', '325', '0.3', '0.69', '0.29', '326', '0.6', '0.31', '0.64', '327', '1', '0.5', '0', '328', '0.65', '0.34', '0.16', '329', '0', '0', '0', '330', '0.89', '0.1', '0.11', '331', '0.22', '0.49', '0.72', '332', '0.3', '0.69', '0.29', '333', '0.6', '0.31', '0.64', '334', '1', '0.5', '0', '335', '0.65', '0.34', '0.16', '336', '0', '0', '0', '337', '0.89', '0.1', '0.11', '338', '0.22', '0.49', '0.72', '339', '0.3', '0.69', '0.29', '340', '0.6', '0.31', '0.64', '341', '1', '0.5', '0', '342', '0.65', '0.34', '0.16', '343', '0', '0', '0', '344', '0.89', '0.1', '0.11', '345', '0.22', '0.49', '0.72', '346', '0.3', '0.69', '0.29', '347', '0.6', '0.31', '0.64', '348', '1', '0.5', '0', '349', '0.65', '0.34', '0.16', '350', '0', '0', '0', '351', '0.89', '0.1', '0.11', '352', '0.22', '0.49', '0.72', '353', '0.3', '0.69', '0.29', '354', '0.6', '0.31', '0.64', '355', '1', '0.5', '0', '356', '0.65', '0.34', '0.16', '357', '0', '0', '0', '358', '0.89', '0.1', '0.11', '359', '0.22', '0.49', '0.72', '360', '0.3', '0.69', '0.29', '361', '0.6', '0.31', '0.64', '362', '1', '0.5', '0', '363', '0.65', '0.34', '0.16', '364', '0', '0', '0', '365', '0.89', '0.1', '0.11', '366', '0.22', '0.49', '0.72', '367', '0.3', '0.69', '0.29', '368', '0.6', '0.31', '0.64', '369', '1', '0.5', '0', '370', '0.65', '0.34', '0.16', '371', '0', '0', '0', '372', '0.89', '0.1', '0.11', '373', '0.22', '0.49', '0.72', '374', '0.3', '0.69', '0.29', '375', '0.6', '0.31', '0.64', '376', '1', '0.5', '0', '377', '0.65', '0.34', '0.16', '378', '0', '0', '0', '379_median', '0.00', '0.00', '0.00', '380', '0.89', '0.1', '0.11', '381', '0.22', '0.49', '0.72', '382', '0.3', '0.69', '0.29', '383', '0.6', '0.31', '0.64', '384', '1', '0.5', '0', '385', '0.65', '0.34', '0.16', '386', '0', '0', '0', '387', '0.89', '0.1', '0.11', '388', '0.22', '0.49', '0.72', '389', '0.3', '0.69', '0.29', '390', '0.6', '0.31', '0.64', '391', '1', '0.5', '0', '392', '0.65', '0.34', '0.16', '393', '0', '0', '0', '394', '0.89', '0.1', '0.11', '395', '0.22', '0.49', '0.72', '396', '0.3', '0.69', '0.29', '397', '0.6', '0.31', '0.64', '398', '1', '0.5', '0', '399', '0.65', '0.34', '0.16', 'Q3Points95', '0.50', '0.00', '0.00', 'QMedPoints', '0.75', '0.00', '0.00']
extractBagPlots1Display.SeriesVisibility = ['029_outlier', '379_median', 'Q3Points95', 'QMedPoints']

# update the view to ensure updated data information
functionalBagChartView1.Update()

# split cell
layout1.SplitVertical(0, 0.5)

# Create a new 'Parallel Coordinates View'
parallelCoordinatesView1 = CreateView('ParallelCoordinatesChartView')

# show data in view
campbell_1d_input_parameterscsvDisplay = Show(campbell_1d_input_parameterscsv, parallelCoordinatesView1)

# trace defaults for the display properties.
campbell_1d_input_parameterscsvDisplay.CompositeDataSetIndex = 0
campbell_1d_input_parameterscsvDisplay.FieldAssociation = 'Row Data'
campbell_1d_input_parameterscsvDisplay.SeriesVisibility = ['', 'V1', 'V2', 'V3', 'V4']

# Properties modified on campbell_1d_input_parameterscsvDisplay
campbell_1d_input_parameterscsvDisplay.SeriesVisibility = ['V1', 'V2', 'V3', 'V4']

#### uncomment the following to render all views
RenderAllViews()
