# Fonction de Campbell et al., RESS, 91:1468-1471, 2006
d1=4 # number of parameters
campbell1D <- function(X,theta){
                return(10+X[,1]*exp(-(theta-10*X[,2])^2/(K1*X[,1]^2+X[,3]^2))
               +(X[,2]+X[,4])*exp(K2*X[,1]*(theta)))
}

N1=400       # number of simulations
theta=-90:90 # 1st spatial coordinate

# Law of X (uniforme)
min=-1
max=5
nominal=(max+min)/2

# constant values
K1=60
K2=0.002

X1 = NULL ; y1 = NULL
Xnom=matrix(nominal,nr=1,nc=d1)
ynom=campbell1D(Xnom,theta)
x11()
plot(ynom,ylim=c(8,30),type="l",col="red")

for (i in 1:N1){
  X=matrix(runif(d1,min=min,max=max),nr=1,nc=d1)
  X1 <- rbind(X1,X)
  y=campbell1D(X,theta)
  y1 <- rbind(y1,y)
  lines(y)

}

write.csv(X1, file = "campbell_1d_input_parameters.csv")
write.csv(y1, file = "campbell_1d_output_curves.csv")



 
