
# Setting up a graphics environment on an EC2 instance

## Introduction

This document covers setting up a graphics environment suitable for doing hardware rendering on an Amazon EC2 instance.  So far, all graphics instances we have worked with come with NVidia GRID gpus, and this document focuses on steps to prepare for using those graphics cards.  We have worked with several flavors of AMI at this point, and each one seems to differ slightly in how the graphics environment is prepared.  In this document, we will attempt to add a new section each time we encounter a new type of AMI with different setup instructions.

Something common to all types of instances is how you can verify that your graphics card is set properly for ParaViewWeb hardware rendering.  Basically, if you can run an X server, and use it to run glxinfo, and see acceptable output, you're ready to go:

    $ sudo X :0 &
    $ export DISPLAY=:0.0
    $ glxinfo

Scroll up through glxinfo output and look for lines containing OpenGL version info, it should mention NVidia.  For example:

    OpenGL vendor string: NVIDIA Corporation
    OpenGL renderer string: GRID K520/PCIe/SSE2
    OpenGL version string: 4.4.0 NVIDIA 340.32
    OpenGL shading language version string: 4.40 NVIDIA via Cg compiler

If you see your graphics card mentioned on these lines, you were successful and ParaView will be able to do hardware rendering.

All of the following sections assume you have successfully launched and started a new instance, and also been able to gain ssh access to the instance.

## Amazon Linux AMI

This was the first AMI we had any experience with, and things may have changed slightly in the last year or so.  But following are instructions for getting your graphics environment set up on the Amazon Linus AMI, which seemed to be based on RedHat Enterprise Linux and was very similar to a CentOS type system.

To get started, it is may be a good idea to install the updates. To do so, follow the system instructions:

    $ sudo yum update

Next, you can install some required packages on the instance.  The patch package is required for patching the Apache httpd source, pcre-devel is required by the Apache compilation phase, mesa-libGLU is required to perform ParaView rendering, and the xorg packages are required for a proper X server environment.

    $ sudo yum install mesa-libGLU.x86_64
    $ sudo yum install xorg*

After running the above package installations, you should run nvidia-config, as shown below, so as to generate a correctly formatted X configuration file.

    $ sudo nvidia-config

After running the above nvidia-config command, there will be a new file generated: /etc/X11/xorg.conf.  This file needs to be edited to include the BusID in the "Device" section, as well as a couple of items in the "Screen" section (an "Option" line within "Screen", as well as a "Virtual" line within "Screen"->"Subsection").  The entire contents of the file (from a recent installation) are included below for reference.

    # nvidia-xconfig: X configuration file generated by nvidia-xconfig
    # nvidia-xconfig:  version 319.60  (buildmeister@swio-display-x64-rhel04-15)  Wed Sep 25 15:17:31 PDT 2013

    Section "ServerLayout"
        Identifier     "Layout0"
        Screen      0  "Screen0"
        InputDevice    "Keyboard0" "CoreKeyboard"
        InputDevice    "Mouse0" "CorePointer"
    EndSection

    Section "Files"
    EndSection

    Section "InputDevice"
        # generated from default
        Identifier     "Mouse0"
        Driver         "mouse"
        Option         "Protocol" "auto"
        Option         "Device" "/dev/psaux"
        Option         "Emulate3Buttons" "no"
        Option         "ZAxisMapping" "4 5"
    EndSection

    Section "InputDevice"
        # generated from data in "/etc/sysconfig/keyboard"
        Identifier     "Keyboard0"
        Driver         "kbd"
        Option         "XkbLayout" "us"
        Option         "XkbModel" "pc105"
    EndSection

    Section "Monitor"
        Identifier     "Monitor0"
        VendorName     "Unknown"
        ModelName      "Unknown"
        HorizSync       28.0 - 33.0
        VertRefresh     43.0 - 72.0
        Option         "DPMS"
    EndSection

    Section "Device"
        Identifier     "Device0"
        Driver         "nvidia"
        VendorName     "NVIDIA Corporation"
        BusID           "00:03:0"
    EndSection

    Section "Screen"
        Identifier     "Screen0"
        Device         "Device0"
        Monitor        "Monitor0"
        DefaultDepth    24
        Option         "UseDisplayDevice" "None"
        SubSection     "Display"
            Virtual     1920 1080
            Depth       24
        EndSubSection
    EndSection

Your choice for the "Virtual" screen resolution, located near the bottom of the file, will become the maximum size image that ParaView can render. You may want to increase the resolution accordingly.  Additionally, the correct bus id to use can be found in the output of:

    $ nvidia-smi

## Ubuntu 13.04 (starcluster)

ami-80bedfb0 us-west-2 starcluster-base-ubuntu-13.04-x86_64-hvm (HVM-EBS)

The first thing to do on this system (which is now end-of-life) is to allow to get packages from old-releases package archive:

    $ sudo cp /etc/apt/sources.list /etc/apt/sources.list.BACKUP

In the file /etc/apt/sources.list, change all instances of either of the following urls:

    us-west-2.ec2.archive.ubuntu.com
    security.ubuntu.com

to

    old-releases.ubuntu.com

Now update and reboot:

    $ sudo apt-get update
    $ sudo apt-get dist-upgrade
    reboot

Now you can install a few needed packages:

    $ sudo apt-get install libglu1-mesa libglu1-mesa-dev mesa-utils xorg

Now you need to go download the latest NVidia drivers for your graphics card.  There are several ways to find out what kind of graphics card you have, one is to type:

    $ lspci -v

And then look for the entry that starts with "VGA compatible controller" and mentions NVidia.  Ours was an NVidia GRID K520, so go to the NVidia website and use their search tool to find the appropriate driver:

 - go to their [website](http://www.nvidia.com/Download/index.aspx?lang=en-us)
 - Product Type: "GRID"
 - Product Series: "GRID Series"
 - Product: "GRID K520"
 - Operating System: "Linux 64-bit"
 - Language: "English (US)"

Now click "Search", then "Download", then right-click the "Agree & Download" button and copy the link address.  Now you can wget the driver install script directly on your instance, for example:

    $ wget http://us.download.nvidia.com/XFree86/Linux-x86_64/340.32/NVIDIA-Linux-x86_64-340.32.run
    $ chmod 755 NVIDIA-Linux-x86_64-340.32.run

Now run the script which will compile and install the driver:

    $ sudo ./NVIDIA-Linux-x86_64-340.32.run

The script is interactive, so you have to choose some options as you go along:

 - "Accept" the license
 - "Continue installation" when asked if you want to uninstall the current driver
 - "Yes" install 32-bit compatibility libraries (don't know if this is needed, but it seems not to hurt)
 - "Ok" to message about libvdpau and libvdpau_trace...
 - "Yes" to run nvidia-xconfig and generate an xorg.conf file
 - "Ok" to message about installation having completed

Now might be a good time to reboot again, since we just installed new NVidia driver.  Once you're back in, edit the xorg.conf file:

    $ sudo vi /etc/X11/xorg.conf

Make the edits detailed on this page, above, in the section titled "Amazon Linux AMI".  To summarize, there are three changes needed:

 - add the "BusId" line to "Device" section
 - add the "Option" line to "Screen" section
 - add the "Virtual" line to "SubSection" section of "Screen" section

If you want, double-check that BusId by running the following command and looking for the bus id in the table:

    $ nvidia-smi

If you did everything right and got a little lucky, you should be able to fire up an XServer and test that it's actually working now.  See above for details.

## Ubuntu 14.04 LTS

These notes are specific for EC2 instances that use Ubuntu 14.04 LTS and were tested on the following instance type:

    ubuntu-trusty-14.04-amd64-server-20140607.1 (ami-864d84ee)

In order to add the latest nvidia drivers, you must first add a package repo that provides these packages.  This can be done as follows:

    $ sudo add-apt-repository ppa:xorg-edgers/ppa -y
    $ sudo apt-get update
    $ sudo apt-get dist-upgrade

At the end of the `dist-upgrade` process you will be presented with some Grub options to select, here is how you should choose those:

- keep the local version currently installed
- Select /dev/xvda

Now you can install the needed packages.  Below we have chosen the `nvidia-343` driver version, but as newer versions become available, those should probably be used instead.  To find out what versions are available, try:

    $ sudo apt-cache search nvidia

When you have identified an nvidia driver package, then run:

    $ sudo apt-get install libglu1-mesa libglu1-mesa-dev mesa-utils xorg linux-image-extra-virtual nvidia-343

The following command will set up your `xorg.conf` file properly so that no editing is needed:

    $ sudo nvidia-xconfig --busid="0:3:0" --allow-empty-initial-configuration --virtual=1920x1080 --use-display-device=0

The next command will keep the desktop manager from starting up on its own:

    $ echo  "manual" | sudo tee -a /etc/init/lightdm.override

Now you can reboot, and you should be good to go:

    $ sudo reboot
