import os
import json
import copy

from cinema_python.database import file_store, vti_store


def loadAll(filename):
    ''' Returns a list of loaded Cinema store instances. If the filename
    argument points to a top-level file, it loads all the referenced databases.
    If filename points to a single database it loads only that database and
    returns a single-element list.  Warning: currently not supporting SFS.

    * top-level json file:
    Expects a top-level json format as generated by
    coprocessing.py::WriteImages.
    '''
    file = open(filename, mode="rb")
    info_json = json.load(file)

    # Assume the file is an actual database so just load it
    if not ("runs" in info_json):
        cs = file_store.FileStore(filename)
        cs.load()
        return [cs], None

    # a list of keys that should be linked between views
    linked_keys = {}

    # Assume it is a top-level file (load them all)
    cstores = []
    runsItem = info_json["runs"]
    for db in runsItem:
        # TODO adjust the path with the file name at generation time
        store_path = (os.path.dirname(filename) + "/" +
                      db["path"] + "/info.json")
        cs = file_store.FileStore(store_path)
        cs.load()

        # TODO: make this a static method of ParameterLinks
        # decide what parameters are the same for all stores
        if len(cstores) == 0:
            # first store adds all of its pameters to linked_leys
            linked_keys.update(cs.parameter_list)
        else:
            # subsequent stores remove keys keys in linked_keys that are not in
            # cs or that are but have different values
            vcopy = copy.copy(linked_keys)
            for k, v in vcopy.iteritems():
                if k not in cs.parameter_list:
                    del linked_keys[k]
                else:
                    if linked_keys[k]["values"] != \
                            cs.parameter_list[k]["values"]:
                        del linked_keys[k]

        # Make sure the first element in the list is placed first (master db)
        if db == runsItem[0]:
            cstores.insert(0, cs)
        else:
            cstores.append(cs)

    return cstores, linked_keys


def legacy_loadSingle(filename):
    ''' Legacy database loader supporting SFS. '''
    # try to open up a store
    with open(filename, mode="rb") as file:
        info_json = json.load(file)

    try:
        if info_json["metadata"]["store_type"] == "SFS":
            cs = vti_store.VTIFileStore(filename)
        else:
            raise TypeError

    except(TypeError, KeyError):
        cs = file_store.FileStore(filename)

    cs.load()
    return [cs]


def myformat_loadAll(filename):
    ''' Returns a list of loaded Cinema store instances. If the filename
    argument points to a top-level file, it loads all the referenced databases.
    If filename points to a single database it loads only that database and
    returns a single-element list.  Warning: currently not supporting SFS.'''

    file = open(filename, mode="rb")
    info_json = json.load(file)

    # This is an actual database so just load it
    if ('metadata' in info_json):
        cs = file_store.FileStore(filename)
        cs.load()
        return [cs]

    # Assume it being a syncrhonization file (load them all)
    databases = []
    for key, value in info_json.iteritems():
        store_path = os.path.dirname(filename) + value["relative_path"]
        cs = file_store.FileStore(store_path)
        cs.load()
        if key == "0":
            # Make sure this is the first element in the list (master db)
            databases.insert(0, cs)
        else:
            databases.append(cs)

    return databases
