echo "CMAKE $CMAKE"
echo "COMP $COMP"
echo "RENDER $RENDER"
echo "BACKEND $BACKEND"
echo "BASE $BASE_DIR"
echo "BUILD $BUILD_DIR"
echo "IFNAME $IFNAME"
echo "OFNAME $OFNAME"

cd ${BUILD_DIR}

EXTENSION="_gl1"
BE_CACHE="OpenGL"
if [ ${BACKEND} = "GL2" ]
  then
    EXTENSION="_gl2"
    BE_CACHE="OpenGL2"
fi
  
if [ -a ${IFNAME} ]
  then
     echo "========== RESTORE =========="
     date
     echo "=========================="
     cd ..
     rm -rf demarled
     tar -xz -f ${IFNAME}
     cd demarled
     pwd
     ls -alrt
     cd ${BUILD_DIR}
else
  echo "========== NO BACKUP TO RESTORE =========="
     date
     pwd
     ls -alrt
     echo "=========================="

     echo "========== CONFIG =========="
     date
     echo "=========================="
     cd ${BUILD_DIR}
     $CMAKE \
       -C${BASE_DIR}/ParaViewSuperbuild/CMake/Sites/ORNL-Titan-${RENDER}.cmake \
       -DPARAVIEW_RENDERING_BACKEND=${BE_CACHE} \
       -DCMAKE_INSTALL_PREFIX=${BASE_DIR}/install/titan_gnu_mpich_${RENDER}${EXTENSION} \
       ${BASE_DIR}/ParaViewSuperbuild
     pwd
     ls -alrt
fi

echo "========== MAKE =========="
date
echo "=========================="
/usr/bin/timeout $TLIMIT make -j 4 install
pwd
ls -alrt

echo "========== SAVE =========="
date
echo "=========================="

sleep 30
cd ..
pwd
ls -alrt
tar -cz -f ${OFNAME} demarled

echo "========== CLEANUP =========="
date
echo "=========================="
rm -rf ${BUILD_DIR}
pwd
ls -alrt

echo "=========================="
echo "HAVE A NICE DAY!"
date
echo "=========================="
