echo "CMAKE $CMAKE"
echo "COMP $COMP"
echo "RENDER $RENDER"
echo "BASE $BASE_DIR"
echo "BUILD $BUILD_DIR"
echo "IFNAME $IFNAME"
echo "OFNAME $OFNAME"

cd ${BUILD_DIR}
if [ -a ${IFNAME} ]
  then
     echo "========== RESTORE =========="
     date
     echo "=========================="
     cd ..
     rm -rf demarled
     tar -xz -f ${IFNAME}
     cd demarled
     pwd
     ls -alrt
     cd ${BUILD_DIR}
else
  echo "========== NO BACKUP TO RESTORE =========="
     date
     pwd
     ls -alrt
     echo "=========================="

     echo "========== CONFIG =========="
     date
     echo "=========================="
     cd ${BUILD_DIR}
     $CMAKE \
       -C${BASE_DIR}/source/ParaViewSuperbuild/CMake/Sites/ORNL-Titan-${RENDER}.cmake \
       -DCMAKE_INSTALL_PREFIX=${BASE_DIR}/install/titan_gnu_mpich_${RENDER} \
       ${BASE_DIR}/source/ParaViewSuperbuild
     pwd
     ls -alrt
fi

echo "========== MAKE =========="
date
echo "=========================="
/usr/bin/timeout $TLIMIT make install
pwd
ls -alrt

echo "========== SAVE =========="
date
echo "=========================="

sleep 30
cd ..
pwd
ls -alrt
tar -cz -f ${OFNAME} demarled

echo "========== CLEANUP =========="
date
echo "=========================="
rm -rf ${BUILD_DIR}
pwd
ls -alrt

echo "=========================="
echo "HAVE A NICE DAY!"
date
echo "=========================="
