/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spring;

public class SpringNode {
    public float[] position;
    public float[] normal;
    public float[] dir;
    public int offset;
    public SpringNode[] connections;
    public float[] naturalLengths;
    public int numConnections;
    int nNormal;
    public boolean locked;

    SpringNode(float[] fArray, float[] fArray2, int n) {
        this.position = fArray;
        this.normal = fArray2;
        this.offset = n;
        this.dir = new float[3];
        this.locked = false;
        this.nNormal = 0;
        this.connections = new SpringNode[4];
        this.naturalLengths = new float[4];
        this.numConnections = 0;
    }

    public void addSpring(SpringNode springNode) {
        if (this.numConnections == this.connections.length) {
            int n = this.numConnections + 4;
            SpringNode[] springNodeArray = new SpringNode[n];
            float[] fArray = new float[n];
            System.arraycopy(this.connections, 0, springNodeArray, 0, this.numConnections);
            System.arraycopy(this.naturalLengths, 0, fArray, 0, this.numConnections);
            this.connections = springNodeArray;
            this.naturalLengths = fArray;
        }
        float f = this.position[this.offset] - springNode.position[springNode.offset];
        float f2 = this.position[this.offset + 1] - springNode.position[springNode.offset + 1];
        float f3 = this.position[this.offset + 2] - springNode.position[springNode.offset + 2];
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.connections[this.numConnections] = springNode;
        this.naturalLengths[this.numConnections] = f4;
        ++this.numConnections;
    }

    public void resetNaturalLengths() {
        for (int i = 0; i < this.numConnections; ++i) {
            float f;
            SpringNode springNode = this.connections[i];
            float f2 = this.position[this.offset] - springNode.position[springNode.offset];
            float f3 = this.position[this.offset + 1] - springNode.position[springNode.offset + 1];
            float f4 = this.position[this.offset + 2] - springNode.position[springNode.offset + 2];
            this.naturalLengths[i] = f = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        }
        this.dir[0] = 0.0f;
        this.dir[1] = 0.0f;
        this.dir[2] = 0.0f;
    }
}

