/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointAMotor;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.ode.OdeConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseMotorJoint
extends BaseJointNode {
    protected static final int FIELD_AUTO_CALC = 4;
    protected static final int FIELD_MOTOR1_AXIS = 5;
    protected static final int FIELD_MOTOR2_AXIS = 6;
    protected static final int FIELD_MOTOR3_AXIS = 7;
    protected static final int FIELD_AXIS1_ANGLE = 8;
    protected static final int FIELD_AXIS2_ANGLE = 9;
    protected static final int FIELD_AXIS3_ANGLE = 10;
    protected static final int FIELD_STOP1_BOUNCE = 11;
    protected static final int FIELD_STOP2_BOUNCE = 12;
    protected static final int FIELD_STOP3_BOUNCE = 13;
    protected static final int FIELD_AXIS1_TORQUE = 14;
    protected static final int FIELD_AXIS2_TORQUE = 15;
    protected static final int FIELD_AXIS3_TORQUE = 16;
    protected static final int FIELD_MOTOR1_ANGLE = 17;
    protected static final int FIELD_MOTOR2_ANGLE = 18;
    protected static final int FIELD_MOTOR3_ANGLE = 19;
    protected static final int FIELD_MOTOR1_ANGLE_RATE = 20;
    protected static final int FIELD_MOTOR2_ANGLE_RATE = 21;
    protected static final int FIELD_MOTOR3_ANGLE_RATE = 22;
    protected static final int FIELD_STOP1_ERROR_CORRECTION = 23;
    protected static final int FIELD_STOP2_ERROR_CORRECTION = 24;
    protected static final int FIELD_STOP3_ERROR_CORRECTION = 25;
    protected static final int FIELD_ENABLED_AXES = 26;
    protected static final int LAST_MOTOR_INDEX = 26;
    private static final int NUM_FIELDS = 27;
    protected static final String AXIS1_ANGLE_MSG = "The axis1Angle value is out of the required range [-pi,pi]: ";
    protected static final String AXIS2_ANGLE_MSG = "The axis2Angle value is out of the required range [-pi,pi]: ";
    protected static final String AXIS3_ANGLE_MSG = "The axis3Angle value is out of the required range [-pi,pi]: ";
    protected static final String AXIS1_TORQUE_MSG = "The axis1Torque value is out of the required range [-pi,pi]: ";
    protected static final String AXIS2_TORQUE_MSG = "The axis2Torque value is out of the required range [-pi,pi]: ";
    protected static final String AXIS3_TORQUE_MSG = "The axis3Torque value is out of the required range [-pi,pi]: ";
    protected static final String BOUNCE1_RANGE_MSG = "The stop1Bounce value is out of the required range [0,1]: ";
    protected static final String BOUNCE2_RANGE_MSG = "The stop2Bounce value is out of the required range [0,1]: ";
    protected static final String BOUNCE3_RANGE_MSG = "The stop3Bounce value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR1_RANGE_MSG = "The stop1ErrorCorrection value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR2_RANGE_MSG = "The stop2ErrorCorrection value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR3_RANGE_MSG = "The stop3ErrorCorrection value is out of the required range [0,1]: ";
    private static final String MA1_WRITE_MSG = "motor1Angle is outputOnly and cannot be set";
    private static final String MA2_WRITE_MSG = "motor2Angle is outputOnly and cannot be set";
    private static final String MA3_WRITE_MSG = "motor3Angle is outputOnly and cannot be set";
    private static final String MAR1_WRITE_MSG = "motor1AngleRate is outputOnly and cannot be set";
    private static final String MAR2_WRITE_MSG = "motor2AngleRate is outputOnly and cannot be set";
    private static final String MAR3_WRITE_MSG = "motor3AngleRate is outputOnly and cannot be set";
    private static final String ENABLED_RANGE_MSG = "The value of enabledAxes must be between 0 and 3.";
    private static final int[] outputFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfAutoCalc = false;
    protected int vfEnabledAxes = 1;
    protected float[] vfMotor1Axis = new float[3];
    protected float[] vfMotor2Axis = new float[3];
    protected float[] vfMotor3Axis = new float[3];
    protected float vfAxis1Angle = (float)(-Math.PI);
    protected float vfAxis2Angle = (float)(-Math.PI);
    protected float vfAxis3Angle = (float)(-Math.PI);
    protected float vfAxis1Torque = (float)Math.PI;
    protected float vfAxis2Torque = (float)Math.PI;
    protected float vfAxis3Torque = (float)Math.PI;
    protected float vfMotor1Angle;
    protected float vfMotor2Angle;
    protected float vfMotor3Angle;
    protected float vfMotor1AngleRate;
    protected float vfMotor2AngleRate;
    protected float vfMotor3AngleRate;
    protected float vfStop1Bounce = 0.0f;
    protected float vfStop2Bounce = 0.0f;
    protected float vfStop3Bounce = 0.0f;
    protected float vfStop1ErrorCorrection = 0.8f;
    protected float vfStop2ErrorCorrection = 0.8f;
    protected float vfStop3ErrorCorrection = 0.8f;
    protected JointAMotor odeJoint;

    public BaseMotorJoint() {
        super("MotorJoint");
        this.hasChanged = new boolean[27];
    }

    public BaseMotorJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("autoCalc");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAutoCalc = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("motor1Axis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMotor1Axis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMotor1Axis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfMotor1Axis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("motor2Axis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMotor2Axis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMotor2Axis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfMotor2Axis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("motor3Axis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMotor3Axis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMotor3Axis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfMotor3Axis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis1Angle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis1Angle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("axis2Angle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis2Angle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("axis3Angle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis3Angle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("axis1Torque");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis1Torque = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("axis3Torque");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis3Torque = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("axis3Torque");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis3Torque = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop1Bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop1Bounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop2Bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop2Bounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop3Bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop3Bounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop1ErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop1ErrorCorrection = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop2ErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop2ErrorCorrection = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop3ErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop3ErrorCorrection = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("enabledAxes");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabledAxes = vRMLFieldData.intValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        if (this.odeJoint == null) {
            return;
        }
        for (int i = 0; i < this.numOutputIndices; ++i) {
            int cfr_ignored_0 = this.outputIndices[i];
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointAMotor(world, jointGroup);
            Body body = null;
            Body body2 = null;
            if (this.vfBody1 != null) {
                body = this.vfBody1.getODEBody();
            }
            if (this.vfBody2 != null) {
                body2 = this.vfBody2.getODEBody();
            }
            this.odeJoint.attach(body, body2);
            this.odeJoint.setMode(this.vfAutoCalc ? OdeConstants.dAMotorEuler : OdeConstants.dAMotorUser);
            this.odeJoint.setAxis(1, 0, this.vfMotor1Axis[0], this.vfMotor1Axis[1], this.vfMotor1Axis[2]);
            this.odeJoint.setAxis(3, 0, this.vfMotor3Axis[0], this.vfMotor3Axis[1], this.vfMotor3Axis[2]);
            if (!this.vfAutoCalc) {
                this.odeJoint.setNumAxes(this.vfEnabledAxes);
                this.odeJoint.setAngle(1, this.vfAxis1Angle);
                this.odeJoint.setAngle(2, this.vfAxis2Angle);
                this.odeJoint.setAngle(3, this.vfAxis3Angle);
                this.odeJoint.setAxis(2, 0, this.vfMotor2Axis[0], this.vfMotor2Axis[1], this.vfMotor2Axis[2]);
            }
        } else {
            this.odeJoint.delete();
        }
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            this.odeJoint.attach(body, body2);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.odeJoint == null) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setMode(this.vfAutoCalc ? OdeConstants.dAMotorEuler : OdeConstants.dAMotorUser);
        this.odeJoint.setAxis(1, 0, this.vfMotor1Axis[0], this.vfMotor1Axis[1], this.vfMotor1Axis[2]);
        this.odeJoint.setAxis(3, 0, this.vfMotor3Axis[0], this.vfMotor3Axis[1], this.vfMotor3Axis[2]);
        if (!this.vfAutoCalc) {
            this.odeJoint.setNumAxes(this.vfEnabledAxes);
            this.odeJoint.setAngle(1, this.vfAxis1Angle);
            this.odeJoint.setAngle(2, this.vfAxis2Angle);
            this.odeJoint.setAngle(3, this.vfAxis3Angle);
            this.odeJoint.setAxis(2, 0, this.vfMotor2Axis[0], this.vfMotor2Axis[1], this.vfMotor2Axis[2]);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 26) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfAutoCalc;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfMotor1Axis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfMotor2Axis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfMotor3Axis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis1Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis2Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis3Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis1Torque;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 15: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis2Torque;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 16: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfAxis3Torque;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 17: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor1Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 18: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor2Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 19: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor3Angle;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 20: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor1AngleRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 21: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor2AngleRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 22: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfMotor3AngleRate;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop1Bounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop2Bounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop3Bounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 23: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop1ErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 24: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop2ErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 25: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop3ErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 26: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfEnabledAxes;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAutoCalc);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfMotor1Axis, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfMotor2Axis, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfMotor3Axis, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfAxis1Angle);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfAxis2Angle);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfAxis3Angle);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfAxis1Torque);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfAxis2Torque);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfAxis3Torque);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfMotor1Angle);
                    break;
                }
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfMotor2Angle);
                    break;
                }
                case 19: {
                    vRMLNodeType.setValue(n2, this.vfMotor3Angle);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfMotor1AngleRate);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfMotor2AngleRate);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfMotor3AngleRate);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfStop1Bounce);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfStop2Bounce);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfStop3Bounce);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfStop1ErrorCorrection);
                    break;
                }
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfStop2ErrorCorrection);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfStop3ErrorCorrection);
                    break;
                }
                case 26: {
                    vRMLNodeType.setValue(n2, this.vfEnabledAxes);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Single1AxisJoint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Single1AxisJoint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: autoCalc");
                }
                this.vfAutoCalc = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 26: {
                this.setEnabledAxes(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 8: {
                this.set1AxisAngle(f);
                break;
            }
            case 9: {
                this.set2AxisAngle(f);
                break;
            }
            case 10: {
                this.set3AxisAngle(f);
                break;
            }
            case 14: {
                this.setMotor1Torque(f);
                break;
            }
            case 15: {
                this.setMotor2Torque(f);
                break;
            }
            case 16: {
                this.setMotor3Torque(f);
                break;
            }
            case 11: {
                this.setStop1Bounce(f);
                break;
            }
            case 12: {
                this.setStop2Bounce(f);
                break;
            }
            case 13: {
                this.setStop3Bounce(f);
                break;
            }
            case 23: {
                this.setStop1ErrorCorrection(f);
                break;
            }
            case 24: {
                this.setStop2ErrorCorrection(f);
                break;
            }
            case 25: {
                this.setStop3ErrorCorrection(f);
                break;
            }
            case 17: {
                throw new InvalidFieldAccessException(MA1_WRITE_MSG);
            }
            case 18: {
                throw new InvalidFieldAccessException(MA2_WRITE_MSG);
            }
            case 19: {
                throw new InvalidFieldAccessException(MA3_WRITE_MSG);
            }
            case 20: {
                throw new InvalidFieldAccessException(MAR1_WRITE_MSG);
            }
            case 21: {
                throw new InvalidFieldAccessException(MAR2_WRITE_MSG);
            }
            case 22: {
                throw new InvalidFieldAccessException(MAR3_WRITE_MSG);
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 5: {
                this.setMotor1Axis(fArray);
                break;
            }
            case 6: {
                this.setMotor2Axis(fArray);
                break;
            }
            case 7: {
                this.setMotor3Axis(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void set1AxisAngle(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS1_ANGLE_MSG + f);
        }
        this.vfAxis1Angle = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamLoStop, f);
            }
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void set2AxisAngle(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS2_ANGLE_MSG + f);
        }
        this.vfAxis2Angle = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamLoStop2, f);
            }
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void set3AxisAngle(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS3_ANGLE_MSG + f);
        }
        this.vfAxis3Angle = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamLoStop3, f);
            }
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setMotor1Torque(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS1_ANGLE_MSG + f);
        }
        this.vfAxis1Torque = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamHiStop, f);
            }
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setMotor2Torque(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS2_ANGLE_MSG + f);
        }
        this.vfAxis2Torque = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamHiStop2, f);
            }
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void setMotor3Torque(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(AXIS3_ANGLE_MSG + f);
        }
        this.vfAxis3Torque = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamHiStop3, f);
            }
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    private void setMotor1Axis(float[] fArray) {
        this.vfMotor1Axis[0] = fArray[0];
        this.vfMotor1Axis[1] = fArray[1];
        this.vfMotor1Axis[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis(1, 0, fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setMotor2Axis(float[] fArray) {
        this.vfMotor2Axis[0] = fArray[0];
        this.vfMotor2Axis[1] = fArray[1];
        this.vfMotor2Axis[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis(2, 0, fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setMotor3Axis(float[] fArray) {
        this.vfMotor3Axis[0] = fArray[0];
        this.vfMotor3Axis[1] = fArray[1];
        this.vfMotor3Axis[3] = fArray[3];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis(3, 0, fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setStop1Bounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE1_RANGE_MSG + f);
        }
        this.vfStop1Bounce = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamBounce, f);
            }
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    private void setStop2Bounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE2_RANGE_MSG + f);
        }
        this.vfStop2Bounce = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamBounce2, f);
            }
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    private void setStop3Bounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE3_RANGE_MSG + f);
        }
        this.vfStop3Bounce = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamBounce3, f);
            }
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void setStop1ErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR1_RANGE_MSG + f);
        }
        this.vfStop1ErrorCorrection = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamStopERP, f);
            }
            this.hasChanged[23] = true;
            this.fireFieldChanged(23);
        }
    }

    private void setStop2ErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR2_RANGE_MSG + f);
        }
        this.vfStop2ErrorCorrection = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamStopERP2, f);
            }
            this.hasChanged[24] = true;
            this.fireFieldChanged(24);
        }
    }

    private void setStop3ErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR3_RANGE_MSG + f);
        }
        this.vfStop3ErrorCorrection = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setParam(OdeConstants.dParamStopERP3, f);
            }
            this.hasChanged[25] = true;
            this.fireFieldChanged(25);
        }
    }

    private void setEnabledAxes(int n) throws InvalidFieldValueException {
        if (n < 0 || n > 3) {
            throw new InvalidFieldValueException(ENABLED_RANGE_MSG + n);
        }
        this.vfEnabledAxes = n;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setNumAxes(n);
            }
            this.hasChanged[26] = true;
            this.fireFieldChanged(26);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{17, 18, 19, 20, 21, 22};
        fieldDecl = new VRMLFieldDeclaration[27];
        fieldMap = new HashMap(81);
        BaseMotorJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMotorJoint.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFBoolean", "autoCalc");
        BaseMotorJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseMotorJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseMotorJoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "motor1Axis");
        BaseMotorJoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "motor2Axis");
        BaseMotorJoint.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec3f", "motor3Axis");
        BaseMotorJoint.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "axis1Angle");
        BaseMotorJoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "axis2Angle");
        BaseMotorJoint.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "axis3Angle");
        BaseMotorJoint.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "axis1Torque");
        BaseMotorJoint.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFFloat", "axis2Torque");
        BaseMotorJoint.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFFloat", "axis3Torque");
        BaseMotorJoint.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFFloat", "stop1Bounce");
        BaseMotorJoint.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFFloat", "stop2Bounce");
        BaseMotorJoint.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFFloat", "stop3Bounce");
        BaseMotorJoint.fieldDecl[23] = new VRMLFieldDeclaration(3, "SFFloat", "stop1ErrorCorrection");
        BaseMotorJoint.fieldDecl[24] = new VRMLFieldDeclaration(3, "SFFloat", "stop2ErrorCorrection");
        BaseMotorJoint.fieldDecl[25] = new VRMLFieldDeclaration(3, "SFFloat", "stop3ErrorCorrection");
        BaseMotorJoint.fieldDecl[17] = new VRMLFieldDeclaration(4, "SFFloat", "motor1Angle");
        BaseMotorJoint.fieldDecl[18] = new VRMLFieldDeclaration(4, "SFFloat", "motor2Angle");
        BaseMotorJoint.fieldDecl[19] = new VRMLFieldDeclaration(4, "SFFloat", "motor3Angle");
        BaseMotorJoint.fieldDecl[20] = new VRMLFieldDeclaration(4, "SFFloat", "motor1AngleRate");
        BaseMotorJoint.fieldDecl[21] = new VRMLFieldDeclaration(4, "SFFloat", "motor2AngleRate");
        BaseMotorJoint.fieldDecl[22] = new VRMLFieldDeclaration(4, "SFFloat", "motor3AngleRate");
        BaseMotorJoint.fieldDecl[26] = new VRMLFieldDeclaration(3, "SFInt32", "enabledAxes");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("autoCalc", n);
        fieldMap.put("set_autoCalc", n);
        fieldMap.put("autoCalc_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(5);
        fieldMap.put("motor1Axis", n);
        fieldMap.put("set_motor1Axis", n);
        fieldMap.put("motor1Axis_changed", n);
        n = new Integer(6);
        fieldMap.put("motor2Axis", n);
        fieldMap.put("set_motor2Axis", n);
        fieldMap.put("motor2Axis_changed", n);
        n = new Integer(7);
        fieldMap.put("motor3Axis", n);
        fieldMap.put("set_motor3Axis", n);
        fieldMap.put("motor3Axis_changed", n);
        n = new Integer(8);
        fieldMap.put("axis1Angle", n);
        fieldMap.put("set_axis1Angle", n);
        fieldMap.put("axis1Angle_changed", n);
        n = new Integer(9);
        fieldMap.put("axis2Angle", n);
        fieldMap.put("set_axis2Angle", n);
        fieldMap.put("axis2Angle_changed", n);
        n = new Integer(10);
        fieldMap.put("axis3Angle", n);
        fieldMap.put("set_axis3Angle", n);
        fieldMap.put("axis3Angle_changed", n);
        n = new Integer(14);
        fieldMap.put("axis1Torque", n);
        fieldMap.put("set_axis1Torque", n);
        fieldMap.put("axis1Torque_changed", n);
        n = new Integer(15);
        fieldMap.put("axis2Torque", n);
        fieldMap.put("set_axis2Torque", n);
        fieldMap.put("axis2Torque_changed", n);
        n = new Integer(16);
        fieldMap.put("axis3Torque", n);
        fieldMap.put("set_axis3Torque", n);
        fieldMap.put("axis3Torque_changed", n);
        n = new Integer(11);
        fieldMap.put("stop1Bounce", n);
        fieldMap.put("set_stop1Bounce", n);
        fieldMap.put("stop1Bounce_changed", n);
        n = new Integer(12);
        fieldMap.put("stop2Bounce", n);
        fieldMap.put("set_stop2Bounce", n);
        fieldMap.put("stop2Bounce_changed", n);
        n = new Integer(13);
        fieldMap.put("stop3Bounce", n);
        fieldMap.put("set_stop3Bounce", n);
        fieldMap.put("stop3Bounce_changed", n);
        n = new Integer(23);
        fieldMap.put("stop1ErrorCorrection", n);
        fieldMap.put("set_stop1ErrorCorrection", n);
        fieldMap.put("stop1ErrorCorrection_changed", n);
        n = new Integer(24);
        fieldMap.put("stop2ErrorCorrection", n);
        fieldMap.put("set_stop2ErrorCorrection", n);
        fieldMap.put("stop2ErrorCorrection_changed", n);
        n = new Integer(25);
        fieldMap.put("stop3ErrorCorrection", n);
        fieldMap.put("set_stop3ErrorCorrection", n);
        fieldMap.put("stop3ErrorCorrection_changed", n);
        n = new Integer(26);
        fieldMap.put("enabledAxes", n);
        fieldMap.put("set_enabledAxes", n);
        fieldMap.put("enabledAxes_changed", n);
        fieldMap.put("motor1Angle", new Integer(17));
        fieldMap.put("motor2Angle", new Integer(18));
        fieldMap.put("motor3Angle", new Integer(19));
        fieldMap.put("motor1AngleRate", new Integer(20));
        fieldMap.put("motor2AngleRate", new Integer(21));
        fieldMap.put("motor3AngleRate", new Integer(22));
    }
}

