/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseTextureCoordinate3D
extends BaseGeometricPropertyNode
implements VRMLTextureCoordinateNodeType {
    protected static final int FIELD_POINT = 1;
    protected static final int LAST_TEXTURECOORDINATE_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfPoint;
    protected int numPoint;

    protected BaseTextureCoordinate3D() {
        super("TextureCoordinate3D");
        this.hasChanged = new boolean[2];
        this.vfPoint = FieldConstants.EMPTY_MFVEC3F;
    }

    protected BaseTextureCoordinate3D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("point");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfPoint = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfPoint, 0, vRMLFieldData.numElements * 3);
                this.numPoint = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getNumTextureComponents() {
        return 3;
    }

    public int getNumSets() {
        return 1;
    }

    public int getSize(int n) {
        return this.numPoint;
    }

    public void setPoint(int n, float[] fArray, int n2) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 > this.vfPoint.length) {
            this.vfPoint = new float[n2];
        }
        this.numPoint = n2;
        System.arraycopy(fArray, 0, this.vfPoint, 0, this.numPoint);
        if (!this.inSetup) {
            this.fireComponentChanged(1);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public void getPoint(int n, float[] fArray) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.vfPoint, 0, fArray, 0, this.numPoint);
    }

    public int isShared(int n) {
        return n;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 48;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numPoint / 3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfPoint, this.numPoint);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setPoint(0, fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseTextureCoordinate3D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTextureCoordinate3D.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3f", "point");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("point", n);
        fieldMap.put("set_point", n);
        fieldMap.put("point_changed", n);
    }
}

