/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseInterpolatorNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.renderer.common.nodes.geospatial.PositionInterpolator;

public abstract class BaseGeoPositionInterpolator
extends BaseInterpolatorNode {
    protected static final int FIELD_GEO_VALUE_CHANGED = 5;
    protected static final int FIELD_GEO_ORIGIN = 6;
    protected static final int FIELD_GEO_SYSTEM = 7;
    protected static final int LAST_GEO_INDEX = 7;
    private static final int NUM_FIELDS = 8;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private double[] vfKeyValue;
    private int numKeyValue;
    private float[] vfValue;
    private double[] vfGeoValue;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    private PositionInterpolator interpolator;
    private double[] localCoords;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;

    protected BaseGeoPositionInterpolator() {
        super("GeoPositionInterpolator");
        this.hasChanged = new boolean[8];
        this.localCoords = new double[3];
        this.vfKeyValue = FieldConstants.EMPTY_MFVEC3D;
        this.vfValue = new float[3];
        this.vfGeoValue = new double[3];
        this.vfGeoSystem = new String[]{"GD", "WE"};
    }

    protected BaseGeoPositionInterpolator(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLInterpolatorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("keyValue");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKeyValue = new double[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfKeyValue, 0, vRMLFieldData.numElements * 3);
                this.numKeyValue = vRMLFieldData.numElements * 3;
            }
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setFraction(float f) {
        this.vfFraction = f;
        if (this.numKey > 0 && this.interpolator != null && this.numKeyValue > 0) {
            double[] dArray = this.interpolator.floatValue(this.vfFraction);
            this.setValue(dArray);
        }
    }

    public void setKey(float[] fArray, int n) {
        super.setKey(fArray, n);
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        this.rebuildInterpolator();
        this.inSetup = true;
        this.setFraction(this.vfFraction);
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleArrayValue = this.vfKeyValue;
                vRMLFieldData.dataType = (short)12;
                vRMLFieldData.numElements = this.numKeyValue / 3;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfValue;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleArrayValue = this.vfGeoValue;
                vRMLFieldData.dataType = (short)12;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfGeoSystem;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfKeyValue, this.numKeyValue);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfValue, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfGeoValue, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 3) {
            super.setValue(n, f);
            return;
        }
        this.setFraction(f);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 2) {
            super.setValue(n, dArray, n2);
            return;
        }
        this.setKeyValue(dArray, n2);
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 6: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setKeyValue(double[] dArray, int n) {
        this.numKeyValue = n;
        if (this.numKeyValue != 0) {
            if (this.vfKeyValue.length < n) {
                this.vfKeyValue = new double[n];
            }
            System.arraycopy(dArray, 0, this.vfKeyValue, 0, n);
        }
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
        }
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setValue(double[] dArray) {
        this.vfGeoValue[0] = dArray[0];
        this.vfGeoValue[1] = dArray[1];
        this.vfGeoValue[2] = dArray[2];
        try {
            if (this.geoCoordSwap) {
                double d = this.vfGeoValue[0];
                this.vfGeoValue[0] = this.vfGeoValue[1];
                this.vfGeoValue[1] = d;
                this.geoTransform.transform(this.vfGeoValue, 0, this.localCoords, 0, 1);
                d = this.vfGeoValue[0];
                this.vfGeoValue[0] = this.vfGeoValue[1];
                this.vfGeoValue[1] = d;
            } else {
                this.geoTransform.transform(this.vfGeoValue, 0, this.localCoords, 0, 1);
            }
            if (this.vfGeoOrigin == null) {
                this.vfValue[0] = (float)this.localCoords[0];
                this.vfValue[1] = (float)this.localCoords[1];
                this.vfValue[2] = (float)this.localCoords[2];
            } else {
                double[] dArray2 = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.vfValue[0] = (float)(this.localCoords[0] - dArray2[0]);
                this.vfValue[1] = (float)(this.localCoords[1] - dArray2[1]);
                this.vfValue[2] = (float)(this.localCoords[2] - dArray2[2]);
            }
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.hasChanged[5] = true;
            this.fireFieldChanged(4);
            this.fireFieldChanged(5);
        }
    }

    private void rebuildInterpolator() {
        if (this.numKey == 0 || this.numKeyValue == 0) {
            this.interpolator = null;
            return;
        }
        int n = this.numKey < this.numKeyValue / 3 ? this.numKey : this.numKeyValue / 3;
        this.interpolator = new PositionInterpolator(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(this.vfKey[i], this.vfKeyValue[n2], this.vfKeyValue[n2 + 1], this.vfKeyValue[n2 + 2]);
            n2 += 3;
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        VRMLNodeType vRMLNodeType2 = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType3;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
    }

    static {
        nodeFields = new int[]{0, 6};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        BaseGeoPositionInterpolator.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoPositionInterpolator.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFFloat", "set_fraction");
        BaseGeoPositionInterpolator.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFFloat", "key");
        BaseGeoPositionInterpolator.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFVec3d", "keyValue");
        BaseGeoPositionInterpolator.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "value_changed");
        BaseGeoPositionInterpolator.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec3d", "geovalue_changed");
        BaseGeoPositionInterpolator.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoPositionInterpolator.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        fieldMap.put("set_fraction", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("key", n);
        fieldMap.put("set_key", n);
        fieldMap.put("key_changed", n);
        n = new Integer(2);
        fieldMap.put("keyValue", n);
        fieldMap.put("set_keyValue", n);
        fieldMap.put("keyValue_changed", n);
        fieldMap.put("value_changed", new Integer(4));
        fieldMap.put("geovalue_changed", new Integer(5));
        fieldMap.put("geoSystem", new Integer(7));
        fieldMap.put("geoOrigin", new Integer(6));
    }
}

