/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.xj3d.core.loading.CacheDetails;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoadRequestHandler;
import org.xj3d.impl.core.loading.BaseLoadHandler;
import org.xj3d.impl.core.loading.ContentLoadDetails;

class ContentLoadHandler
extends BaseLoadHandler
implements LoadRequestHandler {
    private static final String UNKNOWN_ERROR_MSG = "Unknown error in content loading process";
    private static final String CONTENT_ERROR_MSG = "Error setting external content:";
    private static final String INVALID_FIELD_MSG = "Internal error caused by attempting to send content to an invalid field index: ";
    private static final String NO_URLS_MSG = "Cannot resolve any URLS for URL: ";
    private FileCache fileCache;
    private HashSet inlineSet;

    ContentLoadHandler(FileCache fileCache) {
        this.fileCache = fileCache;
        this.inlineSet = new HashSet(6);
        this.inlineSet.add("model/vrml");
        this.inlineSet.add("x-world/x-vrml");
        this.inlineSet.add("application/xml");
        this.inlineSet.add("model/x3d+xml");
        this.inlineSet.add("model/x3d+vrml");
        this.inlineSet.add("model/x3d+binary");
    }

    public void processLoadRequest(ErrorReporter errorReporter, String[] stringArray, Vector vector) {
        VRMLMultiExternalNodeType vRMLMultiExternalNodeType;
        VRMLSingleExternalNodeType vRMLSingleExternalNodeType;
        int n;
        ContentLoadDetails contentLoadDetails;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            contentLoadDetails = (ContentLoadDetails)vector.get(n2);
            n = 0;
            if (contentLoadDetails.fieldIndex == -1) {
                vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                n = vRMLSingleExternalNodeType.getLoadState();
            } else {
                vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
                vRMLMultiExternalNodeType.getLoadState(contentLoadDetails.fieldIndex);
            }
            bl2 = n != 3;
        }
        if (!bl2) {
            return;
        }
        bl = false;
        this.terminateCurrent = false;
        for (n2 = 0; n2 < vector.size() && !bl2; ++n2) {
            contentLoadDetails = (ContentLoadDetails)vector.get(n2);
            if (contentLoadDetails.fieldIndex == -1) {
                vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                vRMLSingleExternalNodeType.setLoadState(2);
                continue;
            }
            vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
            vRMLMultiExternalNodeType.setLoadState(contentLoadDetails.fieldIndex, 2);
        }
        n2 = stringArray == null ? 0 : stringArray.length;
        for (n = 0; !bl && n < n2; ++n) {
            CacheDetails cacheDetails;
            String string = stringArray[n];
            int n3 = string.lastIndexOf(35);
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if ((cacheDetails = this.fileCache.checkForFile(string)) != null) {
                String string2 = cacheDetails.getContentType();
                Object object = cacheDetails.getContent();
                bl = true;
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        contentLoadDetails = (ContentLoadDetails)vector.get(i);
                        if (contentLoadDetails.fieldIndex == -1) {
                            vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                            if (!vRMLSingleExternalNodeType.checkValidContentType(string2)) continue;
                            vRMLSingleExternalNodeType.setLoadedURI(stringArray[n]);
                            vRMLSingleExternalNodeType.setContent(string2, object);
                            vRMLSingleExternalNodeType.setLoadState(3);
                            continue;
                        }
                        vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
                        if (!vRMLMultiExternalNodeType.checkValidContentType(contentLoadDetails.fieldIndex, string2)) continue;
                        vRMLMultiExternalNodeType.setLoadedURI(contentLoadDetails.fieldIndex, stringArray[n]);
                        vRMLMultiExternalNodeType.setContent(contentLoadDetails.fieldIndex, string2, object);
                        vRMLMultiExternalNodeType.setLoadState(contentLoadDetails.fieldIndex, 3);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
                        continue;
                    }
                    catch (InvalidFieldException invalidFieldException) {
                        errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
                        continue;
                    }
                    catch (Exception exception) {
                        errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
                    }
                }
                continue;
            }
            bl = this.loadExternal(errorReporter, stringArray[n], string, vector);
        }
        if (!bl) {
            for (n = 0; n < vector.size(); ++n) {
                contentLoadDetails = (ContentLoadDetails)vector.get(n);
                if (contentLoadDetails.fieldIndex == -1) {
                    vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                    vRMLSingleExternalNodeType.setLoadState(4);
                    continue;
                }
                vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
                vRMLMultiExternalNodeType.setLoadState(contentLoadDetails.fieldIndex, 4);
            }
            if (stringArray.length > 0) {
                errorReporter.warningReport(NO_URLS_MSG + stringArray[0], null);
            }
        }
        this.currentConnection = null;
    }

    private boolean loadExternal(ErrorReporter errorReporter, String string, String string2, Vector vector) {
        VRMLSingleExternalNodeType vRMLSingleExternalNodeType = null;
        VRMLMultiExternalNodeType vRMLMultiExternalNodeType = null;
        boolean bl = false;
        URL[] uRLArray = null;
        try {
            URI uRI = URIUtils.createURI(string2);
            if (this.terminateCurrent) {
                return false;
            }
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.terminateCurrent || uRLArray == null) {
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                this.currentConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                continue;
            }
            if (this.terminateCurrent) break;
            try {
                if (!this.makeConnection(errorReporter)) {
                    if (!this.terminateCurrent) continue;
                    break;
                }
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                String string3 = this.currentConnection.getContentType();
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                if (string3 == null) {
                    this.currentConnection.close();
                    continue;
                }
                if (this.inlineSet.contains(string3)) {
                    bl = this.loadInline(this.currentConnection, string3, uRLArray[i], errorReporter, string, string2, vector);
                    if (!bl) continue;
                    break;
                }
                Object object = this.currentConnection.getContent();
                this.currentConnection.close();
                if (object == null) continue;
                boolean bl2 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    ContentLoadDetails contentLoadDetails = (ContentLoadDetails)vector.get(j);
                    if (contentLoadDetails.fieldIndex == -1) {
                        vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                        if (!vRMLSingleExternalNodeType.checkValidContentType(string3)) continue;
                        bl2 = true;
                        vRMLSingleExternalNodeType.setLoadedURI(string);
                        vRMLSingleExternalNodeType.setContent(string3, object);
                        vRMLSingleExternalNodeType.setLoadState(3);
                        continue;
                    }
                    vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
                    if (!vRMLMultiExternalNodeType.checkValidContentType(contentLoadDetails.fieldIndex, string3)) continue;
                    bl2 = true;
                    vRMLMultiExternalNodeType.setLoadedURI(contentLoadDetails.fieldIndex, string);
                    vRMLMultiExternalNodeType.setContent(contentLoadDetails.fieldIndex, string3, object);
                    vRMLMultiExternalNodeType.setLoadState(contentLoadDetails.fieldIndex, 3);
                }
                if (!bl2) continue;
                if (!(object instanceof BasicScene) && string3.indexOf("image") != 0) {
                    this.fileCache.cacheFile(string2, string3, object);
                }
                bl = true;
                break;
            }
            catch (IOException iOException) {
                if (!this.terminateCurrent) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
                continue;
            }
            catch (Exception exception) {
                errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
            }
        }
        return bl;
    }

    private boolean loadInline(ResourceConnection resourceConnection, String string, URL uRL, ErrorReporter errorReporter, String string2, String string3, Vector vector) {
        Object object;
        Object object2;
        VRMLSingleExternalNodeType vRMLSingleExternalNodeType = null;
        VRMLMultiExternalNodeType vRMLMultiExternalNodeType = null;
        boolean bl = false;
        try {
            object2 = resourceConnection.getContent();
            resourceConnection.close();
            if (object2 == null) {
                return false;
            }
            object = (ContentLoadDetails)vector.get(0);
            if (((ContentLoadDetails)object).fieldIndex == -1) {
                vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)((ContentLoadDetails)object).node;
                if (vRMLSingleExternalNodeType.checkValidContentType(string)) {
                    bl = true;
                    vRMLSingleExternalNodeType.setLoadedURI(string2);
                    vRMLSingleExternalNodeType.setContent(string, object2);
                    vRMLSingleExternalNodeType.setLoadState(3);
                }
            } else {
                vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)((ContentLoadDetails)object).node;
                if (vRMLMultiExternalNodeType.checkValidContentType(((ContentLoadDetails)object).fieldIndex, string)) {
                    bl = true;
                    vRMLMultiExternalNodeType.setLoadedURI(((ContentLoadDetails)object).fieldIndex, string2);
                    vRMLMultiExternalNodeType.setContent(((ContentLoadDetails)object).fieldIndex, string, object2);
                    vRMLMultiExternalNodeType.setLoadState(((ContentLoadDetails)object).fieldIndex, 3);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
        }
        catch (InvalidFieldException invalidFieldException) {
            errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
        }
        catch (Exception exception) {
            errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
        }
        for (int i = 1; i < vector.size(); ++i) {
            try {
                resourceConnection = uRL.getResource();
            }
            catch (IOException iOException) {
                return bl;
            }
            if (this.terminateCurrent) break;
            try {
                if (!this.makeConnection(errorReporter)) {
                    if (this.terminateCurrent) break;
                    return bl;
                }
                if (this.terminateCurrent) {
                    resourceConnection.close();
                    break;
                }
                object = resourceConnection.getContentType();
                if (this.terminateCurrent) {
                    resourceConnection.close();
                    break;
                }
                if (object == null) {
                    resourceConnection.close();
                    return bl;
                }
                object2 = resourceConnection.getContent();
                resourceConnection.close();
                if (object2 == null) {
                    return bl;
                }
                ContentLoadDetails contentLoadDetails = (ContentLoadDetails)vector.get(i);
                if (contentLoadDetails.fieldIndex == -1) {
                    vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)contentLoadDetails.node;
                    if (!vRMLSingleExternalNodeType.checkValidContentType(string)) continue;
                    bl = true;
                    vRMLSingleExternalNodeType.setLoadedURI(string2);
                    vRMLSingleExternalNodeType.setContent(string, object2);
                    vRMLSingleExternalNodeType.setLoadState(3);
                    continue;
                }
                vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)contentLoadDetails.node;
                if (!vRMLMultiExternalNodeType.checkValidContentType(contentLoadDetails.fieldIndex, string)) continue;
                bl = true;
                vRMLMultiExternalNodeType.setLoadedURI(contentLoadDetails.fieldIndex, string2);
                vRMLMultiExternalNodeType.setContent(contentLoadDetails.fieldIndex, string, object2);
                vRMLMultiExternalNodeType.setLoadState(contentLoadDetails.fieldIndex, 3);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
                continue;
            }
            catch (Exception exception) {
                errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
            }
        }
        return bl;
    }
}

