/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseDISEntityTypeMapping
extends AbstractNode {
    protected static final int FIELD_DOMAIN = 1;
    protected static final int FIELD_COUNTRY = 2;
    protected static final int FIELD_CATEGORY = 3;
    protected static final int FIELD_SUBCATEGORY = 4;
    protected static final int FIELD_SPECIFIC = 5;
    protected static final int FIELD_KIND = 6;
    protected static final int FIELD_EXTRA = 7;
    protected static final int FIELD_URL = 8;
    protected static final int LAST_DIS_ENTITY_MAPPING_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int vfEntityCategory;
    protected int vfEntityDomain;
    protected int vfEntityExtra;
    protected int vfEntityKind;
    protected int vfEntitySpecific;
    protected int vfEntitySubCategory;
    protected int vfEntityCountry;
    protected String[] vfUrl;
    protected VRMLNodeFactory nodeFactory;

    public BaseDISEntityTypeMapping() {
        super("DISEntityTypeMapping");
        this.hasChanged = new boolean[9];
        this.vfEntityCategory = 0;
        this.vfEntityCountry = 0;
        this.vfEntityDomain = 0;
        this.vfEntityKind = 0;
        this.vfEntitySpecific = 0;
        this.vfEntityExtra = 0;
        this.vfEntitySubCategory = 0;
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
    }

    public BaseDISEntityTypeMapping(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("category");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityCategory = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("domain");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityDomain = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("extra");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityExtra = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("kind");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityKind = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("specific");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntitySpecific = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("subCategory");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntitySubCategory = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("country");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEntityCountry = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getPrimaryType() {
        return 67;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        vRMLFieldData.numElements = 1;
        switch (n) {
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfUrl;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfUrl.length;
                break;
            }
            case 3: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityCategory;
                break;
            }
            case 2: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityCountry;
                break;
            }
            case 4: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntitySubCategory;
                break;
            }
            case 1: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityDomain;
                break;
            }
            case 6: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityKind;
                break;
            }
            case 5: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntitySpecific;
                break;
            }
            case 7: {
                vRMLFieldData.dataType = (short)2;
                vRMLFieldData.intValue = this.vfEntityExtra;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfEntityCategory);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfEntityDomain);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfEntityCountry);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfEntitySubCategory);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfEntitySpecific);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfEntityKind);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfEntityExtra);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTransform.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.vfEntityKind = n2;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            case 2: {
                this.vfEntityCountry = n2;
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            case 3: {
                this.vfEntityCategory = n2;
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            case 4: {
                this.vfEntitySubCategory = n2;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 5: {
                this.vfEntitySpecific = n2;
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            case 7: {
                this.vfEntityExtra = n2;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            case 1: {
                this.vfEntityDomain = n2;
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.vfUrl = new String[1];
                this.vfUrl[0] = string;
                if (this.inSetup) break;
                this.fireUrlChanged(n);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.vfUrl = new String[n2];
                System.arraycopy(stringArray, 0, this.vfUrl, 0, n2);
                if (this.inSetup) break;
                this.fireUrlChanged(n);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    protected void fireUrlChanged(int n) {
        System.out.println("DISEntityTypeMappping url changed, need to handle");
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(9);
        BaseDISEntityTypeMapping.fieldDecl[0] = new VRMLFieldDeclaration(2, "SFNode", "metadata");
        BaseDISEntityTypeMapping.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFInt32", "category");
        BaseDISEntityTypeMapping.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFInt32", "domain");
        BaseDISEntityTypeMapping.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFInt32", "kind");
        BaseDISEntityTypeMapping.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFInt32", "specific");
        BaseDISEntityTypeMapping.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFInt32", "subCategory");
        BaseDISEntityTypeMapping.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFInt32", "country");
        BaseDISEntityTypeMapping.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFInt32", "extra");
        BaseDISEntityTypeMapping.fieldDecl[8] = new VRMLFieldDeclaration(2, "MFString", "url");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("category", n);
        fieldMap.put("set_category", n);
        fieldMap.put("category_changed", n);
        n = new Integer(2);
        fieldMap.put("country", n);
        fieldMap.put("set_country", n);
        fieldMap.put("country_changed", n);
        n = new Integer(1);
        fieldMap.put("domain", n);
        fieldMap.put("set_domain", n);
        fieldMap.put("domain_changed", n);
        n = new Integer(7);
        fieldMap.put("extra", n);
        fieldMap.put("set_extra", n);
        fieldMap.put("extra_changed", n);
        n = new Integer(6);
        fieldMap.put("kind", n);
        fieldMap.put("set_kind", n);
        fieldMap.put("kind_changed", n);
        n = new Integer(5);
        fieldMap.put("specific", n);
        fieldMap.put("set_specific", n);
        fieldMap.put("specific_changed", n);
        n = new Integer(4);
        fieldMap.put("subCategory", n);
        fieldMap.put("set_subCategory", n);
        fieldMap.put("subCategory_changed", n);
        n = new Integer(8);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
    }
}

