/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.loading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.xj3d.core.loading.LoadRequest;

class LoadPriorityComparator
implements Comparator {
    private HashMap priorityMap = new HashMap();

    LoadPriorityComparator() {
        this.setupPriorities();
    }

    public int compare(Object object, Object object2) {
        int n;
        LoadRequest loadRequest = (LoadRequest)object;
        LoadRequest loadRequest2 = (LoadRequest)object2;
        Integer n2 = (Integer)this.priorityMap.get(loadRequest.type);
        Integer n3 = (Integer)this.priorityMap.get(loadRequest2.type);
        int n4 = n2 == null ? 1000 : n2;
        int n5 = n = n3 == null ? 1000 : n3;
        if (n4 != n) {
            return n4 < n ? -1 : 1;
        }
        if (loadRequest.url.length != loadRequest2.url.length) {
            return loadRequest.url.length < loadRequest2.url.length ? -1 : 1;
        }
        if (loadRequest.url[0] == null) {
            return 1;
        }
        if (loadRequest2.url[0] == null) {
            return -1;
        }
        return loadRequest.url[0].compareTo(loadRequest2.url[0]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LoadPriorityComparator)) {
            return false;
        }
        return this.priorityMap.equals(((LoadPriorityComparator)object).priorityMap);
    }

    void updatePriorities() {
        this.priorityMap.clear();
        this.setupPriorities();
    }

    private void setupPriorities() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("org.xj3d.core.loading.sort.order", "textures,externprotos,scripts,inlines,create,audio,movies,shaders,others");
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("scripts");
        arrayList.add("inlines");
        arrayList.add("textures");
        arrayList.add("create");
        arrayList.add("externprotos");
        arrayList.add("audio");
        arrayList.add("movies");
        arrayList.add("shaders");
        arrayList.add("others");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 1;
        this.priorityMap.put("url", new Integer(0));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("url")) continue;
            this.priorityMap.put(string2, new Integer(n++));
            arrayList.remove(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.priorityMap.put(arrayList.get(i), new Integer(n++));
        }
    }
}

