//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//============================================================================

#include <fides/predefined/SupportedDataModels.h>

namespace fides
{
namespace predefined
{

DataModelTypes ConvertDataModelToEnum(std::string str)
{
  const std::map<std::string, DataModelTypes> enumStrings{
    { "uniform", DataModelTypes::UNIFORM },
    { "rectilinear", DataModelTypes::RECTILINEAR },
    { "unstructured", DataModelTypes::UNSTRUCTURED },
    { "unstructured_single", DataModelTypes::UNSTRUCTURED_SINGLE },
    { "xgc", DataModelTypes::XGC },
    { "gtc", DataModelTypes::GTC },
    { "uniform_from_dataset", DataModelTypes::UNIFORM_FROM_DATASET },
    { "rectilinear_from_dataset", DataModelTypes::RECTILINEAR_FROM_DATASET },
    { "unstructured_from_dataset", DataModelTypes::UNSTRUCTURED_FROM_DATASET },
    { "unstructured_single_from_dataset", DataModelTypes::UNSTRUCTURED_SINGLE_FROM_DATASET }
  };
  auto it = enumStrings.find(str);
  return it == enumStrings.end() ? DataModelTypes::UNSUPPORTED : it->second;
}

bool DataModelSupported(const std::string& dataModel)
{
  return ConvertDataModelToEnum(dataModel) != DataModelTypes::UNSUPPORTED;
}

}
}
