/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkStyleData.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkStyleData.h"

#include "vtkObjectFactory.h"

vtkObjectFactoryNewMacro(vtkStyleData);

vtkStyleData::vtkStyleData()
{
}

vtkStyleData::~vtkStyleData()
{
}

void vtkStyleData::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

bool vtkStyleData::SetMarkup(const std::string& markup)
{
  // Don't accept duplicates:
  if (this->Markup.size() == markup.size() && this->Markup == markup)
  {
    return false;
  }
  // Don't accept un-parsable non-CSS:
  if (!this->Parse(markup))
  {
    return false;
  }
  this->Markup = markup;
  return true;
}

bool vtkStyleData::Parse(const std::string& markup)
{
  try
  {
    tao::pegtl::string_input<> in(this->Markup, "mapper style");
    if (!parse<css_grammar, css_action>(in, this->Styles))
    {
      vtkErrorMacro("Unable to parse CSS markup.");
      return false;
    }
    this->Styles->Modified();
  }
  catch (tao::pegtl::parse_error& e)
  {
    const auto& p = e.positions().front();
    vtkErrorMacro("Parsing failed: " << e.what() << " at " << p);
    return false;
  }
  return true;
}
