/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDataAssemblyDOM.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkDataAssemblyDOM
 * @brief An abstract DOM adaptor to vtkDataAssembly's pugi-xml storage.
 *
 * vtkDataAssemblyDOM can respond to queries needed to evaluate selectors
 * for CSS parsing and style computation.
 */

#ifndef vtkDataAssemblyDOM_h
#define vtkDataAssemblyDOM_h

#include "vtkCommonDataModelModule.h" // for export macros
#include "vtkDataAssembly.h"

#include <map>    // for std::map
#include <memory> // for std::unique_ptr
#include <set> // for std::set
#include <string> // for std::string
#include <vector> // for std::vector

class VTKCOMMONDATAMODEL_EXPORT vtkDataAssemblyDOM
{
public:
  /// The type used to identify a node.
  using Node = int;
  /// This may eventually be a (namespace, name) tuple.
  using QualifiedName = std::string;

  vtkDataAssemblyDOM(vtkSmartPointer<vtkDataAssembly>);
  ~vtkDataAssemblyDOM() = default;

  const QualifiedName& nodeName(Node node) const;
  const std::string& nodeId(Node node) const;
  std::set<std::string>& nodeClasses(Node node) const;
  Node nodeNamedAncestor(Node node, const QualifiedName& name) const;
  Node nodeNamedParent(Node node, const QualifiedName& name) const;
  Node nodeNamedSibling(Node node, const QualifiedName& name) const;
  Node nodeNamedGenericSibling(Node node, const QualifiedName& name) const;
  Node nodeParent(Node node) const;
  Node nodeSibling(Node node) const;
  /*
  bool nodeHasName(Node node, const QualifiedName& name) const;
  bool nodeHasClass(Node node, const std::string& name) const;
  bool nodeHasId(Node node, const std::string& name) const;
  bool nodeHasAttribute(Node node, const QualifiedName& name) const;
  bool nodeHasAttributeEqual(Node node, const QualifiedName& name, const std::string& value) const;
  bool nodeHasAttributeDashmatch(Node node, const QualifiedName& name, const std::string& value) const;
  bool nodeHasAttributeIncludes(Node node, const QualifiedName& name, const std::string& value) const;
  bool nodeHasAttributePrefix(Node node, const QualifiedName& name, const std::string& value) const;
  bool nodeHasAttributeSuffix(Node node, const QualifiedName& name, const std::string& value) const;
  bool nodeHasAttributeSubstring(Node node, const QualifiedName& name, const std::string& value) const;

  bool nodeIsRoot(Node node) const;
  int nodeSiblingCount(Node node, bool same_name, bool after) const;
  bool nodeIsEmpty(Node node) const;

  bool nodeIsLink(Node node) const;
  bool nodeIsVisited(Node node) const;
  bool nodeIsHover(Node node) const;
  bool nodeIsActive(Node node) const;
  bool nodeIsFocus(Node node) const;

  bool nodeIsEnabled(Node node) const;
  bool nodeIsDisabled(Node node) const;
  bool nodeIsChecked(Node node) const;

  bool nodeIsTarget(Node node) const;
  bool nodeIsLang(Node node, const std::string& lang) const;

  xxx node_presentational_hint(Node node, uint32_t *nhints, css_hint **hints) const;

  xxx ua_default_for_property(uint32_t property, css_hint *hint) const;

  xxx compute_font_size(const css_hint *parent, css_hint *size) const;

  bool set_libcss_node_data(Node node, void *libcss_node_data);
  xxx get_libcss_node_data(Node node, void **libcss_node_data) const;
   */

  vtkSmartPointer<vtkDataAssembly> Assembly;
};

#endif
