/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDataAssemblyDOM.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkDataAssemblyDOM
 * @brief An abstract DOM adaptor to vtkDataAssembly's pugi-xml storage.
 *
 * vtkDataAssemblyDOM can respond to queries needed to evaluate selectors
 * for CSS parsing and style computation.
 */

#ifndef vtkDataAssemblyDOM_txx
#define vtkDataAssemblyDOM_txx

#include "vtkDataAssemblyDOM.h"

#include <map>    // for std::map
#include <memory> // for std::unique_ptr
#include <set> // for std::set
#include <string> // for std::string
#include <vector> // for std::vector

vtkDataAssemblyDOM::vtkDataAssemblyDOM(vtkSmartPointer<vtkDataAssembly> assembly)
  : Assembly(assembly)
{
}

const vtkDataAssemblyDOM::QualifiedName& vtkDataAssemblyDOM::nodeName(Node node) const
{
  QualifiedName result;
  result = this->Assembly->GetNodeName(node);
  return result;
}

const std::string& vtkDataAssemblyDOM::nodeId(Node node) const
{
  std::string nodeId;
  if (this->Assembly->HasAttribute(node, "id"))
  {
    const char* attr;
    if (this->Assembly->GetAttribute(node, "id", attr))
    {
      nodeId = attr;
    }
  }
  return nodeId;
}

std::set<std::string>& vtkDataAssemblyDOM::nodeClasses(Node node) const
{
  std::set<std::string> classes;
  this->Assembly->GetClasses(node, classes);
  return classes;
}

vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeNamedAncestor(
  vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeNamedParent(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeNamedSibling(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeNamedGenericSibling(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeParent(vtkDataAssemblyDOM::Node node) const;
vtkDataAssemblyDOM::Node vtkDataAssemblyDOM::nodeSibling(vtkDataAssemblyDOM::Node node) const;
/*
bool nodeHasName(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
bool nodeHasClass(vtkDataAssemblyDOM::Node node, const std::string& name) const;
bool nodeHasId(vtkDataAssemblyDOM::Node node, const std::string& name) const;
bool nodeHasAttribute(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name) const;
bool nodeHasAttributeEqual(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name, const std::string& value) const;
bool nodeHasAttributeDashmatch(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name, const std::string& value) const;
bool nodeHasAttributeIncludes(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name, const std::string& value) const;
bool nodeHasAttributePrefix(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name, const std::string& value) const;
bool nodeHasAttributeSuffix(vtkDataAssemblyDOM::Node node, const vtkDataAssemblyDOM::QualifiedName& name, const std::string& value) const;
bool nodeHasAttributeSubstring(vtkDataAssemblyDOM::Node node, vtkDataAssemblyDOM::const QualifiedName& name, const std::string& value) const;

bool vtkDataAssemblyDOM::nodeIsRoot(vtkDataAssemblyDOM::Node node) const;
int vtkDataAssemblyDOM::nodeSiblingCount(vtkDataAssemblyDOM::Node node, bool same_name, bool after) const;
bool vtkDataAssemblyDOM::nodeIsEmpty(vtkDataAssemblyDOM::Node node) const;

bool vtkDataAssemblyDOM::nodeIsLink(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsVisited(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsHover(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsActive(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsFocus(vtkDataAssemblyDOM::Node node) const;

bool vtkDataAssemblyDOM::nodeIsEnabled(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsDisabled(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsChecked(vtkDataAssemblyDOM::Node node) const;

bool vtkDataAssemblyDOM::nodeIsTarget(vtkDataAssemblyDOM::Node node) const;
bool vtkDataAssemblyDOM::nodeIsLang(vtkDataAssemblyDOM::Node node, const std::string& lang) const;

xxx vtkDataAssemblyDOM::nodePresentationalHint(vtkDataAssemblyDOM::Node node, uint32_t *nhints, css_hint **hints) const;

xxx vtkDataAssemblyDOM::uaDefaultForProperty(uint32_t property, css_hint *hint) const;

xxx vtkDataAssemblyDOM::computeFontSize(const css_hint *parent, css_hint *size) const;

bool vtkDataAssemblyDOM::set_libcss_node_data(vtkDataAssemblyDOM::Node node, void *libcss_node_data);
xxx vtkDataAssemblyDOM::get_libcss_node_data(vtkDataAssemblyDOM::Node node, void **libcss_node_data) const;
 */

#endif
