from vtkmodules.vtkCommonDataModel import *
from vtkmodules.vtkRenderingCore import *
from vtkmodules.vtkFiltersGeometry import vtkCellGridExtractSurface
from vtkmodules.vtkIOGeometry import vtkCellGridReader
from vtkmodules.vtkRenderingOpenGL2 import *
from vtkmodules.vtkInteractionStyle import *
from vtkmodules.vtkInteractionWidgets import vtkCameraOrientationWidget
import sys

class KeyPressInteractorStyle(vtkInteractorStyleTrackballCamera):

    def __init__(self,parent=None):
        self.mapper = None
        if(parent is not None):
            self.parent = parent

        self.AddObserver('KeyPressEvent', self.keyPress)
        self.pcoordId = -1
        self.bfId = -1
        self.fieldId = 0

    def keyPress(self,obj,event):
        key = self.parent.GetKeySym()
        print(f"{key} was pressed")
        if not isinstance(self.mapper, vtkCellGridMapper):
            return
        if key.lower() == 'd' and self.parent.GetControlKey():
            self.pcoordId = self.pcoordId + 1
            self.bfId = -1
        elif key.lower() == 'b' and self.parent.GetControlKey():
            self.pcoordId = -1
            self.bfId = self.bfId + 1
        elif key.lower() == "r":
            self.bfId = -1
            self.pcoordId = -1
        elif key.lower() == 'f' and self.parent.GetControlKey():
            self.fieldId = (self.fieldId + 1) % 4
        self.mapper.SetVisualizePCoords(self.pcoordId)
        self.mapper.SetVisualizeBasisFunction(self.bfId)
        self.mapper.SetArrayName('scalar%d' % self.fieldId)
        self.parent.Render()

def main():
    rdr = vtkCellGridReader()
    rdr.SetFileName('dgHex2d.dg')
    rdr.Update()
    sid = vtkCellGridExtractSurface()
    sid.SetInputConnection(rdr.GetOutputPort())
    sid.Update()

    dd = sid.GetOutputDataObject(0)
    print(dd)
    bds = [1, -1, 1, -1, 1, -1]
    dd.GetBounds(bds)
    print(bds)
    print(dd.GetNumberOfCells())
    # sq = vtkCellGridSidesQuery()
    # dd.Query(sq)

    mapper = vtkOpenGLCellGridMapper2()
    # mapper.SetFieldToDOFRelation(vtkCellGridMapper.FieldDegreeOfFreedomType.VertexDiscontinuous)
    mapper.SetInputConnection(sid.GetOutputPort())
    mapper.ScalarVisibilityOn()
    mapper.InterpolateScalarsBeforeMappingOn()
    mapper.SetArrayName('scalar0')

    actor = vtkActor()
    actor.SetMapper(mapper)
    # ppty = vtkProperty()
    # ppty.SetOpacity(0.4)
    # actor.SetProperty(ppty)

    ren = vtkRenderer()
    ren.AddActor(actor)

    rw = vtkRenderWindow()
    rw.AddRenderer(ren)
    ren.SetBackground(0.1, 0.1, 0.1)

    rwi = vtkRenderWindowInteractor()
    rwi.SetRenderWindow(rw)

    style = KeyPressInteractorStyle(rwi)
    style.mapper = mapper
    rwi.SetInteractorStyle(style)

    #cow = vtkCameraOrientationWidget()
    #cow.SetParentRenderer(ren)
    ## Enable the widget.
    #cow.On()

    print("""Keys:

Ctrl+d   – color by parametric coordinates instead of cell-attribute field.
Ctrl+b   – color by basis functions instead of cell-attribute field.
Ctrl+f   – cycle through the 4 example cell-attribute fields.
r        – reset (color by the current cell-attribute field instead of parameters/basis functions).
""")

    rwi.Initialize()
    rwi.Start()

if __name__ == "__main__":
    main()
