+ vtkCellGrid:
  data object containing cells which are defined by degrees-of-freedom
  interpreted via vtkCellAttribute instances.
  Other than "consuming" arrays, cells are black boxes and the grid
  itself only holds a vtkCellMetadata object per type (not per cell).
+ vtkCellMetadata:
  object held by vtkCellGrid used to map degrees-of-freedom array
  collections to shape (i.e., a vtkCellAttribute whose range is physical
  coordinates) and other attributes (fields defined over the shape).
+ vtkCellAttribute:
  a function (map from reference coordinates to some other space) specified
  by array-collections held in vtkCellGrid and interpolated over all cells
  in the grid (each of whose shape is encoded by vtkCellMetadata).
  All vtkCellMetadata instances cooperate to produce a set of vtkCellAttribute
  instances for the entire grid.
  (This may be accomplished by a 2-pass (insertion, then accept/veto) algorithm.)
  Only attributes accepted by every vtkCellMetadata instance are exposed to the vtkCellGrid.
  If any vtkCellMetadata instance vetoes the physical coordinate map of another
  cell type, the vtkCellGrid is considered ill-posed.

+ Domain of reference cells
  + Reference cells have a shape.
    The shape can be viewed theoretically as a CW-complex ("closure-finite", "weak" topology)
    and practically as a decomposition into simplices of 1+ dimensions that describe/approximate
    the cell's shape and its boundaries.
  + There are two cases of interest:
    + The entire domain is composed of cells
      of a fixed number of shapes (i.e., tetrahedra,
      hexahedra, pyramids; and their boundaries)
    + The domain is composed of cells each of which
      has its own shape (i.e., Voronoi cells that may
      have varying numbers of faces, edges, and
      vertices).

+ Range of function defined over reference cell.
  + "Physical" attribute has a range of R^n (or R^(n+1) in case of homogenous coordinates).
    Other attributes may have other ranges (scalars, vectors, matrices, tensors, quaternions, any
    mathematical object in general).

