/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class    vtkOpenGLCellGridMapper2
 * @brief    CellGrid mapper using OpenGL to render exotic finite element fields and cells.
 */

#ifndef vtkOpenGLCellGridMapper2_h
#define vtkOpenGLCellGridMapper2_h

#include "vtkRenderingOpenGL2Module.h" // For export macro
#include "vtkCellGridMapper.h"
#include <memory> // for ivar


class VTKRENDERINGOPENGL2_EXPORT vtkOpenGLCellGridMapper2 : public vtkCellGridMapper
{
public:
  static vtkOpenGLCellGridMapper2* New();
  vtkTypeMacro(vtkOpenGLCellGridMapper2, vtkCellGridMapper);
  void PrintSelf(ostream&, vtkIndent indent) override;

  void Render(vtkRenderer*, vtkActor*) override;

  /**
   * Release any graphics resources that are being consumed by this mapper.
   * The parameter window could be used to determine which graphic
   * resources to release.
   */
  void ReleaseGraphicsResources(vtkWindow* window) override;

  /**
   * WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE
   * DO NOT USE THIS METHOD OUTSIDE OF THE RENDERING PROCESS
   * Used by vtkHardwareSelector to determine if the prop supports hardware
   * selection.
   */
  bool GetSupportsSelection() override { return false; }

  /**
   * Make a shallow copy of this mapper.
   */
  void ShallowCopy(vtkAbstractMapper* m) override;

protected:
  vtkOpenGLCellGridMapper2();
  ~vtkOpenGLCellGridMapper2() override = default;

private:
  vtkOpenGLCellGridMapper2(const vtkOpenGLCellGridMapper2&) = delete;
  void operator=(const vtkOpenGLCellGridMapper2&) = delete;

  class vtkInternals;
  std::unique_ptr<vtkInternals> Internal;
};

#endif
