/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class    vtkOpenGLCellGridMapper
 * @brief    CellGrid mapper using OpenGL to render exotic finite element fields and cells.
 */

#ifndef vtkOpenGLCellGridMapper_h
#define vtkOpenGLCellGridMapper_h

#include "vtkRenderingOpenGL2Module.h" // For export macro
#include "vtkCellGridMapper.h"
#include <memory> // for ivar


class VTKRENDERINGOPENGL2_EXPORT vtkOpenGLCellGridMapper : public vtkCellGridMapper
{
public:
  static vtkOpenGLCellGridMapper* New();
  vtkTypeMacro(vtkOpenGLCellGridMapper, vtkCellGridMapper);
  void PrintSelf(ostream&, vtkIndent indent) override;

  void Render(vtkRenderer*, vtkActor*) override;

  /**
   * Release any graphics resources that are being consumed by this mapper.
   * The parameter window could be used to determine which graphic
   * resources to release.
   */
  void ReleaseGraphicsResources(vtkWindow*) override;

  /**
   * WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE
   * DO NOT USE THIS METHOD OUTSIDE OF THE RENDERING PROCESS
   * Used by vtkHardwareSelector to determine if the prop supports hardware
   * selection.
   */
  bool GetSupportsSelection() override { return false; }

  /**
   * Make a shallow copy of this mapper.
   */
  void ShallowCopy(vtkAbstractMapper* m) override;

protected:
  vtkOpenGLCellGridMapper();
  ~vtkOpenGLCellGridMapper() override = default;

  void MapDataArray(const char* vertexAttributeName, const char* dataArrayName,
    const char* texturename, int fieldAssociation, int componentno);

private:
  vtkOpenGLCellGridMapper(const vtkOpenGLCellGridMapper&) = delete;
  void operator=(const vtkOpenGLCellGridMapper&) = delete;

  class vtkInternals;
  std::unique_ptr<vtkInternals> Internal;
};

#endif