/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDGHexahedronOpenGLRenderer.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkDGHexahedronOpenGLRenderer
 * @brief   Respond to a query on one particular type of cell.
 *
 * This is pure virtual base class that all responder types must inherit.
 */

#ifndef vtkDGHexahedronOpenGLRenderer_h
#define vtkDGHexahedronOpenGLRenderer_h

#include "vtkCellGridResponder.h"
#include "vtkOpenGLCellGridRenderRequest.h"

class vtkCellMetadata;
class vtkDGHexahedronOpenGLRenderers;

class VTKCOMMONDATAMODEL_EXPORT vtkDGHexahedronOpenGLRenderer : public vtkCellGridResponder<vtkOpenGLCellGridRenderRequest>
{
public:
  static vtkDGHexahedronOpenGLRenderer* New();
  vtkTypeMacro(vtkDGHexahedronOpenGLRenderer, vtkCellGridResponder<vtkOpenGLCellGridRenderRequest>);

  bool Query(vtkOpenGLCellGridRenderRequest* request, vtkCellMetadata* hexahedra, vtkCellGridResponders* caches) override;

protected:
  vtkDGHexahedronOpenGLRenderer() = default;
  ~vtkDGHexahedronOpenGLRenderer() override = default;

  bool DrawCells(vtkOpenGLCellGridRenderRequest* request, vtkCellMetadata* hexahedra);
  bool ReleaseResources(vtkOpenGLCellGridRenderRequest* request);

private:
  vtkDGHexahedronOpenGLRenderer(const vtkDGHexahedronOpenGLRenderer&) = delete;
  void operator=(const vtkDGHexahedronOpenGLRenderer&) = delete;
};

#endif // vtkDGHexahedronOpenGLRenderer_h
