/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkCellGridExtractSurface.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkCellGridExtractSurface
 * @brief   Adds an array holding tuples of sides that form the external surface of a cell grid.
 *
 * This filter simply adds or replaces a 2-component array for each cell type
 * that identifies the set of cell sides that form the external surface of
 * the grid. Internally, it uses a vtkCellGridSidesQuery to obtain sides, so
 * the cells in your vtkCellGrid must provide a responder for this query type.
 *
 * @sa vtkCellGridSidesQuery
 */
#ifndef vtkCellGridExtractSurface_h
#define vtkCellGridExtractSurface_h

#include "vtkFiltersGeometryModule.h" // For export macro
#include "vtkCellGridAlgorithm.h"
#include "vtkNew.h" // for ivar

class vtkCellGridSidesQuery;

class VTKFILTERSGEOMETRY_EXPORT vtkCellGridExtractSurface : public vtkCellGridAlgorithm
{
public:
  static vtkCellGridExtractSurface* New();
  vtkTypeMacro(vtkCellGridExtractSurface, vtkCellGridAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  static vtkStringToken GetSideAttribute();

protected:
  vtkCellGridExtractSurface() = default;
  ~vtkCellGridExtractSurface() override = default;

  int RequestData(
    vtkInformation* request, vtkInformationVector** inInfo, vtkInformationVector* ouInfo) override;

  vtkNew<vtkCellGridSidesQuery> Request;

private:
  vtkCellGridExtractSurface(const vtkCellGridExtractSurface&) = delete;
  void operator=(const vtkCellGridExtractSurface&) = delete;
};

#endif // vtkCellGridExtractSurface_h
