/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDGHex.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkDGHex
 * @brief   Metadata for a discontinuous Galerkin hexahedron.
 *
 * Currently, only a linear shape is supported but this
 * may change to arbitrary order.
 */

#ifndef vtkDGHex_h
#define vtkDGHex_h

#include "vtkCellMetadata.h"
#include "vtkStringToken.h" // for vtkStringToken::Hash

#include <unordered_map>
#include <set>

class vtkCellGrid;
class vtkDataSetAttributes;
class vtkCellAttribute;

class VTKCOMMONDATAMODEL_EXPORT vtkDGHex : public vtkCellMetadata
{
public:
  using CellTypeId = std::size_t;
  using DOFType = vtkStringToken;
  static vtkDGHex* New();

  vtkTypeMacro(vtkDGHex, vtkCellMetadata);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  vtkIdType GetNumberOfCells() override;

  // std::set<DOFType> RequiredDOFs(const vtkCellAttribute& forAttribute) const override;
  // const vtkCellAttribute& GetShapeAttribute() const override;
  // std::set<std::reference_wrapper<vtkCellAttribute>> GetGridAttributes() const override;

protected:
  vtkDGHex();
  ~vtkDGHex() override;

private:
  vtkDGHex(const vtkDGHex&) = delete;
  void operator=(const vtkDGHex&) = delete;
};

#endif
