/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDGHex.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkDGHex.h"

#include "vtkCellGrid.h"
#include "vtkCellAttribute.h"
#include "vtkDataSetAttributes.h"
#include "vtkObjectFactory.h"
#include "vtkStringToken.h"

using namespace vtk::literals;

vtkStandardNewMacro(vtkDGHex);

// TODO: Use IMPLEMENTABLE/IMPLEMENTS and vtkObjectFactory or equivalent.
static bool registerType = vtkCellMetadata::RegisterType<vtkDGHex>();

vtkDGHex::vtkDGHex() = default;
vtkDGHex::~vtkDGHex() = default;

void vtkDGHex::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

vtkIdType vtkDGHex::GetNumberOfCells()
{
  auto* dsa = this->CellGrid->GetAttributes("DGHex"_token);
  return dsa ? dsa->GetNumberOfTuples() : 0;
}

#if 0
std::set<vtkCellMetadata::DOFType> vtkDGHex::RequiredDOFs(const vtkCellAttribute& forAttribute) const
{
  (void)forAttribute;
  std::set<DOFType> result;
  return result;
}

const vtkCellAttribute& vtkDGHex::GetShapeAttribute() const
{
  static vtkCellAttribute dummy;
  return dummy;
}

std::set<std::reference_wrapper<vtkCellAttribute>> vtkDGHex::GetGridAttributes() const
{
  std::set<std::reference_wrapper<vtkCellAttribute>> result;
  return result;
}
#endif // 0
