/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkCellGridSidesQuery.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkCellGridSidesQuery.h"

#include "vtkBoundingBox.h"
#include "vtkObjectFactory.h"
#include "vtkMath.h"

vtkStandardNewMacro(vtkCellGridSidesQuery);

void vtkCellGridSidesQuery::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
  os << indent << "Hashes: " << this->Hashes.size() << "\n";
  os << indent << "Sides: " << this->Sides.size() << "\n";
}

void vtkCellGridSidesQuery::Initialize()
{
  this->Hashes.clear();
}

void vtkCellGridSidesQuery::Finalize()
{
  this->Sides.clear();
  for (const auto& entry : this->Hashes)
  {
    if (entry.second.Sides.size() % 2 == 0)
    {
      continue; // Do not output faces with matching pairs of sides.
    }
    for (const auto& ss : entry.second.Sides)
    {
      this->Sides[ss.DOF].insert(ss.SideId);
    }
  }
}
