/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkCellGridResponder.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkCellGridResponderBase
 * @brief   Respond to a query on one particular type of cell.
 *
 * This is pure virtual base class that all responder types must inherit.
 */

#ifndef vtkCellGridResponderBase_h
#define vtkCellGridResponderBase_h

#include "vtkCommonDataModelModule.h" // For export macro
#include "vtkObject.h"

class vtkCellGridQuery;
class vtkCellMetadata;
class vtkCellGridResponders;

class VTKCOMMONDATAMODEL_EXPORT vtkCellGridResponderBase : public vtkObject
{
public:
  vtkTypeMacro(vtkCellGridResponderBase, vtkObject);

  /// Respond to the \a query for cells of \a cellType, possibly using \a caches.
  virtual bool EvaluateQuery(vtkCellGridQuery* query, vtkCellMetadata* cellType, vtkCellGridResponders* caches) = 0;

protected:
  vtkCellGridResponderBase() = default;
  ~vtkCellGridResponderBase() override = default;

private:
  vtkCellGridResponderBase(const vtkCellGridResponderBase&) = delete;
  void operator=(const vtkCellGridResponderBase&) = delete;
};

#endif // vtkCellGridResponderBase_h
