/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkCellGridQuery.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkCellGridQuery
 * @brief   Perform an operation on cells in a vtkCellMetadata instance.
 *
 * This is an empty base class that all query types must inherit.
 */

#ifndef vtkCellGridQuery_h
#define vtkCellGridQuery_h

#include "vtkCommonDataModelModule.h" // For export macro
#include "vtkObject.h"

class VTKCOMMONDATAMODEL_EXPORT vtkCellGridQuery : public vtkObject
{
public:
  vtkTypeMacro(vtkCellGridQuery, vtkObject);

  /// Override this if your query-result state requires initialization.
  virtual void Initialize() { }

  /// Override this if your query-result state requires finalization.
  virtual void Finalize() { }

protected:
  vtkCellGridQuery() = default;
  ~vtkCellGridQuery() override = default;

private:
  vtkCellGridQuery(const vtkCellGridQuery&) = delete;
  void operator=(const vtkCellGridQuery&) = delete;
};

#endif // vtkCellGridQuery_h
