/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkTypeName.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkTypeName_h
#define vtkTypeName_h

#include "vtkCxxABIConfigure.h"

#include <string>

namespace vtk
{
namespace detail
{

template<typename ObjectType>
struct Name
{
  inline static std::string value()
  {
    std::string result = typeid(ObjectType).name();
#ifdef VTK_HAS_CXXABI_DEMANGLE
    int status = 0;
    std::size_t size = 0;
    char* demangledSymbol = abi::__cxa_demangle(result.c_str(), nullptr, &size, &status);
    if (!status && size > 0)
    {
      result = demangledSymbol;
    }
    free(demangledSymbol);
#endif
#ifdef VTK_COMPILER_MSVC
    // MSVC returns a name with "class " prepended. Remove it
    // for consistency with other platforms.
    if (result.substr(0, 6) == "class ")
    {
      result = result.substr(6);
    }
#endif
    return result;
  }
};

} // namespace detail

/**
 * Return the demangled type-name of the provided \a ObjectType.
 *
 * Note that if the `<cxxabi.h>` header is not present or does
 * not provide `abi::__cxa_demangle()`, a mangled name will be
 * returned.
 */
template<typename ObjectType>
inline std::string TypeName()
{
  return detail::Name<ObjectType>::value();
}

} // namespace vtk

#endif // vtkTypeName_h

// VTK-HeaderTest-Exclude: vtkTypeName.h
