//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#include "smtk/simulation/truchas/plugin/pqSMTKTruchasExtensionsAutoStart.h"

#include "smtk/simulation/truchas/plugin/smtkTruchasCoilsView.h"
#include "smtk/simulation/truchas/plugin/smtkTruchasMaterialsView.h"
#include "smtk/simulation/truchas/qt/qtPhasePropertyItem.h"

#include "smtk/extension/qt/qtSMTKUtilities.h"

pqSMTKTruchasExtensionsAutoStart::pqSMTKTruchasExtensionsAutoStart(QObject* parent)
  : Superclass(parent)
{
}

pqSMTKTruchasExtensionsAutoStart::~pqSMTKTruchasExtensionsAutoStart()
{
}

void pqSMTKTruchasExtensionsAutoStart::startup()
{
  // Register custom view constructors
  qtSMTKUtilities::registerViewConstructor(
    "smtkTruchasCoilsView", smtkTruchasCoilsView::createViewWidget);
  qtSMTKUtilities::registerViewConstructor(
    "smtkTruchasMaterialsView", smtkTruchasMaterialsView::createViewWidget);

  qtSMTKUtilities::registerItemConstructor(
    "TruchasPhaseProperty", qtPhasePropertyItem::createItemWidget);
}

void pqSMTKTruchasExtensionsAutoStart::shutdown()
{
}
