<SMTK_AttributeResource Version="3">
  <Categories>
    <Cat>Fluid Flow</Cat>
    <Cat>Heat Transfer</Cat>
    <Cat>Induction Heating</Cat>
  </Categories>
  <!-- Attribute Definitions-->
  <Definitions>
    <AttDef Type="background-material" Label="Default Material" BaseType="" Version="0" Unique="true">
      <Categories>
        <Cat>Fluid Flow</Cat>
        <Cat>Heat Transfer</Cat>
      </Categories>
      <BriefDescription>Material to use to fill any portion of the mesh not explicitlydefined in the "Body" namelists.</BriefDescription>
      <ItemDefinitions>
        <Component Name="background-material" Label="Select" NumberOfRequiredValues="1" Unique="true" Version="1">
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='material']"/>
          </Accepts>
        </Component>
      </ItemDefinitions>
    </AttDef>
    <!-- Common base class for "real" and "void" materials-->
    <AttDef Type="material" BaseType="" Abstract="true" Unique="true">
      <AssociationsDef Name="MaterialAssociations" Version="0" NumberOfRequiredValues="0" Extensible="true">
        <MembershipMask>volume</MembershipMask>
      </AssociationsDef>
    </AttDef>
    <AttDef Type="material.void" BaseType="material" Label="Void" Version="0">
      <Categories>
        <Cat>Fluid Flow</Cat>
        <Cat>Heat Transfer</Cat>
      </Categories>
      <ItemDefinitions>
        <Double Name="void-temperature" Label="Temperature">
          <DefaultValue>0.0</DefaultValue>
        </Double>
        <Double Name="sound-speed" Label="Speed of Sound" AdvanceLevel="1">
          <BriefDescription>| The adiabatic sound speed that is used in computing thecompressibility of each cell containing the material.
This is not a real sound speed, but a numerical artifice
used to permit collapse of small void bubbles.</BriefDescription>
          <DefaultValue>0.0</DefaultValue>
        </Double>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="material.real" BaseType="material" Label="Material" RootName="Material" Version="0">
      <ItemDefinitions>
        <Group Name="shared-properties" Label="Shared Properties" Version="0">
          <ItemDefinitions>
            <Double Name="density" Label="Density (rho)" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Mass density of the material phase</BriefDescription>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="density-deviation" Label="Density Deviation" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>The relative deviation of the true temperature-dependent
density from the reference density</BriefDescription>
              <ExpressionType>fn.material.density-deviation</ExpressionType>
            </Double>
            <Double Name="conductivity" Label="Conductivity (K)" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Thermal conductivity of the material phase</BriefDescription>
              <ExpressionType>fn.material.conductivity</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="specific-heat" Label="Specific Heat (Cp)" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Specific heat of the material phase</BriefDescription>
              <ExpressionType>fn.material.specific-heat</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="viscosity" Label="Viscosity (nu)" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>The dynamic viscosity of a fluid phase</BriefDescription>
              <ExpressionType>fn.material.viscosity</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="electrical-conductivity" Label="Electrical Conductivity" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Induction Heating</Cat>
              </Categories>
              <DefaultValue>0.0</DefaultValue>
            </Double>
            <Double Name="electrical-susceptibility" Label="Electrical Susceptibility" AdvanceLevel="1" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Induction Heating</Cat>
              </Categories>
              <DefaultValue>0.0</DefaultValue>
            </Double>
            <Double Name="magnetic-susceptibility" Label="Magnetic Susceptibility" AdvanceLevel="1" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Induction Heating</Cat>
              </Categories>
              <DefaultValue>0.0</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
        <Group Name="phases" Label="Phases" Extensible="true" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <String Name="name" Label="Name">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
            </String>
            <Double Name="density" Label="Density (rho)" Optional="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Mass density of the material phase</BriefDescription>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="conductivity" Label="Conductivity (K)">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Thermal conductivity of the material phase</BriefDescription>
              <ExpressionType>fn.material.conductivity</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="specific-heat" Label="Specific Heat (Cp)">
              <Categories>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <BriefDescription>Specific heat of the material phase</BriefDescription>
              <ExpressionType>fn.material.specific-heat</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Group Name="fluid" Label="Fluid" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Heat Transfer</Cat>
              </Categories>
              <ItemDefinitions>
                <Double Name="density-deviation" Label="Density Deviation" Optional="true" IsEnabledByDefault="false">
                  <Categories>
                    <Cat>Fluid Flow</Cat>
                  </Categories>
                  <BriefDescription>The relative deviation of the true temperature-dependent
density from the reference density</BriefDescription>
                  <ExpressionType>fn.material.density-deviation</ExpressionType>
                </Double>
                <Double Name="viscosity" Label="Viscosity (nu)">
                  <BriefDescription>The dynamic viscosity of a fluid phase</BriefDescription>
                  <Categories>
                    <Cat>Fluid Flow</Cat>
                  </Categories>
                  <ExpressionType>fn.material.viscosity</ExpressionType>
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="electrical-properties" Label="Electrical Properties">
              <Categories>
                <Cat>Induction Heating</Cat>
              </Categories>
              <ItemDefinitions>
                <Double Name="electrical-conductivity" Label="Electrical Conductivity">
                  <DefaultValue>0.0</DefaultValue>
                </Double>
                <Double Name="electrical-susceptibility" Label="Electrical Susceptibility" AdvanceLevel="1">
                  <DefaultValue>0.0</DefaultValue>
                </Double>
                <Double Name="magnetic-susceptibility" Label="Magnetic Susceptibility" AdvanceLevel="1">
                  <DefaultValue>0.0</DefaultValue>
                </Double>
              </ItemDefinitions>
            </Group>
          </ItemDefinitions>
        </Group>
        <Group Name="transitions" Label="Transitions" Extensible="true" NumberOfRequiredGroups="0">
          <Categories>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
          </Categories>
          <ItemDefinitions>
            <Double Name="latent-heat" Label="Latent Heat (Lf)">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="lower-transition-temperature" Label="Low Transition Temperature (Ts)"/>
            <Double Name="upper-transition-temperature" Label="High Transition Temperature (Tl)"/>
            <Double Name="smoothing-radius" Label="Smoothing Radius" NumberOfRequiredValues="1" Version="0">
              <BriefDescription>The transition smoothing function. Default 0.25 times delta T.</BriefDescription>
              <DefaultValue>0.0</DefaultValue>
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
            </Double>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="phase" BaseType="" Abstract="true" Unique="true">
      <AssociationsDef Name="MaterialAssociations" Version="0" NumberOfRequiredValues="0" Extensible="true">
        <MembershipMask>volume</MembershipMask>
      </AssociationsDef>
    </AttDef>
    <AttDef Type="phase.void" BaseType="phase" Label="Void" Version="0">
      <Categories>
        <Cat>Fluid Flow</Cat>
        <Cat>Heat Transfer</Cat>
      </Categories>
      <ItemDefinitions>
        <Double Name="void-temperature" Label="Temperature">
          <DefaultValue>0.0</DefaultValue>
        </Double>
        <Double Name="sound-speed" Label="Speed of Sound" AdvanceLevel="1">
          <BriefDescription>| The adiabatic sound speed that is used in computing thecompressibility of each cell containing the material.
This is not a real sound speed, but a numerical artifice
used to permit collapse of small void bubbles.</BriefDescription>
          <DefaultValue>0.0</DefaultValue>
        </Double>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="phase.material" BaseType="phase" Label="Phase" Version="0">
      <ItemDefinitions>
        <Double Name="density" Label="Density (rho)" Optional="false">
          <Categories>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
          </Categories>
          <BriefDescription>Mass density of the material phase</BriefDescription>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
        </Double>
        <Double Name="conductivity" Label="Conductivity (K)">
          <Categories>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
          </Categories>
          <BriefDescription>Thermal conductivity of the material phase</BriefDescription>
          <ExpressionType>fn.material.conductivity</ExpressionType>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
        </Double>
        <Double Name="specific-heat" Label="Specific Heat (Cp)">
          <Categories>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
          </Categories>
          <BriefDescription>Specific heat of the material phase</BriefDescription>
          <ExpressionType>fn.material.specific-heat</ExpressionType>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
        </Double>
        <Group Name="fluid" Label="Fluid" Optional="true" IsEnabledByDefault="false">
          <Categories>
            <Cat>Heat Transfer</Cat>
          </Categories>
          <ItemDefinitions>
            <Double Name="density-deviation" Label="Density Deviation" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Fluid Flow</Cat>
              </Categories>
              <BriefDescription>The relative deviation of the true temperature-dependent
density from the reference density</BriefDescription>
              <ExpressionType>fn.material.density-deviation</ExpressionType>
            </Double>
            <Double Name="viscosity" Label="Viscosity (nu)">
              <BriefDescription>The dynamic viscosity of a fluid phase</BriefDescription>
              <Categories>
                <Cat>Fluid Flow</Cat>
              </Categories>
              <ExpressionType>fn.material.viscosity</ExpressionType>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
          </ItemDefinitions>
        </Group>
        <Group Name="electrical-properties" Label="Electrical Properties">
          <Categories>
            <Cat>Induction Heating</Cat>
          </Categories>
          <ItemDefinitions>
            <Double Name="electrical-conductivity" Label="Electrical Conductivity">
              <DefaultValue>0.0</DefaultValue>
            </Double>
            <Double Name="electrical-susceptibility" Label="Electrical Susceptibility" AdvanceLevel="1">
              <DefaultValue>0.0</DefaultValue>
            </Double>
            <Double Name="magnetic-susceptibility" Label="Magnetic Susceptibility" AdvanceLevel="1">
              <DefaultValue>0.0</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="phase-transition" BaseType="" Label="Phase Transition" Version="0">
      <Categories>
        <Cat>Fluid Flow</Cat>
        <Cat>Heat Transfer</Cat>
      </Categories>
      <ItemDefinitions>
        <Component Name="lower" Label="Low-Temperature phase" NumberOfRequiredValues="1">
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='phase.material']"/>
          </Accepts>
        </Component>
        <Double Name="latent-heat" Label="Latent Heat (Lf)">
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
        </Double>
        <Double Name="lower-transition-temperature" Label="Low Transition Temperature (Ts)"/>
        <Double Name="upper-transition-temperature" Label="High Transition Temperature (Tl)"/>
        <Double Name="smoothing-radius" Label="Smoothing Radius" NumberOfRequiredValues="1" Version="0">
          <BriefDescription>The transition smoothing function. Default 0.25 times delta T.</BriefDescription>
          <DefaultValue>0.0</DefaultValue>
          <RangeInfo>
            <Min Inclusive="true">0.0</Min>
          </RangeInfo>
        </Double>
        <Component Name="upper" Label="High-Temperature Phase" NumberOfRequiredValues="1">
          <Accepts>
            <Resource Name="smtk::attribute::Resource" Filter="attribute[type='phase.material']"/>
          </Accepts>
        </Component>
      </ItemDefinitions>
    </AttDef>
  </Definitions>
</SMTK_AttributeResource>
