//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#pragma once

#include "smtk/model/Tessellation.h"

#include "nlohmann/json.hpp"

#include <string>

// Override how Tessellations are serialized.
namespace nlohmann
{
  template<>
  struct adl_serializer<smtk::model::Tessellation>
  {
    using Tessellation = smtk::model::Tessellation;
    using UUID = smtk::common::UUID;

    static void to_json(json& j, const Tessellation& tess)
    {
      if (tess.coords().empty() && tess.conn().empty()) {
        j = nullptr;
      } else {
        j = {
          { "metadata",
            { "formatVersion", "3" } },
          { "vertices", tess.coords() },
          { "faces", tess.conn() }
        };
      }
    }

    static void from_json(const json& j, Tessellation& tess)
    {
      tess.reset();
      if (!j.is_null()) {
        tess.coords() = j["vertices"].get<std::vector<double>>();
        tess.conn() = j["faces"].get<std::vector<int>>();
      }
    }
  };
}
