<?xml version="1.0" encoding="utf-8" ?>
<!-- Description of the polygon "ForceCreateFace" operator -->
<SMTK_AttributeSystem Version="2">
  <Definitions>
    <!-- Operator -->
    <AttDef Type="force create face" BaseType="operator">
      <BriefDescription>Create a model face without sanity checks.</BriefDescription>
      <DetailedDescription>
        Create a model face from a sequence of points holding an outer loop and 
        zero or more inner loops. Each loop will become a single edge.
      </DetailedDescription>

      <AssociationsDef Name="model" NumberOfRequiredValues="1" Extensible="yes">
        <MembershipMask>model</MembershipMask>
        <BriefDescription>The model to which faces should be added.</BriefDescription>
        <DetailedDescription>
          The model to which faces should be added; this must be a polygon-session model.
        </DetailedDescription>
      </AssociationsDef>
      <ItemDefinitions>
        <Double Name="points" NumberOfRequiredValues="6" Extensible="yes">
          <BriefDescription>The (x,y,z) coordinates of the face points.</BriefDescription>
          <DetailedDescription>
            The world coordinates of 3 or more points forming 1 or more faces.
            Multiple faces may be created by specifying "offsets".
            If the default offsets are used, all points are assumed to be
            on the outer loop of a single face.

            If only 2 coordinates are specified per point, the third is assumed to be 0.
            Be sure to set the value of the coordinates item as required.
          </DetailedDescription>
        </Double>
        <Int Name="coordinates" NumberOfRequiredValues="1">
          <BriefDescription>The number of coordinates per vertex.</BriefDescription>
          <DetailedDescription>
            Specify whether 2 or 3 coordinates are provided per vertex.
            When set to 2, the third coordinate is assumed to be 0 for all points.
          </DetailedDescription>
          <DefaultValue>2</DefaultValue>
          <RangeInfo>
            <Min Inclusive="true">2</Min>
            <Max Inclusive="true">3</Max>
          </RangeInfo>
        </Int>
        <Int Name="offsets" NumberOfRequiredValues="1" Extensible="true">
          <DefaultValue>0</DefaultValue>
          <BriefDescription>Offsets into the list of points where the face or its holes start.</BriefDescription>
          <DetailedDescription>
            Offsets into the list of points where the face or its holes start.

            The first number specifies an offset into the list of points
            for the first face's outer loop. It should be 0.
            This is followed by an integer offset for each hole.
          </DetailedDescription>
        </Int>
      </ItemDefinitions>
    </AttDef>
    <!-- Result -->
    <AttDef Type="result(force create face)" BaseType="result">
      <ItemDefinitions>
        <!-- The faces created are reported in the base result's "created" item. -->
      </ItemDefinitions>
    </AttDef>
  </Definitions>
</SMTK_AttributeSystem>
