//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtkRGGSelectionBehavior_h
#define smtkRGGSelectionBehavior_h

#include "smtk/session/rgg/plugin/Exports.h"

#include "smtk/PublicPointerDefs.h"
#include "smtk/model/EntityTypeBits.h"

#include "smtk/view/SelectionObserver.h"

#include <QObject>

#include <string>

class vtkSMSMTKWrapperProxy;
class pqPipelineSource;
class pqServer;
class pqSMTKWrapper;

/**\brief Keep the ParaView pipeline browser and SMTK selections in sync.
  *
  * When the SMTK selection is updated and contains resources (as opposed
  * to components), select those resources in the pipeline browser.
  * Similarly, when pipeline sources in ParaView are selected, replace
  * the SMTK selection with the related resources.
  */
class smtkRGGSelectionBehavior : public QObject
{
  Q_OBJECT
  using Superclass = QObject;

public:
  smtkRGGSelectionBehavior(QObject* parent = nullptr);
  ~smtkRGGSelectionBehavior() override;

  /// This behavior is a singleton.
  static smtkRGGSelectionBehavior* instance(QObject* parent = nullptr);

  /// Set which integer bit(s) to modify in the SMTK selection when a pipeline source is selected.
  void setSelectionValue(const std::string& selectionValue);
  const std::string& selectionValue() const { return m_selectionValue; }

protected slots:
  virtual void onActiveSourceChanged(pqPipelineSource* source);
  virtual void observeSelectionOnServer(pqSMTKWrapper* mgr, pqServer* server);
  virtual void unobserveSelectionOnServer(pqSMTKWrapper* mgr, pqServer* server);

protected:
  bool m_changingSource;
  std::string m_selectionValue;
  std::map<smtk::view::SelectionPtr, smtk::view::SelectionObservers::Key> m_selectionObservers;

private:
  Q_DISABLE_COPY(smtkRGGSelectionBehavior);
};

#endif
