//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME smtkRGGRemoveMaterialView - UI component for Remove RGG pins
// .SECTION Description
// .SECTION See Also
// qtSection

#ifndef smtkRGGRemoveMaterialView_h
#define smtkRGGRemoveMaterialView_h

#include "smtk/extension/qt/qtOperationView.h"
#include "smtk/session/rgg/operators/RemoveMaterial.h"
#include "smtk/session/rgg/plugin/Exports.h"

class QColor;
class QComboBox;
class QIcon;
class QString;
namespace smtk
{
namespace extension
{
class qtItem;
}
}
class smtkRGGRemoveMaterialViewInternals;

class smtkRGGRemoveMaterialView : public smtk::extension::qtBaseAttributeView
{
  Q_OBJECT

public:
  smtkTypenameMacro(smtkRGGRemoveMaterialView);
  smtkRGGRemoveMaterialView(const smtk::view::Information& info);
  virtual ~smtkRGGRemoveMaterialView();
  const smtk::operation::OperationPtr& operation() const;

  static smtk::extension::qtBaseView* createViewWidget(const smtk::view::Information& info);

public slots:
  void requestModelEntityAssociation() override;
  void onShowCategory() override { this->updateUI(); }
  void valueChanged(smtk::attribute::ItemPtr optype) override;

protected slots:
  virtual void requestOperation(const smtk::operation::OperationPtr& op);

  // This slot is used to indicate that the underlying attribute
  // for the operation should be checked for validity
  virtual void attributeModified();
  bool ableToOperate();
  void apply();

protected:
  void updateUI() override;
  void createWidget() override;
  void updateRemoveMaterialPanel();
  virtual void setInfoToBeDisplayed() override;
  void setupMaterialComboBox(QComboBox* box);

private:
  smtkRGGRemoveMaterialViewInternals* Internals;
};

#endif // smtkRGGRemoveMaterialView_h
