# Requirements and Design Documents

This directory hosts ideas, requests and discussions regarding
Parflow. The goal is to document new feature proposals and how the
impact the code base to improve communication within the Parflow
community.

Changes which should definitely have design documents:

* Changes which will significantly impact users and their workflow
* Reworking essential parts of the Parflow framework
* Introduce major new features

Small contributions, bug fixes and low-impact changes may be posed
directly via the Parflow GitHub issue tracker and pull request.


## Contributing a design document for review

1. Copy the file `0000-template.md` to a file with a new number and meaningful sort name.
2. Fill in the template.
3. Open a pull request with the proposal.
4. Discussion takes place in the pull request for the design document.
5. When a decision is reached, the RFC is merged into the repository.

# Reviewing

The status of a document is one of the following, starting with awaiting when created:

* **awaiting:** Awaiting review.
* **active:** Currently under review.
* **accepted:** Accepted RFC that has not been implemented.
* **implemented:** Accepted and implemented.
* **rejected:** Rejected by the review process.
* **withdrawn:** Withdrawn by the proposer.

