//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef plugin_pqWindTunnelAutoStart_h
#define plugin_pqWindTunnelAutoStart_h

#include <QObject>

class pqServer;
class pqSMTKWrapper;

class pqWindTunnelAutoStart : public QObject
{
  Q_OBJECT
  using Superclass = QObject;

public:
  pqWindTunnelAutoStart(QObject* parent = nullptr);
  ~pqWindTunnelAutoStart() = default;

  void startup();
  void shutdown();

protected Q_SLOTS:
  void resourceManagerAdded(pqSMTKWrapper* mgr, pqServer* server);
  void resourceManagerRemoved(pqSMTKWrapper* mgr, pqServer* server);

  /** \brief Initializes things that need main widget */
  void waitForMainWidget();

protected:
  void initializeSettings(pqServer* server);

private:
  Q_DISABLE_COPY(pqWindTunnelAutoStart);
};

#endif
