include(CMakePackageConfigHelpers)

# Our requirements for a version file are basic, so we use CMake's basic version
# file generator
write_basic_package_version_file(
  "${CMAKE_CMAKE_OUTPUT_DIRECTORY}/${PROJECT_NAME}ConfigVersion.cmake"
  VERSION ${${PROJECT_NAME}_VERSION}
  COMPATIBILITY AnyNewerVersion
)

# Export the targets generated by the plugin
export(
  EXPORT OpencascadeSession
  FILE "${CMAKE_CMAKE_OUTPUT_DIRECTORY}/${PROJECT_NAME}Targets.cmake")
install(
  EXPORT OpencascadeSession
  DESTINATION ${CMAKE_INSTALL_CMAKEDIR}
  FILE ${PROJECT_NAME}Targets.cmake
)

configure_file(
  "${CMAKE_CURRENT_LIST_DIR}/${PROJECT_NAME}Config.cmake.in"
  "${CMAKE_CMAKE_OUTPUT_DIRECTORY}/${PROJECT_NAME}Config.cmake"
  @ONLY)

# Install the generated configure files
install(
  FILES
    "${CMAKE_CMAKE_OUTPUT_DIRECTORY}/${PROJECT_NAME}Config.cmake"
    "${CMAKE_CMAKE_OUTPUT_DIRECTORY}/${PROJECT_NAME}ConfigVersion.cmake"
  DESTINATION
    ${CMAKE_INSTALL_CMAKEDIR}
  COMPONENT
    Devel
)
