/*
 * This file is part of LibCSS.
 * Licensed under the MIT License,
 *                http://www.opensource.org/licenses/mit-license.php
 * Copyright 2008 John-Mark Bell <jmb@netsurf-browser.org>
 */

#include "parse/properties/properties.h"

/**
 * Dispatch table of property handlers, indexed by property enum
 */
const css_prop_handler property_handlers[LAST_PROP + 1 - FIRST_PROP] =
{
	css__parse_align_content,
	css__parse_align_items,
	css__parse_align_self,
	css__parse_azimuth,
	css__parse_background,
	css__parse_background_attachment,
	css__parse_background_color,
	css__parse_background_image,
	css__parse_background_position,
	css__parse_background_repeat,
	css__parse_border,
	css__parse_border_bottom,
	css__parse_border_bottom_color,
	css__parse_border_bottom_style,
	css__parse_border_bottom_width,
	css__parse_border_collapse,
	css__parse_border_color,
	css__parse_border_left,
	css__parse_border_left_color,
	css__parse_border_left_style,
	css__parse_border_left_width,
	css__parse_border_right,
	css__parse_border_right_color,
	css__parse_border_right_style,
	css__parse_border_right_width,
	css__parse_border_spacing,
	css__parse_border_style,
	css__parse_border_top,
	css__parse_border_top_color,
	css__parse_border_top_style,
	css__parse_border_top_width,
	css__parse_border_width,
	css__parse_bottom,
	css__parse_box_sizing,
	css__parse_break_after,
	css__parse_break_before,
	css__parse_break_inside,
	css__parse_caption_side,
	css__parse_clear,
	css__parse_clip,
	css__parse_color,
	css__parse_color_by_array,
	css__parse_color_by_mode,
	css__parse_columns,
	css__parse_column_count,
	css__parse_column_fill,
	css__parse_column_gap,
	css__parse_column_rule,
	css__parse_column_rule_color,
	css__parse_column_rule_style,
	css__parse_column_rule_width,
	css__parse_column_span,
	css__parse_column_width,
	css__parse_content,
	css__parse_counter_increment,
	css__parse_counter_reset,
	css__parse_cue,
	css__parse_cue_after,
	css__parse_cue_before,
	css__parse_cursor,
	css__parse_direction,
	css__parse_display,
	css__parse_elevation,
	css__parse_empty_cells,
	css__parse_flex,
	css__parse_flex_basis,
	css__parse_flex_direction,
	css__parse_flex_flow,
	css__parse_flex_grow,
	css__parse_flex_shrink,
	css__parse_flex_wrap,
	css__parse_float,
	css__parse_font,
	css__parse_font_family,
	css__parse_font_size,
	css__parse_font_style,
	css__parse_font_variant,
	css__parse_font_weight,
	css__parse_height,
	css__parse_justify_content,
	css__parse_left,
	css__parse_letter_spacing,
	css__parse_line_height,
	css__parse_list_style,
	css__parse_list_style_image,
	css__parse_list_style_position,
	css__parse_list_style_type,
	css__parse_margin,
	css__parse_margin_bottom,
	css__parse_margin_left,
	css__parse_margin_right,
	css__parse_margin_top,
	css__parse_max_height,
	css__parse_max_width,
	css__parse_min_height,
	css__parse_min_width,
	css__parse_opacity,
	css__parse_order,
	css__parse_orphans,
	css__parse_outline,
	css__parse_outline_color,
	css__parse_outline_style,
	css__parse_outline_width,
	css__parse_overflow,
	css__parse_overflow_x,
	css__parse_overflow_y,
	css__parse_padding,
	css__parse_padding_bottom,
	css__parse_padding_left,
	css__parse_padding_right,
	css__parse_padding_top,
	css__parse_page_break_after,
	css__parse_page_break_before,
	css__parse_page_break_inside,
	css__parse_pause,
	css__parse_pause_after,
	css__parse_pause_before,
	css__parse_pitch_range,
	css__parse_pitch,
	css__parse_play_during,
	css__parse_position,
	css__parse_quotes,
	css__parse_representation,
	css__parse_richness,
	css__parse_right,
	css__parse_speak_header,
	css__parse_speak_numeral,
	css__parse_speak_punctuation,
	css__parse_speak,
	css__parse_speech_rate,
	css__parse_stress,
	css__parse_table_layout,
	css__parse_text_align,
	css__parse_text_decoration,
	css__parse_text_indent,
	css__parse_text_transform,
	css__parse_top,
	css__parse_unicode_bidi,
	css__parse_vertical_align,
	css__parse_visibility,
	css__parse_voice_family,
	css__parse_volume,
	css__parse_white_space,
	css__parse_widows,
	css__parse_width,
	css__parse_word_spacing,
	css__parse_writing_mode,
	css__parse_z_index
};

/** Mapping from property bytecode index to bytecode unit class mask. */
const uint32_t property_unit_mask[CSS_N_PROPERTIES] = {
	[CSS_PROP_AZIMUTH]               = UNIT_MASK_AZIMUTH,
	[CSS_PROP_BACKGROUND_ATTACHMENT] = UNIT_MASK_BACKGROUND_ATTACHMENT,
	[CSS_PROP_BACKGROUND_COLOR]      = UNIT_MASK_BACKGROUND_COLOR,
	[CSS_PROP_BACKGROUND_IMAGE]      = UNIT_MASK_BACKGROUND_IMAGE,
	[CSS_PROP_BACKGROUND_POSITION]   = UNIT_MASK_BACKGROUND_POSITION,
	[CSS_PROP_BACKGROUND_REPEAT]     = UNIT_MASK_BACKGROUND_REPEAT,
	[CSS_PROP_BORDER_COLLAPSE]       = UNIT_MASK_BORDER_COLLAPSE,
	[CSS_PROP_BORDER_SPACING]        = UNIT_MASK_BORDER_SPACING,
	[CSS_PROP_BORDER_TOP_COLOR]      = UNIT_MASK_BORDER_SIDE_COLOR,
	[CSS_PROP_BORDER_RIGHT_COLOR]    = UNIT_MASK_BORDER_SIDE_COLOR,
	[CSS_PROP_BORDER_BOTTOM_COLOR]   = UNIT_MASK_BORDER_SIDE_COLOR,
	[CSS_PROP_BORDER_LEFT_COLOR]     = UNIT_MASK_BORDER_SIDE_COLOR,
	[CSS_PROP_BORDER_TOP_STYLE]      = UNIT_MASK_BORDER_SIDE_STYLE,
	[CSS_PROP_BORDER_RIGHT_STYLE]    = UNIT_MASK_BORDER_SIDE_STYLE,
	[CSS_PROP_BORDER_BOTTOM_STYLE]   = UNIT_MASK_BORDER_SIDE_STYLE,
	[CSS_PROP_BORDER_LEFT_STYLE]     = UNIT_MASK_BORDER_SIDE_STYLE,
	[CSS_PROP_BORDER_TOP_WIDTH]      = UNIT_MASK_BORDER_SIDE_WIDTH,
	[CSS_PROP_BORDER_RIGHT_WIDTH]    = UNIT_MASK_BORDER_SIDE_WIDTH,
	[CSS_PROP_BORDER_BOTTOM_WIDTH]   = UNIT_MASK_BORDER_SIDE_WIDTH,
	[CSS_PROP_BORDER_LEFT_WIDTH]     = UNIT_MASK_BORDER_SIDE_WIDTH,
	[CSS_PROP_BOTTOM]                = UNIT_MASK_BOTTOM,
	[CSS_PROP_CAPTION_SIDE]          = UNIT_MASK_CAPTION_SIDE,
	[CSS_PROP_CLEAR]                 = UNIT_MASK_CLEAR,
	[CSS_PROP_CLIP]                  = UNIT_MASK_CLIP,
	[CSS_PROP_COLOR]                 = UNIT_MASK_COLOR,
	[CSS_PROP_COLOR_BY_ARRAY]        = UNIT_MASK_COLOR_BY_ARRAY,
	[CSS_PROP_COLOR_BY_MODE]         = UNIT_MASK_COLOR_BY_MODE,
	[CSS_PROP_CONTENT]               = UNIT_MASK_CONTENT,
	[CSS_PROP_COUNTER_INCREMENT]     = UNIT_MASK_COUNTER_INCREMENT,
	[CSS_PROP_COUNTER_RESET]         = UNIT_MASK_COUNTER_RESET,
	[CSS_PROP_CUE_AFTER]             = UNIT_MASK_CUE_AFTER,
	[CSS_PROP_CUE_BEFORE]            = UNIT_MASK_CUE_BEFORE,
	[CSS_PROP_CURSOR]                = UNIT_MASK_CURSOR,
	[CSS_PROP_DIRECTION]             = UNIT_MASK_DIRECTION,
	[CSS_PROP_DISPLAY]               = UNIT_MASK_DISPLAY,
	[CSS_PROP_ELEVATION]             = UNIT_MASK_ELEVATION,
	[CSS_PROP_EMPTY_CELLS]           = UNIT_MASK_EMPTY_CELLS,
	[CSS_PROP_FLOAT]                 = UNIT_MASK_FLOAT,
	[CSS_PROP_FONT_FAMILY]           = UNIT_MASK_FONT_FAMILY,
	[CSS_PROP_FONT_SIZE]             = UNIT_MASK_FONT_SIZE,
	[CSS_PROP_FONT_STYLE]            = UNIT_MASK_FONT_STYLE,
	[CSS_PROP_FONT_VARIANT]          = UNIT_MASK_FONT_VARIANT,
	[CSS_PROP_FONT_WEIGHT]           = UNIT_MASK_FONT_WEIGHT,
	[CSS_PROP_HEIGHT]                = UNIT_MASK_HEIGHT,
	[CSS_PROP_LEFT]                  = UNIT_MASK_LEFT,
	[CSS_PROP_LETTER_SPACING]        = UNIT_MASK_LETTER_SPACING,
	[CSS_PROP_LINE_HEIGHT]           = UNIT_MASK_LINE_HEIGHT,
	[CSS_PROP_LIST_STYLE_IMAGE]      = UNIT_MASK_LIST_STYLE_IMAGE,
	[CSS_PROP_LIST_STYLE_POSITION]   = UNIT_MASK_LIST_STYLE_POSITION,
	[CSS_PROP_LIST_STYLE_TYPE]       = UNIT_MASK_LIST_STYLE_TYPE,
	[CSS_PROP_MARGIN_TOP]            = UNIT_MASK_MARGIN_SIDE,
	[CSS_PROP_MARGIN_RIGHT]          = UNIT_MASK_MARGIN_SIDE,
	[CSS_PROP_MARGIN_BOTTOM]         = UNIT_MASK_MARGIN_SIDE,
	[CSS_PROP_MARGIN_LEFT]           = UNIT_MASK_MARGIN_SIDE,
	[CSS_PROP_MAX_HEIGHT]            = UNIT_MASK_MAX_HEIGHT,
	[CSS_PROP_MAX_WIDTH]             = UNIT_MASK_MAX_WIDTH,
	[CSS_PROP_MIN_HEIGHT]            = UNIT_MASK_MIN_HEIGHT,
	[CSS_PROP_MIN_WIDTH]             = UNIT_MASK_MIN_WIDTH,
	[CSS_PROP_ORPHANS]               = UNIT_MASK_ORPHANS,
	[CSS_PROP_OUTLINE_COLOR]         = UNIT_MASK_OUTLINE_COLOR,
	[CSS_PROP_OUTLINE_STYLE]         = UNIT_MASK_OUTLINE_STYLE,
	[CSS_PROP_OUTLINE_WIDTH]         = UNIT_MASK_OUTLINE_WIDTH,
	[CSS_PROP_OVERFLOW_X]            = UNIT_MASK_OVERFLOW_X,
	[CSS_PROP_PADDING_TOP]           = UNIT_MASK_PADDING_SIDE,
	[CSS_PROP_PADDING_RIGHT]         = UNIT_MASK_PADDING_SIDE,
	[CSS_PROP_PADDING_BOTTOM]        = UNIT_MASK_PADDING_SIDE,
	[CSS_PROP_PADDING_LEFT]          = UNIT_MASK_PADDING_SIDE,
	[CSS_PROP_PAGE_BREAK_AFTER]      = UNIT_MASK_PAGE_BREAK_AFTER,
	[CSS_PROP_PAGE_BREAK_BEFORE]     = UNIT_MASK_PAGE_BREAK_BEFORE,
	[CSS_PROP_PAGE_BREAK_INSIDE]     = UNIT_MASK_PAGE_BREAK_INSIDE,
	[CSS_PROP_PAUSE_AFTER]           = UNIT_MASK_PAUSE_AFTER,
	[CSS_PROP_PAUSE_BEFORE]          = UNIT_MASK_PAUSE_BEFORE,
	[CSS_PROP_PITCH_RANGE]           = UNIT_MASK_PITCH_RANGE,
	[CSS_PROP_PITCH]                 = UNIT_MASK_PITCH,
	[CSS_PROP_PLAY_DURING]           = UNIT_MASK_PLAY_DURING,
	[CSS_PROP_POSITION]              = UNIT_MASK_POSITION,
	[CSS_PROP_QUOTES]                = UNIT_MASK_QUOTES,
	[CSS_PROP_REPRESENTATION]        = UNIT_MASK_REPRESENTATION,
	[CSS_PROP_RICHNESS]              = UNIT_MASK_RICHNESS,
	[CSS_PROP_RIGHT]                 = UNIT_MASK_RIGHT,
	[CSS_PROP_SPEAK_HEADER]          = UNIT_MASK_SPEAK_HEADER,
	[CSS_PROP_SPEAK_NUMERAL]         = UNIT_MASK_SPEAK_NUMERAL,
	[CSS_PROP_SPEAK_PUNCTUATION]     = UNIT_MASK_SPEAK_PUNCTUATION,
	[CSS_PROP_SPEAK]                 = UNIT_MASK_SPEAK,
	[CSS_PROP_SPEECH_RATE]           = UNIT_MASK_SPEECH_RATE,
	[CSS_PROP_STRESS]                = UNIT_MASK_STRESS,
	[CSS_PROP_TABLE_LAYOUT]          = UNIT_MASK_TABLE_LAYOUT,
	[CSS_PROP_TEXT_ALIGN]            = UNIT_MASK_TEXT_ALIGN,
	[CSS_PROP_TEXT_DECORATION]       = UNIT_MASK_TEXT_DECORATION,
	[CSS_PROP_TEXT_INDENT]           = UNIT_MASK_TEXT_INDENT,
	[CSS_PROP_TEXT_TRANSFORM]        = UNIT_MASK_TEXT_TRANSFORM,
	[CSS_PROP_TOP]                   = UNIT_MASK_TOP,
	[CSS_PROP_UNICODE_BIDI]          = UNIT_MASK_UNICODE_BIDI,
	[CSS_PROP_VERTICAL_ALIGN]        = UNIT_MASK_VERTICAL_ALIGN,
	[CSS_PROP_VISIBILITY]            = UNIT_MASK_VISIBILITY,
	[CSS_PROP_VOICE_FAMILY]          = UNIT_MASK_VOICE_FAMILY,
	[CSS_PROP_VOLUME]                = UNIT_MASK_VOLUME,
	[CSS_PROP_WHITE_SPACE]           = UNIT_MASK_WHITE_SPACE,
	[CSS_PROP_WIDOWS]                = UNIT_MASK_WIDOWS,
	[CSS_PROP_WIDTH]                 = UNIT_MASK_WIDTH,
	[CSS_PROP_WORD_SPACING]          = UNIT_MASK_WORD_SPACING,
	[CSS_PROP_Z_INDEX]               = UNIT_MASK_Z_INDEX,
	[CSS_PROP_OPACITY]               = UNIT_MASK_OPACITY,
	[CSS_PROP_BREAK_AFTER]           = UNIT_MASK_BREAK_AFTER,
	[CSS_PROP_BREAK_BEFORE]          = UNIT_MASK_BREAK_BEFORE,
	[CSS_PROP_BREAK_INSIDE]          = UNIT_MASK_BREAK_INSIDE,
	[CSS_PROP_COLUMN_COUNT]          = UNIT_MASK_COLUMN_COUNT,
	[CSS_PROP_COLUMN_FILL]           = UNIT_MASK_COLUMN_FILL,
	[CSS_PROP_COLUMN_GAP]            = UNIT_MASK_COLUMN_GAP,
	[CSS_PROP_COLUMN_RULE_COLOR]     = UNIT_MASK_COLUMN_RULE_COLOR,
	[CSS_PROP_COLUMN_RULE_STYLE]     = UNIT_MASK_COLUMN_RULE_STYLE,
	[CSS_PROP_COLUMN_RULE_WIDTH]     = UNIT_MASK_COLUMN_RULE_WIDTH,
	[CSS_PROP_COLUMN_SPAN]           = UNIT_MASK_COLUMN_SPAN,
	[CSS_PROP_COLUMN_WIDTH]          = UNIT_MASK_COLUMN_WIDTH,
	[CSS_PROP_WRITING_MODE]          = UNIT_MASK_WRITING_MODE,
	[CSS_PROP_OVERFLOW_Y]            = UNIT_MASK_OVERFLOW_Y,
	[CSS_PROP_BOX_SIZING]            = UNIT_MASK_BOX_SIZING,
	[CSS_PROP_ALIGN_CONTENT]         = UNIT_MASK_ALIGN_CONTENT,
	[CSS_PROP_ALIGN_ITEMS]           = UNIT_MASK_ALIGN_ITEMS,
	[CSS_PROP_ALIGN_SELF]            = UNIT_MASK_ALIGN_SELF,
	[CSS_PROP_FLEX_BASIS]            = UNIT_MASK_FLEX_BASIS,
	[CSS_PROP_FLEX_DIRECTION]        = UNIT_MASK_FLEX_DIRECTION,
	[CSS_PROP_FLEX_GROW]             = UNIT_MASK_FLEX_GROW,
	[CSS_PROP_FLEX_SHRINK]           = UNIT_MASK_FLEX_SHRINK,
	[CSS_PROP_FLEX_WRAP]             = UNIT_MASK_FLEX_WRAP,
	[CSS_PROP_JUSTIFY_CONTENT]       = UNIT_MASK_JUSTIFY_CONTENT,
	[CSS_PROP_ORDER]                 = UNIT_MASK_ORDER,
};
